<?php
/**
 * The Template for displaying Image Card Layout
 *
 * This template can be overridden by copying it to yourtheme/divi-blurb-extended/layouts/image_card.php.
 *
 * HOWEVER, on occasion divi-blurb-extended will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen.
 *
 * @author      Elicus Technologies <hello@elicus.com>
 * @link        https://www.elicus.com/
 * @copyright   2018 Elicus Technologies Private Limited
 * @version     1.2.2
 */
 
$ic_image   = ( '' !== trim( $ic_image ) ) ? sprintf( '<div class="et_pb_main_ic_image"><img src="%1$s" alt="%2$s" /></div>', esc_url( $ic_image ), esc_attr( $ic_image_alt ) ) : '';
$top_pos    = '';
$bottom_pos = 'style="margin-bottom: 0"';

if ( '' !== trim( $ic_image ) ) {
	
	if ( 'on' === $use_icon ) {
		
		if ( 'off' === $use_icon_font_size ) {
			/* 
			( 16(font-size/2) + 30(padding) )
			default font-size 32px
			*/
			$top_pos = 'style="margin-top: -46px"';
			if ( 'on' === $style_icon ) {
				/* 
				if border: 4px will be added  else: 0
				(total_font_size+border)/2 + 30(padding)
				total_font_size = icon_font_size + 30(icon_padding)
				*/
				$top_pos = ( 'on' === $use_shape_border ) ? 'style="margin-top: -63px"' : 'style="margin-top: -61px"';
			}
		} else {
			$top_pos = 'style="margin-top: -' . ( ( intval( $icon_font_size ) / 2 ) + 30 ) . 'px"';
			if ( 'on' === $style_icon ) {
				/* 
				if border: 4px will be added  else: 0
				(total_font_size+border)/2 + 30(padding)
				total_font_size = icon_font_size + 30(icon_padding)
				*/
				$top_pos = ( 'on' === $use_shape_border ) ? 'style="margin-top: -' . ( ( ( intval( $icon_font_size ) + 34 ) / 2 ) + 30 ) . 'px"' : 'style="margin-top: -' . ( ( ( intval( $icon_font_size ) + 30 ) / 2 ) + 30 ) . 'px"';
			}
		}
		$bottom_pos = '';
	} else {
		if ( '' !== $image ) {
			$top_pos    = 'style="margin-top: -70px"';
			$bottom_pos = '';
		}
	}
	
} else {
	$bottom_pos = '';
}

if ( 'off' !== $read_more_button ) {
	$read_more_text    = ( '' !== $read_more_text ) ? esc_html( $read_more_text ) : 'Read more';
	$read_more_target  = ( 'on' === $url_new_window )  ? ' target="_blank"' : '';
	$url               = ( '' !== $url ) ? esc_url( $url ) : '#';
	$data_icon         = ( 'on' == $read_more_use_icon && '' !== $read_more_icon && 'on' === $custom_read_more ) ? sprintf( ' data-icon="%1$s"', esc_attr( et_pb_process_font_icon( $read_more_icon ) ) ) : '';
	$custom_icon_class = ( 'on' == $read_more_use_icon && '' !== $read_more_icon && 'on' === $custom_read_more ) ? ' et_pb_custom_button_icon' : '';
	$button            = '<span class="et_pb_blurb_extended_btn"><a href="' . esc_url( $url ) . '"' . $data_icon . $read_more_target . ' class="et_pb_more_button et_pb_button' . $custom_icon_class . '">' . $read_more_text . '</a></span>';
} else {
	$button = '';
}

if ( 'on' == $use_icon ) {
	if ( '' !== $icon_hover_color ) {
		ET_Builder_Element::set_style( $render_slug, array(
			'selector'      => '%%order_class%%:hover .et-pb-icon',
			'declaration'   => sprintf( 'color: %1$s !important;', esc_html( $icon_hover_color ) ),
		));
	}
	
	if ( 'on' == $style_icon ) {
		if ( '' !== $shape_hover_color ) {
			if ( 'use_hexagon' !== $icon_shape ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'      => '%%order_class%%:hover .et-pb-icon',
					'declaration'   => sprintf( 'background-color: %1$s !important;', esc_html( $shape_hover_color ) ),
				));
			}
			
			if ( 'use_hexagon' == $icon_shape ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'      => '%%order_class%%:hover .hexagon',
					'declaration'   => sprintf( 'background-color: %1$s !important;', esc_html( $shape_hover_color ) ),
				));
			}
		}
		
		if ( 'on' == $use_shape_border ) {
			if ( '' !== $shape_border_hover_color ) {
				if ( 'use_hexagon' !== $icon_shape ) {
					ET_Builder_Element::set_style( $render_slug, array(
						'selector'      => '%%order_class%%:hover .et-pb-icon',
						'declaration'   => sprintf( 'border-color: %1$s !important;', esc_html( $shape_border_hover_color ) ),
					));
				}
				if ( 'use_hexagon' == $icon_shape ) {
					ET_Builder_Element::set_style( $render_slug, array(
						'selector'      => '%%order_class%%:hover .hexagon',
						'declaration'   => sprintf( 'border-color: %1$s !important;', esc_html( $shape_border_hover_color ) ),
					));
				}
			}
		}
	}
}

if ( '' !== $title_hover_color ) {
	ET_Builder_Element::set_style( $render_slug, array(
		'selector'      => '%%order_class%%:hover .et_pb_blurb_container .et_pb_module_header',
		'declaration'   => sprintf( 'color: %1$s !important;', esc_html( $title_hover_color ) ),
	));
	ET_Builder_Element::set_style( $render_slug, array(
		'selector'      => '%%order_class%%:hover .et_pb_blurb_container .et_pb_module_header a',
		'declaration'   => sprintf( 'color: %1$s !important;', esc_html( $title_hover_color ) ),
	));
}

if ( '' !== $text_hover_color ) {
	ET_Builder_Element::set_style( $render_slug, array(
		'selector'      => '%%order_class%%:hover .et_pb_blurb_container .et_pb_blurb_description',
		'declaration'   => sprintf( 'color: %1$s !important;', esc_html( $text_hover_color ) ),
	));
}

if ( '' !== $blurb_hover_color ) {
	ET_Builder_Element::set_style( $render_slug, array(
		'selector'      => '%%order_class%%.et_pb_blurb_extended:hover .et_pb_blurb_content',
		'declaration'   => sprintf( 'background: %1$s !important;', esc_html( $blurb_hover_color ) ),
	));
}

$blurb_content  = $this->content;

$layout =  '<div class="et_pb_blurb_content">'
                . $ic_image .'
                <div class="et_pb_blurb_container">
                    <span class="card-icon" '. $top_pos . $bottom_pos .'>'. $image .'</span>'
        		     . $title .'
        		     <div class="et_pb_blurb_description">'
        		        . $blurb_content .
        		        $button .
    	            '</div>
	            </div>
            </div> <!-- .et_pb_blurb_content -->';
