<?php
/**
 * The Template for displaying Borderbox Layout
 *
 * This template can be overridden by copying it to yourtheme/divi-blurb-extended/layouts/borderbox.php.
 *
 * HOWEVER, on occasion divi-blurb-extended will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen.
 *
 * @author      Elicus Technologies <hello@elicus.com>
 * @link        https://www.elicus.com/
 * @copyright   2018 Elicus Technologies Private Limited
 * @version     1.2.2
 */
 
$alignicon = ( $text_orientation == 'left' || $text_orientation == 'justified' ) ? 'left' : 'right';
if ( 'on' === $use_icon ) {
	if ( 'off' === $use_icon_font_size ) {
		
		$side = '-16px';
		$top  = '20px';
		$pad  = '36px';
		
		if ( 'on' === $style_icon ) {
			$top  = ( 'on' === $use_shape_border )  ? '22px'    : '20px';
			$side = ( 'on' === $use_shape_border )  ? '-34px'   : '-32px';
			$pad  = ( 'on' === $use_shape_border )  ? '34px'    : '32px';
		}
		
		if ( $icon_placement != 'top' ) {
			
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%% .borderbox .et_pb_main_blurb_image',
				'declaration'   => sprintf( $icon_placement . ': %1$s; top: %2$s;', esc_html( $side ), esc_html( $top ) ),
			));
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%% .borderbox .et_pb_blurb_container',
				'declaration'   => sprintf( 'padding-' . $icon_placement . ': %1$s;', esc_html( $pad ) ),
			));
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%%',
				'declaration'   => sprintf( 'padding-' . $icon_placement . ': %1$s;', esc_html( abs( $side ) . 'px' ) ),
			));
			
		}
		
		if ( $icon_placement == 'top' && $text_orientation !== 'center' ) {
			
			$side = '20px';
			$top  = '-16px';
			$pad  = '36px';
			
			if ( 'on' === $style_icon ) {
				$top = ( 'on' === $use_shape_border ) ? '-34px' : '-32px';
				$pad = ( 'on' === $use_shape_border ) ? '34px'  : '32px';
			}
			
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%% .borderbox .et_pb_main_blurb_image',
				'declaration'   => sprintf( '%3$s: %1$s; top: %2$s;', esc_html( $side ), esc_html( $top ), esc_html( $alignicon ) ),
			));
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%% .borderbox .et_pb_blurb_container',
				'declaration'   => sprintf( 'padding-top: %1$s;', esc_html( $pad ) ),
			));
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%%',
				'declaration'   => sprintf( 'padding-top: %1$s;', esc_html( abs( $top ) . 'px') ),
			));
		}
		
		if ( $icon_placement == 'top' && $text_orientation == 'center' ) {
			
			$top = '-16px';
			$pad = '36px';
			
			if ( 'on' === $style_icon ) {
				$top = ( 'on' === $use_shape_border ) ? '-34px' : '-32px';
				$pad = ( 'on' === $use_shape_border ) ? '34px'  : '32px';
			}
			
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%% .borderbox .et_pb_main_blurb_image',
				'declaration'   => 'left: -9999px; right: -9999px; top: ' . $top . '; width: 100%; margin: 0 auto;',
			));
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%% .borderbox .et_pb_blurb_container',
				'declaration'   => sprintf( 'padding-top: %1$s;', esc_html( $pad ) ),
			));
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%%',
				'declaration'   => sprintf( 'padding-top: %1$s;', esc_html( abs( $top ) . 'px') ),
			));
		}
		
	} else {
		$side = '-' . ( intval( $icon_font_size ) / 2 ) . 'px';
		$pad  = ( ( intval( $icon_font_size ) / 2 ) + 20 ) . 'px';
		$top  = '20px';
		
		if ( 'on' === $style_icon ) {
			$top  = ( 'on' === $use_shape_border ) ? '22px' : '20px';
			$side = ( 'on' === $use_shape_border ) ? '-' . ( ( intval( $icon_font_size ) + 36 ) / 2 ) . 'px' : '-' . ( ( intval( $icon_font_size ) + 32 ) / 2 ) . 'px';
			$pad  = ( 'on' === $use_shape_border ) ? ( ( intval( $icon_font_size ) + 36 ) / 2 ) . 'px' : ( ( intval( $icon_font_size ) + 32 ) / 2 ) . 'px';
		}
		
		if ( $icon_placement != 'top' ) {
			
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%% .borderbox .et_pb_main_blurb_image',
				'declaration'   => sprintf( $icon_placement . ': %1$s; top: %2$s;', esc_html( $side ), esc_html( $top ) ),
			));
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%% .borderbox .et_pb_blurb_container',
				'declaration'   => sprintf( 'padding-' . $icon_placement . ': %1$s;', esc_html( $pad ) ),
			));
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%%',
				'declaration'   => sprintf( 'padding-' . $icon_placement . ': %1$s;', esc_html( abs( $side ) . 'px') ),
			));
		}
		
		if ( $icon_placement == 'top' && $text_orientation !== 'center' ) {
			
			$side = '20px';
			$pad  = ( ( intval( $icon_font_size ) / 2 ) + 20 ) . 'px';
			$top  = '-' . ( intval( $icon_font_size ) / 2 ) . 'px';
			
			if ( 'on' === $style_icon ) {
				$top = ( 'on' === $use_shape_border ) ? '-' . ( ( intval( $icon_font_size ) + 36 ) / 2 ) . 'px' : '-' . ( ( intval( $icon_font_size ) + 32 ) / 2 ) . 'px';
				$pad = ( 'on' === $use_shape_border ) ? ( ( intval( $icon_font_size ) + 36 ) / 2 ) . 'px' : ( ( intval( $icon_font_size ) + 32 ) / 2 ) . 'px';
			}
			
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%% .borderbox .et_pb_main_blurb_image',
				'declaration'   => sprintf( '%3$s: %1$s; top: %2$s;', esc_html( $side ), esc_html( $top ), esc_html( $alignicon ) ),
			));	
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%% .borderbox .et_pb_blurb_container',
				'declaration'   => sprintf( 'padding-top: %1$s;', esc_html( $pad ) ),
			));
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%%',
				'declaration'   => sprintf( 'padding-' . $icon_placement . ': %1$s;', esc_html( abs( $top ) . 'px' ) ),
			));
		}
		
		if ( $icon_placement == 'top' && $text_orientation == 'center' ) {
			
			$pad = ( ( intval( $icon_font_size ) / 2 ) + 20 ) . 'px';
			$top = '-' . ( intval( $icon_font_size ) / 2 ) . 'px';
			
			if ( 'on' === $style_icon ) {
				$top = ( 'on' === $use_shape_border ) ? '-' . ( ( intval( $icon_font_size ) + 36 ) / 2 ) . 'px' : '-' . ( ( intval( $icon_font_size ) + 32 ) / 2 ) . 'px';
				$pad = ( 'on' === $use_shape_border ) ? ( ( intval( $icon_font_size ) + 36 ) / 2 ) . 'px' : ( ( intval( $icon_font_size ) + 32 ) / 2 ) . 'px';
			}
			
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%% .borderbox .et_pb_main_blurb_image',
				'declaration'   => 'left: -9999px; right: -9999px; top: ' . $top . '; width: 100%; margin: 0 auto;',
			));
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%% .borderbox .et_pb_blurb_container',
				'declaration'   => sprintf( 'padding-top: %1$s;', esc_html( $pad ) ),
			));
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%%',
				'declaration'   => sprintf( 'padding-top: %1$s;', esc_html( abs( $top ) . 'px') ),
			));
		}
		
	}
} else {
	$custom_padding = array();
	if($this->props['custom_padding']) {
		$custom_padding = explode('|', $this->props['custom_padding']);
	}
	$sidePosition = '-'.floatval( intval($image_max_width) / 2 ).'px';

	if ( $icon_placement === 'top' ) {										
		if(!empty($custom_padding) && $custom_padding['3'] !== '') {
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      =>  '.et_pb_blurb_extended%%order_class%%.et_pb_text_align_left .et_pb_blurb_position_top.borderbox.use-image .et_pb_main_blurb_image',
				'declaration'   =>  'left: '. $custom_padding[3].';',
			));
		}
		if(!empty($custom_padding) && $custom_padding[1] !== '') {
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      =>  '.et_pb_blurb_extended%%order_class%%.et_pb_text_align_right .et_pb_blurb_position_top.borderbox.use-image .et_pb_main_blurb_image',
				'declaration'   =>  'right: '. $custom_padding[1].';',
			));
		}
	}

	if ( $icon_placement === 'left' ) {			
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      =>  '.et_pb_blurb_extended%%order_class%% .et_pb_blurb_position_left.borderbox.use-image .et_pb_blurb_container',
				'declaration'   =>  'padding-left: '.abs(floatval($sidePosition)).'px;',
			));
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      =>  '.et_pb_blurb_extended%%order_class%% .et_pb_blurb_position_left.borderbox.use-image',
				'declaration'   =>  'padding-left: '.abs(floatval($sidePosition)).'px;',
			));
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      =>  '.et_pb_blurb_extended%%order_class%% .et_pb_blurb_position_left.borderbox.use-image .et_pb_main_blurb_image',
				'declaration'   =>  'left: '.$sidePosition.';'
			));
		if(!empty($custom_padding) && $custom_padding[0] !== '') {
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      =>  '.et_pb_blurb_extended%%order_class%% .et_pb_blurb_position_left.borderbox.use-image .et_pb_main_blurb_image',
				'declaration'   =>  'top: '.$custom_padding[0].';',
			));
		}
	}

	if ( $icon_placement === 'right' ) {
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      =>  '.et_pb_blurb_extended%%order_class%% .et_pb_blurb_position_right.borderbox.use-image .et_pb_blurb_container',
				'declaration'   =>  'padding-right: '.abs(floatval($sidePosition)).'px;',
			));
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      =>  '.et_pb_blurb_extended%%order_class%% .et_pb_blurb_position_right.borderbox.use-image',
				'declaration'   =>  'padding-right: '.abs(floatval($sidePosition)).'px;',
			));
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      =>  '.et_pb_blurb_extended%%order_class%% .et_pb_blurb_position_right.borderbox.use-image .et_pb_main_blurb_image',
				'declaration'   =>  'right: '.$sidePosition.';',
			));
		if(!empty($custom_padding) && $custom_padding[0] !== '') {
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      =>  '.et_pb_blurb_extended%%order_class%% .et_pb_blurb_position_right.borderbox.use-image .et_pb_main_blurb_image',
				'declaration'   =>  'top: '.$custom_padding[0].';',
			));
		}
	}
}

if ( 'off' !== $read_more_button ) {
	$read_more_text     = ( '' !== $read_more_text )        ? esc_html( $read_more_text ) : 'Read more';
	$read_more_target   = ( 'on' === $url_new_window )   ? ' target="_blank"' : '';
	$url                = ( '' !== $url ) ? esc_url( $url ) : '#';
	$data_icon          = ( 'on' == $read_more_use_icon && '' !== $read_more_icon && 'on' === $custom_read_more ) ? sprintf( ' data-icon="%1$s"', esc_attr( et_pb_process_font_icon( $read_more_icon ) ) ) : '';
	$custom_icon_class  = ( 'on' == $read_more_use_icon && '' !== $read_more_icon && 'on' === $custom_read_more ) ? ' et_pb_custom_button_icon' : '';
	$button            = '<span class="et_pb_blurb_extended_btn"><a href="' . esc_url( $url ) . '"' . $data_icon . $read_more_target . ' class="et_pb_more_button et_pb_button' . $custom_icon_class . '">' . $read_more_text . '</a></span>';
} else {
	$button = '';
}

if ( 'on' == $use_icon ) {
	if ( '' !== $icon_hover_color ) {
		ET_Builder_Element::set_style( $render_slug, array(
			'selector'      => '%%order_class%%:hover .et-pb-icon',
			'declaration'   => sprintf( 'color: %1$s !important;', esc_html( $icon_hover_color ) ),
		));
	}
	
	if ( 'on' == $style_icon ) {
		if ( '' !== $shape_hover_color ) {
			if ( 'use_hexagon' !== $icon_shape ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'      => '%%order_class%%:hover .et-pb-icon',
					'declaration'   => sprintf( 'background-color: %1$s !important;', esc_html( $shape_hover_color ) ),
				));
			}
			
			if ( 'use_hexagon' == $icon_shape ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'      => '%%order_class%%:hover .hexagon',
					'declaration'   => sprintf( 'background-color: %1$s !important;', esc_html( $shape_hover_color ) ),
				));
			}
		}
		
		if ( 'on' == $use_shape_border ) {
			if ( '' !== $shape_border_hover_color ) {
				if ( 'use_hexagon' !== $icon_shape ) {
					ET_Builder_Element::set_style( $render_slug, array(
						'selector'      => '%%order_class%%:hover .et-pb-icon',
						'declaration'   => sprintf( 'border-color: %1$s !important;', esc_html( $shape_border_hover_color ) ),
					));
				}
				if ( 'use_hexagon' == $icon_shape ) {
					ET_Builder_Element::set_style( $render_slug, array(
						'selector'      => '%%order_class%%:hover .hexagon',
						'declaration'   => sprintf( 'border-color: %1$s !important;', esc_html( $shape_border_hover_color ) ),
					));
				}
			}
		}
	}
}

if ( '' !== $title_hover_color ) {
	ET_Builder_Element::set_style( $render_slug, array(
		'selector'      => '%%order_class%%:hover .et_pb_blurb_container .et_pb_module_header',
		'declaration'   => sprintf( 'color: %1$s !important;', esc_html( $title_hover_color ) ),
	));
	ET_Builder_Element::set_style( $render_slug, array(
		'selector'      => '%%order_class%%:hover .et_pb_blurb_container .et_pb_module_header a',
		'declaration'   => sprintf( 'color: %1$s !important;', esc_html( $title_hover_color ) ),
	));
}

if ( '' !== $text_hover_color ) {
	ET_Builder_Element::set_style( $render_slug, array(
		'selector'      => '%%order_class%%:hover .et_pb_blurb_container .et_pb_blurb_description',
		'declaration'   => sprintf( 'color: %1$s !important;', esc_html( $text_hover_color ) ),
	));
}

if ( '' !== $blurb_hover_color ) {
	ET_Builder_Element::set_style( $render_slug, array(
		'selector'      => '%%order_class%%.et_pb_blurb_extended:hover .et_pb_blurb_content',
		'declaration'   => sprintf( 'background: %1$s !important;', esc_html( $blurb_hover_color ) ),
	));
}

if ( '' !== $borderbox_border_color ) {
	ET_Builder_Element::set_style( $render_slug, array(
		'selector'      => '%%order_class%% .' . $blurb_layout . ' .et_pb_blurb_content',
		'declaration'   => sprintf( 'border-color: %1$s;', esc_html( $borderbox_border_color ) ),
	));
}

if ( '' !== $borderbox_hover_border_color ) {
	ET_Builder_Element::set_style( $render_slug, array(
		'selector'      => '%%order_class%% .' . $blurb_layout . ':hover .et_pb_blurb_content',
		'declaration'   => sprintf( 'border-color: %1$s;', esc_html( $borderbox_hover_border_color ) ),
	));
}

$blurb_content  = $this->content;

$layout =   '<div class="et_pb_blurb_content">'
                . $image .'
                <div class="et_pb_blurb_container">
    		    '. $title .'
        		    <div class="et_pb_blurb_description">'
        		     . $blurb_content .
        		     $button .
    	            '</div>
	            </div>
            </div> <!-- .et_pb_blurb_content -->';
