<?php
/**
 * @author      Elicus Technologies <hello@elicus.com>
 * @link        https://www.elicus.com/
 * @copyright   2018 Elicus Technologies Private Limited
 * @version     1.2.0
 */

class El_DiviBlurbExtended extends DiviExtension {

	/**
	 * The gettext domain for the extension's translations.
	 *
	 * @since 1.1.0
	 *
	 * @var string
	 */
	public $gettext_domain = 'et_builder';

	/**
	 * The extension's WP Plugin name.
	 *
	 * @since 1.1.0
	 *
	 * @var string
	 */
	public $name = 'divi-blurb-extended';

	/**
	 * The extension's version
	 *
	 * @since 1.1.0
	 *
	 * @var string
	 */
	public $version = ELICUS_BLURB_VERSION;

	/**
	 * El_DiviBlurbExtended constructor.
	 *
	 * @param string $name
	 * @param array  $args
	 */
	public function __construct( $name = 'divi-blurb-extended', $args = array() ) {
		$this->plugin_dir     = plugin_dir_path( __FILE__ );
		$this->plugin_dir_url = plugin_dir_url( $this->plugin_dir );

		parent::__construct( $name, $args );
		$this->plugin_setup();
	}

	/**
	 * El_DiviBlurbExtended plugin setup function.
	 *
	 */
	public function plugin_setup() {
		require_once plugin_dir_path( __FILE__ ) . 'src/functions.php';
		require_once plugin_dir_path( __FILE__ ) . 'src/class-update.php';
	}
}

new El_DiviBlurbExtended;
