<?php

	class DiviMegaPro_Helper {
		
		public function __construct() {
			
		}
		
		public static function get_all_wordpress_menus(){
			return get_terms( 'nav_menu', array( 'hide_empty' => true ) ); 
		}
		
		
		public static function prepareMenu( $key = NULL )
		{
			try {
				
				if ( !$key ) {
					
					throw new InvalidArgumentException( 'DiviMegaPro_Helper::prepareMenu > Required var $key');
					
				}
				
				// it is an url with hash divimegapros?
				if ( strpos( $key, "#" ) !== false ) {
					
					$exploded_url = explode( "#", $key );
					
					if ( isset( $exploded_url[1] ) ) {
						
						$key = str_replace( 'divimegapro-', '', $exploded_url[1] );
					}
				}
				
				$key = str_replace( 'unique_id_', '', $key );
				$key = str_replace( 'divimegapro-', '', $key );
				
				if ( $key == '' ) {
					return NULL;
				}
				
				if ( !self::barIsPublished( $key ) ) {
					
					return NULL;
				}
				
				return $key;
				
			} catch (Exception $e) {
				
				DiviMegaPro_Controller::log( $e );
				
				return NULL;
			}
		}
		
		
		private static function barIsPublished( $key ) {
			
			try {
			
				$post = get_post_status( $key );
			
			} catch (Exception $e) {
			
				DiviMegaPro_Controller::log( $e );
				
				return FALSE;
			}
			
			if ( $post != 'publish' ) {
				
				return FALSE;
			}
			
			return TRUE;
		}
		
		
		// Checks multidimensional array like in_array function.
		public static function in_multiarray($elem, $array)
		{
			$top = sizeof($array) - 1;
			$bottom = 0;
			while($bottom <= $top)
			{
				if($array[$bottom] == $elem)
					return true;
				else
					if(is_array($array[$bottom]))
						if(in_multiarray($elem, ($array[$bottom])))
							return true;
					   
				$bottom++;
			}       
			return false;
		}
		
		
		// Fastest way to check if a string is JSON
		public static function isJson($string) {
		
			json_decode($string);
			
			return ( json_last_error() == JSON_ERROR_NONE );
		}
		
		
		public static function convertDateToUTC( $date = null, $timezone = DIVI_MEGA_PRO_SERVER_TIMEZONE, $format = DIVI_MEGA_PRO_SCHEDULING_DATETIME_FORMAT ) {
			
			if ( $date === null ) {
				
				return;
			}
			
			if ( !self::validateDate( $date, $format ) ) {
				
				return;
			}
			
			$date = new DateTime( $date, new DateTimeZone( $timezone ) );
			$date->setTimezone( new DateTimeZone( DIVI_MEGA_PRO_SERVER_TIMEZONE ) );
			$str_server_now = $date->format( $format );
			
			return $str_server_now;
		}
		
		
		public static function convertDateToUserTimezone( $date = null, $format = DIVI_MEGA_PRO_SCHEDULING_DATETIME_FORMAT ) {
			
			if ( $date === null ) {
				
				return;
			}
			
			if ( !self::validateDate( $date, $format ) ) {
				
				return;
			}
			
			$divimegapros_settings = get_option( 'dmp_settings' );
			
			$timezone = DIVI_MEGA_PRO_SERVER_TIMEZONE;
			
			if ( isset( $divimegapros_settings['dmp_timezone'] ) ) {
				
				$timezone = $divimegapros_settings['dmp_timezone'];
			}
			
			$date = new DateTime( $date, new DateTimeZone( DIVI_MEGA_PRO_SERVER_TIMEZONE ) );
			$date->setTimezone( new DateTimeZone( $timezone ) );
			$str_server_now = $date->format( $format );
			
			return $str_server_now;
		}
		
		
		public static function validateDate( $dateStr, $format ) {
			
			$date = DateTime::createFromFormat($format, $dateStr);
			
			return $date && ($date->format($format) === $dateStr);
		}
		
		
		public static function formatContent( $pee, $br = true ) {
			
			$pre_tags = array();

			if ( trim($pee) === '' )
				return '';

			/*
			 * Pre tags shouldn't be touched by autop.
			 * Replace pre tags with placeholders and bring them back after autop.
			 */
			if ( strpos($pee, '<pre') !== false ) {
				$pee_parts = explode( '</pre>', $pee );
				$last_pee = array_pop($pee_parts);
				$pee = '';
				$i = 0;

				foreach ( $pee_parts as $pee_part ) {
					$start = strpos($pee_part, '<pre');

					// Malformed html?
					if ( $start === false ) {
						$pee .= $pee_part;
						continue;
					}

					$name = "<pre wp-pre-tag-$i></pre>";
					$pre_tags[$name] = substr( $pee_part, $start ) . '</pre>';

					$pee .= substr( $pee_part, 0, $start ) . $name;
					$i++;
				}

				$pee .= $last_pee;
			}
			// Change multiple <br>s into two line breaks, which will turn into paragraphs.
			$pee = preg_replace('|<br\s*/?>\s*<br\s*/?>|', "\n\n", $pee);
			
			$pee = str_replace(array("\r\n\r\n", "\r\r"), '<br /><br />', $pee);

			$allblocks = '(?:table|thead|tfoot|caption|col|colgroup|tbody|tr|td|th|div|dl|dd|dt|ul|ol|li|pre|form|map|area|blockquote|address|math|style|p|h[1-6]|hr|fieldset|legend|section|article|aside|hgroup|header|footer|nav|figure|figcaption|details|menu|summary)';

			// Add a double line break above block-level opening tags.
			$pee = preg_replace('!(<' . $allblocks . '[\s/>])!', "\n\n$1", $pee);

			// Add a double line break below block-level closing tags.
			$pee = preg_replace('!(</' . $allblocks . '>)!', "$1\n\n", $pee);

			// Standardize newline characters to "\n".
			$pee = str_replace(array("\r\n", "\r"), "\n", $pee);

			// Find newlines in all elements and add placeholders.
			$pee = wp_replace_in_html_tags( $pee, array( "\n" => " <!-- wpnl --> " ) );

			// Collapse line breaks before and after <option> elements so they don't get autop'd.
			if ( strpos( $pee, '<option' ) !== false ) {
				$pee = preg_replace( '|\s*<option|', '<option', $pee );
				$pee = preg_replace( '|</option>\s*|', '</option>', $pee );
			}

			/*
			 * Collapse line breaks inside <object> elements, before <param> and <embed> elements
			 * so they don't get autop'd.
			 */
			if ( strpos( $pee, '</object>' ) !== false ) {
				$pee = preg_replace( '|(<object[^>]*>)\s*|', '$1', $pee );
				$pee = preg_replace( '|\s*</object>|', '</object>', $pee );
				$pee = preg_replace( '%\s*(</?(?:param|embed)[^>]*>)\s*%', '$1', $pee );
			}

			/*
			 * Collapse line breaks inside <audio> and <video> elements,
			 * before and after <source> and <track> elements.
			 */
			if ( strpos( $pee, '<source' ) !== false || strpos( $pee, '<track' ) !== false ) {
				$pee = preg_replace( '%([<\[](?:audio|video)[^>\]]*[>\]])\s*%', '$1', $pee );
				$pee = preg_replace( '%\s*([<\[]/(?:audio|video)[>\]])%', '$1', $pee );
				$pee = preg_replace( '%\s*(<(?:source|track)[^>]*>)\s*%', '$1', $pee );
			}

			// Collapse line breaks before and after <figcaption> elements.
			if ( strpos( $pee, '<figcaption' ) !== false ) {
				$pee = preg_replace( '|\s*(<figcaption[^>]*>)|', '$1', $pee );
				$pee = preg_replace( '|</figcaption>\s*|', '</figcaption>', $pee );
			}

			// Remove more than two contiguous line breaks.
			$pee = preg_replace("/\n\n+/", "\n\n", $pee);

			// Split up the contents into an array of strings, separated by double line breaks.
			$pees = preg_split('/\n\s*\n/', $pee, -1, PREG_SPLIT_NO_EMPTY);

			// Reset $pee prior to rebuilding.
			$pee = '';

			// Rebuild the content as a string, wrapping every bit with a <p>.
			foreach ( $pees as $tinkle ) {
				$pee .= trim($tinkle, "\n") . "\n";
			}

			// Under certain strange conditions it could create a P of entirely whitespace.
			$pee = preg_replace('|<p>\s*</p>|', '', $pee);

			// Add a closing <p> inside <div>, <address>, or <form> tag if missing.
			$pee = preg_replace('!<p>([^<]+)</(div|address|form)>!', "<p>$1</p></$2>", $pee);

			// If an opening or closing block element tag is wrapped in a <p>, unwrap it.
			$pee = preg_replace('!<p>\s*(</?' . $allblocks . '[^>]*>)\s*</p>!', "$1", $pee);

			// In some cases <li> may get wrapped in <p>, fix them.
			$pee = preg_replace("|<p>(<li.+?)</p>|", "$1", $pee);

			// If a <blockquote> is wrapped with a <p>, move it inside the <blockquote>.
			$pee = preg_replace('|<p><blockquote([^>]*)>|i', "<blockquote$1><p>", $pee);
			$pee = str_replace('</blockquote></p>', '</p></blockquote>', $pee);

			// If an opening or closing block element tag is preceded by an opening <p> tag, remove it.
			$pee = preg_replace('!<p>\s*(</?' . $allblocks . '[^>]*>)!', "$1", $pee);

			// If an opening or closing block element tag is followed by a closing <p> tag, remove it.
			$pee = preg_replace('!(</?' . $allblocks . '[^>]*>)\s*</p>!', "$1", $pee);

			// Optionally insert line breaks.
			if ( $br ) {
				// Replace newlines that shouldn't be touched with a placeholder.
				$pee = preg_replace_callback('/<(script|style).*?<\/\\1>/s', '_autop_newline_preservation_helper', $pee);

				// Normalize <br>
				$pee = str_replace( array( '<br>', '<br/>' ), '<br />', $pee );
				
				// Replace any new line characters that aren't preceded by a <br /> with a <br />.
				$pee = preg_replace('|(?<!<br />)\s*\n|', "<br />\n", $pee);

				// Replace newline placeholders with newlines.
				$pee = str_replace('<WPPreserveNewline />', "\n", $pee);
			}
			
			// If a <br /> tag is after an opening or closing block tag, remove it.
			$pee = preg_replace('!(</?' . $allblocks . '[^>]*>)\s*<br />!', "$1", $pee);
			
			// If 2 <br /><br /> tags are after an opening or closing block tag, remove them.
			$pee = preg_replace('!(</?' . $allblocks . '[^>]*>)\s*<br /><br />!', "$1", $pee);

			// If a <br /> tag is before a subset of opening or closing block tags, remove it.
			$pee = preg_replace('!<br />(\s*</?(?:p|li|div|dl|dd|dt|th|pre|td|ul|ol|span|input|label|fieldset|legend|optgroup|option|select|form|textarea|button|datalist|keygen|output)[^>]*>)!', '$1', $pee);
			
			// If 2 <br /><br /> tags are before a subset of opening or closing block tags, remove them.
			$pee = preg_replace('!<br /><br />(\s*</?(?:p|li|div|dl|dd|dt|th|pre|td|ul|ol|span|input|label|fieldset|legend|optgroup|option|select|form|textarea|button|datalist|keygen|output)[^>]*>)!', '$1', $pee);
			
			$pee = preg_replace( "|\n</p>$|", '</p>', $pee );

			// Replace placeholder <pre> tags with their original content.
			if ( !empty($pre_tags) )
				$pee = str_replace(array_keys($pre_tags), array_values($pre_tags), $pee);

			// Restore newlines in all elements.
			if ( false !== strpos( $pee, '<!-- wpnl -->' ) ) {
				$pee = str_replace( array( ' <!-- wpnl --> ', '<!-- wpnl -->' ), "\n", $pee );
			}

			return $pee;
		}
	}
	
	