<?php
/**
 * @author      Elicus Technologies <hello@elicus.com>
 * @link        https://www.elicus.com/
 * @copyright   2018 Elicus Technologies Private Limited
 * @version     1.2.0
 */
 
defined('ABSPATH') or die('No script kiddies please!');

if ( ! function_exists( 'el_blurb_admin_styles' ) ) {
	function el_blurb_admin_styles() {
		wp_register_style( 'el-blurb-admin-style', plugins_url( 'styles/style-admin.min.css', dirname(__DIR__) ), array(), ELICUS_BLURB_VERSION );
		wp_enqueue_style( 'el-blurb-admin-style' );
	}
	add_action( 'admin_enqueue_scripts', 'el_blurb_admin_styles', 999 );
}

if ( ! function_exists( 'el_blurb_update_options' ) ) {
    function el_blurb_update_options( $options = array('') ) {
        $plugin_options = get_option( ELICUS_BLURB_OPTION );
        if ( ! empty( $options ) ) {
            foreach( $options as $index => $value ){
                $plugin_options[$index] = $value;
            }
            update_option( ELICUS_BLURB_OPTION, $plugin_options );
        }
    }
}

if ( ! function_exists( 'el_blurb_upgrade_completed' ) ) {
    
    function el_blurb_upgrade_completed( $upgrader_object, $options ) {
        $blurb_plugin = 'divi-blurb-extended/divi-blurb-extended.php';
        if( $options['action'] == 'update' && $options['type'] == 'plugin' && isset( $options['plugins'] ) ) {
            foreach ( $options['plugins'] as $plugin ) {
                if( $plugin == $blurb_plugin ) {
                    $plugin_abs_path    = ABSPATH.'wp-content/plugins/' . $blurb_plugin;
                    $plugin_data        = get_plugin_data( $plugin_abs_path );
                    $plugin_options     = get_option( ELICUS_BLURB_OPTION );
                    $update_options     = array(
						'installed_version' => $plugin_data['Version'],
						'should_set_update'	=> 'false',
					);
                    foreach ( $update_options as $index => $value ) {
                        $plugin_options[$index] = $value;
                    }
                    update_option( ELICUS_BLURB_OPTION, $plugin_options );
                }
            }
        }
    }
    add_action( 'upgrader_process_complete', 'el_blurb_upgrade_completed', 10, 2 );
}

if ( ! function_exists( 'el_blurb_fill_options' ) ) {
    function el_blurb_fill_options() {
        $plugin_options = get_option( ELICUS_BLURB_OPTION );
        if ( ! isset( $plugin_options ) || empty( $plugin_options ) ) {
            $plugin_data = array(
                'name'              => 'Divi Blurb Extended',
                'slug'              => 'divi-blurb-extended',
                'path'              => 'divi-blurb-extended/divi-blurb-extended.php',
                'installed_version' => ELICUS_BLURB_VERSION,
                'current_version'   => ELICUS_BLURB_VERSION,
                'metadata_url'      => 'http://cdn.elicus.com',
				'last_checked'		=> time(),
				'should_set_update'	=> 'false',
				'update_metadata'	=> '',
            );
            update_option( ELICUS_BLURB_OPTION, $plugin_data );
        }
    }
}
add_action( 'admin_init', 'el_blurb_fill_options' );
