<?php
/**
 * The Template for displaying Fipbox Layout
 *
 * This template can be overridden by copying it to yourtheme/divi-blurb-extended/layouts/flipbox.php.
 *
 * HOWEVER, on occasion divi-blurb-extended will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen.
 *
 * @author      Elicus Technologies <hello@elicus.com>
 * @link        https://www.elicus.com/
 * @copyright   2018 Elicus Technologies Private Limited
 * @version     1.2.0
 */
 
if ( 'color' == $fb_front_background ) {
	if ( '' !== $fb_front_color ) {
		ET_Builder_Element::set_style( $render_slug, array(
			'selector'      => '%%order_class%% .front',
			'declaration'   => sprintf( 'background-color: %1$s;', esc_html( $fb_front_color ) ),
		));
	}
}

if ( 'image' == $fb_front_background ) {
	if ( '' !== $fb_front_image ) {
		ET_Builder_Element::set_style( $render_slug, array(
			'selector'      => '%%order_class%% .front',
			'declaration'   => sprintf( 'background-image: url(%1$s); background-size: cover; background-position: center; background-repeat: no-repeat;', esc_html( $fb_front_image ) ),
		));
	} else {
		ET_Builder_Element::set_style( $render_slug, array(
			'selector'      => '%%order_class%% .front',
			'declaration'   => 'background: #fff;',
		));
	}
}

if ( 'color' == $fb_back_background ) {
	if ( '' !== $fb_back_color ) {
		ET_Builder_Element::set_style( $render_slug, array(
			'selector'      => '%%order_class%% .back',
			'declaration'   => sprintf( 'background-color: %1$s;', esc_html( $fb_back_color ) ),
		));
	}
}

if ( 'image' == $fb_back_background ) {
	if ( '' !== $fb_back_image ) {
		ET_Builder_Element::set_style( $render_slug, array(
			'selector'      => '%%order_class%% .back',
			'declaration'   => sprintf( 'background-image: url(%1$s); background-size: cover; background-position: center; background-repeat: no-repeat;', esc_html( $fb_back_image ) ),
		));
	} else {
		ET_Builder_Element::set_style( $render_slug, array(
			'selector'      => '%%order_class%% .back',
			'declaration'   => 'background: #fff;',
		));
	}
}

if ( '' !== $fb_height || '' !== $fb_height_tablet || '' !== $fb_height_phone ) {
	$fb_height_selector = '%%order_class%% .flipbox .et_pb_blurb_content';
	$fb_height_responsive_active = et_pb_get_responsive_status( $fb_height_last_edited );

	$fb_height_values = array(
		'desktop' => $fb_height,
		'tablet'  => $fb_height_responsive_active ? $fb_height_tablet : '',
		'phone'   => $fb_height_responsive_active ? $fb_height_phone : '',
	);

	et_pb_generate_responsive_css( $fb_height_values, $fb_height_selector, 'height', $render_slug );
}


if ( 'on' == $use_icon ) {
	if ( '' !== $icon_hover_color ) {
		ET_Builder_Element::set_style( $render_slug, array(
			'selector'      => '%%order_class%%:hover .et-pb-icon',
			'declaration'   => sprintf( 'color: %1$s !important;', esc_html( $icon_hover_color ) ),
		));
	}
	
	if ( 'on' == $style_icon ) {
		if ( '' !== $shape_hover_color ) {
			if ( 'use_hexagon' !== $icon_shape ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'      => '%%order_class%%:hover .et-pb-icon',
					'declaration'   => sprintf( 'background-color: %1$s !important;', esc_html( $shape_hover_color ) ),
				));
			}
			
			if ( 'use_hexagon' == $icon_shape ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'      => '%%order_class%%:hover .hexagon',
					'declaration'   => sprintf( 'background-color: %1$s !important;', esc_html( $shape_hover_color ) ),
				));
			}
		}
		
		if ( 'on' == $use_shape_border ) {
			if ( '' !== $shape_border_hover_color ) {
				if ( 'use_hexagon' !== $icon_shape ) {
					ET_Builder_Element::set_style( $render_slug, array(
						'selector'      => '%%order_class%%:hover .et-pb-icon',
						'declaration'   => sprintf( 'border-color: %1$s !important;', esc_html( $shape_border_hover_color ) ),
					));
				}
				if ( 'use_hexagon' == $icon_shape ) {
					ET_Builder_Element::set_style( $render_slug, array(
						'selector'      => '%%order_class%%:hover .hexagon',
						'declaration'   => sprintf( 'border-color: %1$s !important;', esc_html( $shape_border_hover_color ) ),
					));
				}
			}
		}
	}
}

if ( '' !== $title_hover_color ) {
	ET_Builder_Element::set_style( $render_slug, array(
		'selector'      => '%%order_class%%:hover .et_pb_blurb_container .et_pb_module_header',
		'declaration'   => sprintf( 'color: %1$s !important;', esc_html( $title_hover_color ) ),
	));
	ET_Builder_Element::set_style( $render_slug, array(
		'selector'      => '%%order_class%%:hover .et_pb_blurb_container .et_pb_module_header a',
		'declaration'   => sprintf( 'color: %1$s !important;', esc_html( $title_hover_color ) ),
	));
}

if ( '' !== $text_hover_color ) {
	ET_Builder_Element::set_style( $render_slug, array(
		'selector'      => '%%order_class%%:hover .et_pb_blurb_container .et_pb_blurb_description',
		'declaration'   => sprintf( 'color: %1$s !important;', esc_html( $text_hover_color ) ),
	));
}


if ( 'off' !== $read_more_button ) {
	$read_more_text     = ( '' !== $read_more_text ) ? esc_html( $read_more_text ) : 'Read more';
	$read_more_target   = ( 'on' === $url_new_window )  ? ' target="_blank"' : '';
	$url                = ( '' !== $url ) ? esc_url( $url ) : '#';
	$data_icon          = ( 'on' == $read_more_use_icon && '' !== $read_more_icon && 'on' === $custom_read_more ) ? sprintf( ' data-icon="%1$s"', esc_attr( et_pb_process_font_icon( $read_more_icon ) ) ) : '';
	$custom_icon_class  = ( 'on' == $read_more_use_icon && '' !== $read_more_icon && 'on' === $custom_read_more ) ? ' et_pb_custom_button_icon' : '';
	$button            = '<span class="et_pb_blurb_extended_btn"><a href="' . esc_url( $url ) . '"' . $data_icon . $read_more_target . ' class="et_pb_more_button et_pb_button' . $custom_icon_class . '">' . $read_more_text . '</a></span>';
} else {
	$button = '';
}

$blurb_content  = $this->content;

$layout = '<div class="et_pb_blurb_content">
                <div class="front">
                    <div class="before-flip">
                        <div class="before-flip-content">' . $image . '
                            <div class="et_pb_blurb_container">
                		    ' . $title . '
                            </div>
                        </div>
                    </div>
                </div>
                <div class="back">
                    <div class="after-flip">
        	            <div class="et_pb_blurb_container">
            		    '. $title .'
                		    <div class="et_pb_blurb_description">'
                		     . $blurb_content .
                		     $button .
            	            '</div>
        	            </div>
        	        </div>
        	   </div>
            </div> <!-- .et_pb_blurb_content -->';
