<?php
/**
 * @author      Elicus Technologies <hello@elicus.com>
 * @link        https://www.elicus.com/
 * @copyright   2018 Elicus Technologies Private Limited
 * @version     1.2.2
 */

class El_Blurb_Module extends ET_Builder_Module {

	protected $module_credits = array(
		'module_uri' => 'https://diviextended.com/product/divi-blurb-extended/',
		'author'     => 'Elicus Technologies',
		'author_uri' => 'https://elicus.com',
	);

	public function init() {
		$this->name             = esc_html__( 'Divi Blurb Extended', 'et_builder' );
		$this->slug       		= 'et_pb_blurb_extended';
		$this->main_css_element = '%%order_class%%.et_pb_blurb_extended';
		$this->vb_support 		= 'on';
	}

	public function get_settings_modal_toggles() {
        return array(
            'general' => array(
                'toggles' => array(
                    'main_content' => array(
                        'title' => esc_html__( 'Blurb Content', 'et_builder' ),
                    ),
                    'link' => array(
                        'title' => esc_html__( 'Blurb Link', 'et_builder' ),
                    ),
                    'button' => array(
                        'title' => esc_html__( 'Button', 'et_builder' ),
                    ),
                    'image' => array(
                        'title' => esc_html__( 'Image & Icon', 'et_builder' ),
                    ),
                ),
            ),
            'advanced' => array(
                'toggles' => array(
                    'layout_settings' => array(
                        'title' => esc_html__( 'Layout', 'et_builder' ),
                        'priority'  => 1,
                    ),
                    'content_background' => array(
                        'title' => esc_html__( 'Content Background', 'et_builder' ),
                        'priority'  => 2,
                    ),
                    'flipbox_layout' => array(
                        'title' => esc_html__( 'Flipbox Settings', 'et_builder' ),
                        'priority'  => 3,
                    ),
                    'easebox_layout' => array(
                        'title' => esc_html__( 'Easebox', 'et_builder' ),
                        'priority'  => 3,
                    ),
                    'image_card_layout' => array(
                        'title' => esc_html__( 'Image Card', 'et_builder' ),
                        'priority'  => 3,
                    ),
                    'borderbox_layout' => array(
                        'title' => esc_html__( 'Borderbox', 'et_builder' ),
                        'priority'  => 3,
                    ),
                    'icon_settings' => array(
                        'title' => esc_html__( 'Image & Icon', 'et_builder' ),
                        'priority'  => 4,
                    ),
                    'text_settings' => array(
                        'title'     => esc_html__( 'Blurb Text Settings', 'et_builder' ),
                        'priority'  => 5,
                        'sub_toggles'	=> array(
                        						'blurb_text'		=> array(
												'name'		=> 'General',
											),
												'title_text'		=> array(
												'name'		=> 'Title',
											),
												'body_text'		=> array(
												'name'		=> 'Content',
											),
										),
                        'tabbed_subtoggles'	=> true,
                    ),
                    'hover_state' => array(
                        'title' => esc_html__( 'Hover State', 'et_builder' ),
                        'priority'  => 6,
                        'sub_toggles'	=> array(
                        						'text_hover'		=> array(
													'name'		=> 'Text',
												),
                        						'button_hover'		=> array(
													'name'		=> 'Button',
												),
												'blurb_hover'		=> array(
													'name'		=> 'Elements',
												),
											),
                        'tabbed_subtoggles'	=> true,
                    ),
                    'width' => array(
    					'title'    => esc_html__( 'Sizing', 'et_builder' ),
    					'priority' => 7,
    				),
                ),
            ),
        );
    }
    
    public function get_advanced_fields_config() {
        return array(
            'fonts' => array(
                'header' => array(
                    'label'     => esc_html__( 'Title', 'et_builder' ),
                    'font_size' => array(
                        'default'           => '18px',
                        'range_settings'    => array(
                            'min'   => '1',
                            'max'   => '100',
                            'step'  => '1',
                        ),
                        'validate_unit'     => true,
                    ),
                    'line_height' => array(
                        'default'           => '1.5em',
                        'range_settings'    => array(
                            'min'   => '0.1',
                            'max'   => '10',
                            'step'  => '0.1',
                        ),
                    ),
                    'letter_spacing' => array(
                        'default'           => '0px',
                        'range_settings'    => array(
                            'min'   => '0',
                            'max'   => '10',
                            'step'  => '1',
                        ),
                        'validate_unit'     => true,
                    ),
					'css'       => array(
						'main'  => "{$this->main_css_element} h4, {$this->main_css_element} h4 a, {$this->main_css_element} h1.et_pb_module_header, {$this->main_css_element} h1.et_pb_module_header a, {$this->main_css_element} h2.et_pb_module_header, {$this->main_css_element} h2.et_pb_module_header a, {$this->main_css_element} h3.et_pb_module_header, {$this->main_css_element} h3.et_pb_module_header a, {$this->main_css_element} h5.et_pb_module_header, {$this->main_css_element} h5.et_pb_module_header a, {$this->main_css_element} h6.et_pb_module_header, {$this->main_css_element} h6.et_pb_module_header a",
					),
					'header_level'  => array(
						'default'   => 'h4',
					),
					'important' 			=> 'all',
					'tab_slug'				=> 'advanced',
					'toggle_slug'			=> 'text_settings',
					'sub_toggle'			=> 'title_text',
				),
				'body'  => array(
				    'label' => esc_html__( 'Body', 'et_builder' ),
				    'font_size' => array(
                        'default'           => '14px',
                        'range_settings'    => array(
                            'min'   => '1',
                            'max'   => '100',
                            'step'  => '1',
                        ),
                        'validate_unit'     => true,
                    ),
                    'line_height' => array(
                        'default'           => '1.7em',
                        'range_settings'    => array(
                            'min'   => '0',
                            'max'   => '5',
                            'step'  => '0.1',
                        ),
                    ),
                    'letter_spacing' => array(
                        'default'           => '0px',
                        'range_settings'    => array(
                            'min'   => '0',
                            'max'   => '10',
                            'step'  => '1',
                        ),
                        'validate_unit'     => true,
                    ),
					'css'   => array(
						'main' => "{$this->main_css_element} .et_pb_blurb_description",
					),
					'important' 			=> 'all',
					'tab_slug'				=> 'advanced',
					'toggle_slug'			=> 'text_settings',
					'sub_toggle'			=> 'body_text',
				)
			),
			'text'  => array(
				'use_background_layout' => true,
				'options' => array(
					'background_layout' => array(
						'default_on_front' => 'light',
					),
					'text_orientation' => array(
						'default_on_front' => 'left',
					),
				),
				'important' 			=> 'all',
				'tab_slug'				=> 'advanced',
				'toggle_slug'			=> 'text_settings',
				'sub_toggle'			=> 'blurb_text',
			),
			'background' => array(
			    'css' => array(
				    'main' => "%%order_class%%",
			    ),
			),
			'button' => array(
			    'read_more' => array(
				    'label'             => esc_html__( 'Button', 'et_builder' ),
				    'css'               => array(
				        'main' => "{$this->main_css_element} .et_pb_more_button",
						'plugin_main' => "{$this->main_css_element} .et_pb_more_button.et_pb_button",
				    ),
				    'no_rel_attr'       => true,
				    'use_alignment'     => false,
				    'box_shadow'        => false,
				    'depends_on'        => array( 'read_more_button' ),
		            'depends_show_if'   => 'on',
				    'tab_slug'          => 'general',
				    'toggle_slug'       => 'button',
			    ),
			),
			'custom_margin_padding' => array(
			    'css' => array(
				    'main'      => "{$this->main_css_element} .et_pb_blurb_content",
					'important' => 'all',
			    ),
			),
			'max_width' => array(
				'css' => array(
					'main'              => $this->main_css_element,
					'module_alignment'  => '%%order_class%%.et_pb_blurb_extended.et_pb_module',
				),
			),
			'filters'   => false,
			'borders' => array(
			    'default' => array(
    			    'css' => array(
    				    'main' => array(
    				        'border_styles' => "%%order_class%%",
    				        'border_radii'  => "%%order_class%%",
    				    ),
    			    ),
    			)
			),
        );
    }
    
    public function get_custom_css_fields_config() {
        return array(
            'blurb_image' => array(
				'label'     => esc_html__( 'Blurb Image', 'et_builder' ),
				'selector'  => '.et_pb_main_blurb_image'
			),
			'blurb_title' => array(
				'label'     => esc_html__( 'Blurb Title', 'et_builder' ),
				'selector'  => '.et_pb_module_header'
			),
			'blurb_content' => array(
				'label'     => esc_html__( 'Blurb Content', 'et_builder' ),
				'selector'  => '.et_pb_blurb_content'
			),
			'read_more' => array(
				'label'     => esc_html__( 'Read More Button', 'et_builder' ),
				'selector'  => '.et_pb_more_button.et_pb_button'
			),
        );
    }

	public function get_fields() {
	    $et_accent_color = et_builder_accent_color();

		return array(
			'title' => array(
				'label'                 => esc_html__( 'Title', 'et_builder' ),
				'type'                  => 'text',
				'option_category'       => 'basic_option',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'main_content',
				'description'           => esc_html__( 'The title of your blurb will appear in bold below your blurb image.', 'et_builder' ),
			),
			'url' => array(
				'label'                 => esc_html__( 'Blurb Url', 'et_builder' ),
				'type'                  => 'text',
				'option_category'       => 'basic_option',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'link',
				'description'           => esc_html__( 'If you would like to make your blurb a link, input your destination URL here.', 'et_builder' ),
			),
			'url_new_window' => array(
				'label'                 => esc_html__( 'Url Opens in New Window', 'et_builder' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'configuration',
				'options'               => array(
				    'off'   => esc_html__( 'No', 'et_builder' ),
					'on'    => esc_html__( 'YES', 'et_builder' ),
				),
				'default'               => 'off',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'link',
				'description'           => esc_html__( 'Here you can choose whether or not your link opens in a new window', 'et_builder' ),
			),
			'read_more_button' => array(
				'label'                 => esc_html__( 'Read More Button', 'et_builder' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'basic_option',
				'options'               => array(
					'off'   => esc_html__( 'No', 'et_builder' ),
					'on'    => esc_html__( 'Yes', 'et_builder' ),
				),
				'affects'               => array(
				    'custom_read_more',
				),
				'default'               => 'off',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'button',
				'description'           => esc_html__( 'Here you can choose whether read more button should be used.', 'et_builder' ),
			),
			'read_more_text' => array(
				'label'                 => esc_html__( 'Read More Button Text', 'et_builder' ),
				'type'                  => 'text',
				'option_category'       => 'basic_option',
				'show_if'               => array(
				    'read_more_button'  => 'on',
				),
				'tab_slug'              => 'general',
				'toggle_slug'           => 'button',
				'description'           => esc_html__( 'Here you can define custom read more button text.', 'et_builder' ),
			),
			'read_more_hover_background_color' => array(
				'label'                 => esc_html__( 'Button Background Color', 'et_builder' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
				    'read_more_button'  => 'on',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'hover_state',
				'description'           => esc_html__( 'Here you can define a custom color for the button on hover.', 'et_builder' ),
				'sub_toggle'			=> 'button_hover',
			),
			'read_more_hover_border_color' => array(
				'label'                 => esc_html__( 'Button Border Color', 'et_builder' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
				    'read_more_button'  => 'on',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'hover_state',
				'description'           => esc_html__( 'Here you can define a custom color for the button border on hover.', 'et_builder' ),
				'sub_toggle'			=> 'button_hover',
			),
			'read_more_hover_text_color' => array(
				'label'                 => esc_html__( 'Button Text Color', 'et_builder' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
				    'read_more_button'  => 'on',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'hover_state',
				'description'           => esc_html__( 'Here you can define a custom color for the button text on hover.', 'et_builder' ),
				'sub_toggle'			=> 'button_hover',
			),
			'use_icon' => array(
				'label'                 => esc_html__( 'Use Icon', 'et_builder' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'basic_option',
				'options'               => array(
					'off'   => esc_html__( 'No', 'et_builder' ),
					'on'    => esc_html__( 'Yes', 'et_builder' ),
				),
				'default'               => 'off',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'image',
				'description'           => esc_html__( 'Here you can choose whether icon set below should be used.', 'et_builder' ),
			),
			'font_icon' => array(
				'label'                 => esc_html__( 'Icon', 'et_builder' ),
				'type'                  => 'select_icon',
				'option_category'       => 'basic_option',
				'class'                 => array(
					'et-pb-font-icon'
				),
				'show_if'               => array(
				    'use_icon'  => 'on',
				),
				'tab_slug'              => 'general',
				'toggle_slug'           => 'image',
				'description'           => esc_html__( 'Choose an icon to display with your blurb.', 'et_builder' ),
			),
			'icon_placement' => array(
				'label'                 => esc_html__( 'Image/Icon Placement', 'et_builder' ),
				'type'                  => 'select',
				'option_category'       => 'layout',
				'options'               => array(
        			'top'   => esc_html__( 'Top', 'et_builder' ),
        			'left'  => esc_html__( 'Left', 'et_builder' ),
        			'right' => esc_html__( 'Right', 'et_builder' ),
        		),
        		'default'               => 'top',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
				'description'           => esc_html__( 'Here you can choose where to place the icon.', 'et_builder' ),
			),
			'icon_color' => array(
				'label'                 => esc_html__( 'Icon Color', 'et_builder' ),
				'type'                  => 'color-alpha',
				'show_if'               => array(
				    'use_icon'  => 'on',
				),
				'default'               => $et_accent_color,
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
				'description'           => esc_html__('Here you can define a custom color for your icon.', 'et_builder'),
			),
			'use_icon_font_size' => array(
				'label'                 => esc_html__( 'Use Icon Font Size', 'et_builder' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'font_option',
				'options'               => array(
					'off'   => esc_html__( 'No', 'et_builder' ),
					'on'    => esc_html__( 'Yes', 'et_builder' )
				),
				'show_if'               => array(
				    'use_icon'  => 'on',
				),
				'default'               => 'off',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
			),
			'icon_font_size' => array(
				'label'                 => esc_html__( 'Icon Font Size', 'et_builder' ),
				'type'                  => 'range',
				'option_category'       => 'font_option',
				'range_settings'        => array(
					'min'   => '1',
					'max'   => '120',
					'step'  => '1',
				),
				'mobile_options'        => true,
				'show_if'               => array(
					'use_icon'  			=> 'on',
				    'use_icon_font_size'    => 'on',
				),
				'default'               => '32px',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
			),
			'icon_hover_color' => array(
				'label'                 => esc_html__( 'Icon Color', 'et_builder' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
				    'use_icon'  => 'on',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'hover_state',
				'description'           => esc_html__( 'Here you can define a custom color for the icon on hover.', 'et_builder' ),
				'sub_toggle'			=> 'blurb_hover',
			),
			'style_icon' => array(
				'label'                 => esc_html__( 'Style Icon', 'et_builder' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'configuration',
				'options'               => array(
					'off'   => esc_html__( 'No', 'et_builder' ),
					'on'    => esc_html__( 'Yes', 'et_builder' )
				),
				'show_if'               => array(
				    'use_icon'  => 'on',
				),
				'default'               => 'off',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
				'description'           => esc_html__( 'Here you can choose whether icon set above should display within a shape.', 'et_builder' ),
			),
			'icon_shape' => array(
				'label'                 => esc_html__( 'Shape', 'et_builder' ),
				'type'                  => 'select',
				'option_category'       => 'configuration',
				'options'               => array(
					'use_square'    => esc_html__( 'Square', 'et_builder' ),
					'use_circle'    => esc_html__( 'Circle', 'et_builder' ),
					'use_hexagon'   => esc_html__( 'Hexagon', 'et_builder' )
				),
				'show_if'               => array(
					'use_icon'  	=> 'on',
				    'style_icon'    => 'on',
				),
				'default' 				=> 'use_square',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
				'description'           => esc_html__( 'Here you can choose shape.', 'et_builder' ),
			),
			'shape_color' => array(
				'label'                 => esc_html__( 'Shape Background', 'et_builder' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
					'use_icon'  	=> 'on',
				    'style_icon'    => 'on',
				),
				'default'               => $et_accent_color,
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
				'description'           => esc_html__( 'Here you can define a custom color for the icon shape.', 'et_builder' ),
			),
			'shape_hover_color' => array(
				'label'                 => esc_html__( 'Icon Shape Color', 'et_builder' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
					'use_icon'  	=> 'on',
				    'style_icon'    => 'on',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'hover_state',
				'description'           => esc_html__( 'Here you can define a custom color for the icon shape on hover.', 'et_builder' ),
				'sub_toggle'			=> 'blurb_hover',
			),
			'use_shape_border' => array(
				'label'                 => esc_html__( 'Display Shape Border', 'et_builder' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'layout',
				'options'               => array(
					'off'   => esc_html__( 'No', 'et_builder' ),
					'on'    => esc_html__( 'Yes', 'et_builder' )
				),
				'show_if'               => array(
					'use_icon'  	=> 'on',
				    'style_icon'    => 'on',
				),
				'default'               => 'off',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
				'description'           => esc_html__( 'Here you can choose whether if the icon border should display.', 'et_builder' ),
			),
			'shape_border_color' => array(
				'label'                 => esc_html__( 'Shape Border Color', 'et_builder' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
					'use_icon'  		=> 'on',
					'style_icon'    	=> 'on',
				    'use_shape_border'  => 'on',
				),
				'default'               => $et_accent_color,
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
				'description'           => esc_html__( 'Here you can define a custom color for the icon border.', 'et_builder' ),
			),
			'shape_border_hover_color' => array(
				'label'                 => esc_html__( 'Shape Border Color', 'et_builder' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
					'use_icon'  		=> 'on',
					'style_icon'    	=> 'on',
				    'use_shape_border'  => 'on',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'hover_state',
				'description'           => esc_html__( 'Here you can define a custom color for the icon shape border on hover.', 'et_builder' ),
				'sub_toggle'			=> 'blurb_hover',
			),
			'image' => array(
				'label'                 => esc_html__( 'Image', 'et_builder' ),
				'type'                  => 'upload',
				'option_category'       => 'basic_option',
				'upload_button_text'    => esc_attr__( 'Upload an image', 'et_builder' ),
				'choose_text'           => esc_attr__( 'Choose an Image', 'et_builder' ),
				'update_text'           => esc_attr__( 'Set As Image', 'et_builder' ),
				'show_if'               => array(
				    'use_icon'  => 'off',
				),
				'tab_slug'              => 'general',
				'toggle_slug'           => 'image',
				'description'           => esc_html__( 'Upload an image to display at the top of your blurb.', 'et_builder' ),
			),
			'alt' => array(
				'label'                 => esc_html__( 'Image Alt Text', 'et_builder' ),
				'type'                  => 'text',
				'option_category'       => 'basic_option',
				'show_if'               => array(
				    'use_icon'  => 'off',
				),
				'tab_slug'              => 'general',
				'toggle_slug'           => 'image',
				'description'           => esc_html__( 'Define the HTML ALT text for your image here.', 'et_builder' ),
			),
			'image_max_width' => array(
				'label'                 => esc_html__( 'Image Width', 'et_builder' ),
				'type'                  => 'range',
				'option_category'       => 'layout',
				'mobile_options'        => true,
				'validate_unit'         => true,
				'allow_empty'           => true,
				'range_settings'        => array(
					'min'   => '50',
					'max'   => '550',
					'step'  => '1',
				),
				'show_if'               => array(
				    'use_icon'  => 'off',
				),
				'default' 				=> '64px',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'content_background_color' => array(
				'label'                 => esc_html__( 'Content Background Color', 'et_builder' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if_not'               => array(
					'blurb_layout'    	=> 'flipbox',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'content_background',
				'description'           => esc_html__( 'Here you can define a custom color for the content.', 'et_builder' ),
			),
			'title_hover_color' => array(
				'label'                 => esc_html__( 'Title Color', 'et_builder' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'description'           => esc_html__( 'Here you can define a custom color for the title on hover.', 'et_builder' ),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'hover_state',
				'sub_toggle'			=> 'text_hover',
			),
			'text_hover_color' => array(
				'label'                 => esc_html__( 'Text Color', 'et_builder' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'description'           => esc_html__( 'Here you can define a custom color for the text on hover.', 'et_builder' ),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'hover_state',
				'sub_toggle'			=> 'text_hover',
			),
			'blurb_hover_color' => array(
				'label'                 => esc_html__( 'Content Background Color on Hover', 'et_builder' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'hover_state',
				'description'           => esc_html__( 'Here you can define a custom color for the blurb on hover.', 'et_builder' ),
				'sub_toggle'			=> 'blurb_hover',
			),
			'content_max_width' => array(
				'label'                 => esc_html__( 'Content Width', 'et_builder' ),
				'type'                  => 'range',
				'option_category'       => 'layout',
				'mobile_options'        => true,
				'validate_unit'         => true,
				'allow_empty'           => true,
				'range_settings'        => array(
					'min'   => '0',
					'max'   => '1100',
					'step'  => '1',
				),
				'default'               => '550px',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'blurb_layout' => array(
				'label'                 => esc_html__( 'Layout', 'et_builder' ),
				'type'                  => 'select',
				'option_category'       => 'layout',
				'options'               => array(
					'classic'       => esc_html__( 'Classic', 'et_builder' ),
					'flipbox'       => esc_html__( 'Flipbox', 'et_builder' ),
					'easebox'       => esc_html__( 'Easebox', 'et_builder' ),
					'borderbox'     => esc_html__( 'Borderbox', 'et_builder' ),
					'image_card'    => esc_html__( 'Image Card', 'et_builder' ),
				),
				'default'               => 'classic',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'layout_settings',
				'description'           => esc_html__( 'Here you can choose the layout.', 'et_builder' ),
			),
			'fb_front_background' => array(
				'label'                 => esc_html__( 'Front', 'et_builder' ),
				'type'                  => 'select',
				'option_category'       => 'layout',
				'options'               => array(
					'color'     => esc_html__( 'Color', 'et_builder' ),
					'image'     => esc_html__( 'Image', 'et_builder' ),
				),
				'show_if'               => array(
				    'blurb_layout'  => 'flipbox',
				),
				'default'               => 'color',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'flipbox_layout',
			),
			'fb_front_background_color' => array(
				'label'                 => esc_html__( 'Front Color', 'et_builder' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
				    'blurb_layout'          => 'flipbox',
				    'fb_front_background'   => 'color',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'flipbox_layout',
				'default' 				=> '#ffffff',
			),
			'fb_front_background_image' => array(
				'label'                 => esc_html__( 'Front Image', 'et_builder' ),
				'type'                  => 'upload',
				'option_category'       => 'basic_option',
				'upload_button_text'    => esc_attr__( 'Upload an image', 'et_builder' ),
				'choose_text'           => esc_attr__( 'Choose an Image', 'et_builder' ),
				'update_text'           => esc_attr__( 'Set As Image', 'et_builder' ),
				'show_if'               => array(
				    'blurb_layout'          => 'flipbox',
				    'fb_front_background'   => 'image',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'flipbox_layout',
				'description'           => esc_html__( 'Upload an image to display at the background on the front.', 'et_builder' ),
			),
			'fb_back_background' => array(
				'label'                 => esc_html__( 'Back', 'et_builder' ),
				'type'                  => 'select',
				'option_category'       => 'layout',
				'options'               => array(
					'color'     => esc_html__( 'Color', 'et_builder' ),
					'image'     => esc_html__( 'Image', 'et_builder' ),
				),
				'show_if'               => array(
				    'blurb_layout'  => 'flipbox',
				),
				'default'               => 'color',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'flipbox_layout',
			),
			'fb_back_background_color' => array(
				'label'                 => esc_html__( 'Back Color', 'et_builder' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
				    'blurb_layout'          => 'flipbox',
				    'fb_back_background'    => 'color',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'flipbox_layout',
				'default' 				=> '#ffffff',
			),
			'fb_back_background_image' => array(
				'label'                 => esc_html__( 'Back Image', 'et_builder' ),
				'type'                  => 'upload',
				'option_category'       => 'basic_option',
				'upload_button_text'    => esc_attr__( 'Upload an image', 'et_builder' ),
				'choose_text'           => esc_attr__( 'Choose an Image', 'et_builder' ),
				'update_text'           => esc_attr__( 'Set As Image', 'et_builder' ),
				'show_if'               => array(
				    'blurb_layout'          => 'flipbox',
				    'fb_back_background'    => 'image',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'flipbox_layout',
				'description'           => esc_html__( 'Upload an image to display at the background on the back.', 'et_builder' ),
			),
			'fb_height' => array(
				'label'                 => esc_html__( 'Flipbox Height', 'et_builder' ),
				'type'                  => 'range',
				'range_settings'        => array(
					'min'   => '100',
					'max'   => '1000',
					'step'  => '10',
				),
				'mobile_options'        => true,
				'show_if'               => array(
				    'blurb_layout'          => 'flipbox',
				),
				'default'               => '350px',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'flipbox_layout',
			),
			'fb_height_last_edited' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'flipbox_layout',
			),
			'fb_height_tablet' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'flipbox_layout',
			),
			'fb_height_phone' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'flipbox_layout',
			),
			'ic_image' => array(
				'label'                 => esc_html__( 'Top Image', 'et_builder' ),
				'type'                  => 'upload',
				'option_category'       => 'basic_option',
				'upload_button_text'    => esc_attr__( 'Upload an image', 'et_builder' ),
				'choose_text'           => esc_attr__( 'Choose an Image', 'et_builder' ),
				'update_text'           => esc_attr__( 'Set As Image', 'et_builder' ),
				'show_if'               => array(
				    'blurb_layout'  => 'image_card',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'image_card_layout',
				'description'           => esc_html__( 'Upload an image to display at the top of your Image Card.', 'et_builder' ),
			),
			'ic_image_alt' => array(
				'label'                 => esc_html__( 'Image Alt Text', 'et_builder' ),
				'type'                  => 'text',
				'option_category'       => 'basic_option',
				'show_if'               => array(
				    'blurb_layout'  => 'image_card',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'image_card_layout',
				'description'           => esc_html__( 'Define the HTML ALT text for your image here.', 'et_builder' ),
			),
			'borderbox_border_color' => array(
				'label'                 => esc_html__( 'Border Color', 'et_builder' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
				    'blurb_layout'  => 'borderbox',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'borderbox_layout',
				'description'           => esc_html__( 'Here you can define a custom color for the border.', 'et_builder' ),
			),
			'borderbox_hover_border_color' => array(
				'label'                 => esc_html__( 'Borderbox Border Color', 'et_builder' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'description'           => esc_html__( 'Here you can define a custom color for the border of Borderbox layout.', 'et_builder' ),
				'show_if'               => array(
				    'blurb_layout'  => 'borderbox',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'hover_state',
				'sub_toggle'			=> 'blurb_hover',
			),
			'animation' => array(
				'label'                 => esc_html__( 'Image/Icon Animation', 'et_builder' ),
				'type'                  => 'select',
				'option_category'       => 'configuration',
				'options'               => array(
					'top'       => esc_html__( 'Top To Bottom', 'et_builder' ),
					'left'      => esc_html__( 'Left To Right', 'et_builder' ),
					'right'     => esc_html__( 'Right To Left', 'et_builder' ),
					'bottom'    => esc_html__( 'Bottom To Top', 'et_builder' ),
					'off'       => esc_html__( 'No Animation', 'et_builder' ),
				),
				'default'               => 'top',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'animation',
				'description'           => esc_html__( 'This controls the direction of the lazy-loading animation.', 'et_builder' ),
			),
			'content' => array(
				'label'                 => esc_html__( 'Content', 'et_builder' ),
				'type'                  => 'tiny_mce',
				'option_category'       => 'basic_option',
				'toggle_slug'           => 'main_content',
				'description'           => esc_html__( 'Input the main text content for your module here.', 'et_builder' ),
			),
			'image_max_width_tablet' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'image_max_width_phone' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'image_max_width_last_edited' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'content_max_width_tablet' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'content_max_width_phone' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'content_max_width_last_edited' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'icon_font_size_last_edited' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
			),
			'icon_font_size_tablet' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
			),
			'icon_font_size_phone' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
			),
			'disabled_on' => array(
				'label'                 => esc_html__( 'Disable on', 'et_builder' ),
				'type'                  => 'multiple_checkboxes',
				'options'               => array(
					'phone'     => esc_html__( 'Phone', 'et_builder' ),
					'tablet'    => esc_html__( 'Tablet', 'et_builder' ),
					'desktop'   => esc_html__( 'Desktop', 'et_builder' ),
				),
				'additional_att'        => 'disable_on',
				'option_category'       => 'configuration',
				'tab_slug'              => 'custom_css',
				'toggle_slug'           => 'visibility',
				'description'           => esc_html__( 'This will disable the module on selected devices', 'et_builder' ),
			),
			'admin_label' => array(
				'label'                 => esc_html__( 'Admin Label', 'et_builder' ),
				'type'                  => 'text',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'admin_label',
				'description'           => esc_html__('This will change the label of the module in the builder for easy identification.', 'et_builder'),
			),
			'module_id' => array(
				'label'                 => esc_html__( 'CSS ID', 'et_builder' ),
				'type'                  => 'text',
				'option_category'       => 'configuration',
				'option_class'          => 'et_pb_custom_css_regular',
				'tab_slug'              => 'custom_css',
				'toggle_slug'           => 'classes',
			),
			'module_class' => array(
				'label'                 => esc_html__( 'CSS Class', 'et_builder' ),
				'type'                  => 'text',
				'option_category'       => 'configuration',
				'option_class'          => 'et_pb_custom_css_regular',
				'tab_slug'              => 'custom_css',
				'toggle_slug'           => 'classes',
			)
		);
	}

	public function render( $attrs, $content = null, $render_slug ) {
		$module_id                          = $this->props['module_id'];
		$module_class                       = $this->props['module_class'];
		$title                              = $this->props['title'];
		$url                                = $this->props['url'];
		$image                              = $this->props['image'];
		$url_new_window                     = $this->props['url_new_window'];
		$read_more_button                   = $this->props['read_more_button'];
		$read_more_text                     = $this->props['read_more_text'];
		$read_more_icon                     = $this->props['read_more_icon'];
		$read_more_use_icon                 = $this->props['read_more_use_icon'];
		$custom_read_more                   = $this->props['custom_read_more'];
		$alt                                = $this->props['alt'];
		$background_layout                  = $this->props['background_layout'];
		$text_orientation                   = $this->props['text_orientation'];
		$animation                          = $this->props['animation'];
		$blurb_layout                       = $this->props['blurb_layout'];
		$content_background_color 			= $this->props['content_background_color'];
		$fb_front_background                = $this->props['fb_front_background'];
		$fb_back_background                 = $this->props['fb_back_background'];
		$fb_front_color                     = $this->props['fb_front_background_color'];
		$fb_front_image                     = $this->props['fb_front_background_image'];
		$fb_back_color                      = $this->props['fb_back_background_color'];
		$fb_back_image                      = $this->props['fb_back_background_image'];
		$fb_height 							= $this->props['fb_height'];
		$fb_height_tablet					= $this->props['fb_height_tablet'];
		$fb_height_phone					= $this->props['fb_height_phone'];
		$fb_height_last_edited 				= $this->props['fb_height_last_edited'];
		$ic_image                           = $this->props['ic_image'];
		$ic_image_alt                       = $this->props['ic_image_alt'];
		$borderbox_border_color             = $this->props['borderbox_border_color'];
		$borderbox_hover_border_color       = $this->props['borderbox_hover_border_color'];
		$icon_placement                     = $this->props['icon_placement'];
		$font_icon                          = $this->props['font_icon'];
		$use_icon                           = $this->props['use_icon'];
		$icon_color                         = $this->props['icon_color'];
		$style_icon                         = $this->props['style_icon'];
		$icon_shape                         = $this->props['icon_shape'];
		$shape_color                        = $this->props['shape_color'];
		$use_shape_border                   = $this->props['use_shape_border'];
		$shape_border_color                 = $this->props['shape_border_color'];
		$shape_hover_color                  = $this->props['shape_hover_color'];
		$shape_border_hover_color           = $this->props['shape_border_hover_color'];
		$icon_hover_color                   = $this->props['icon_hover_color'];
		$title_hover_color                   = $this->props['title_hover_color'];
		$text_hover_color                   = $this->props['text_hover_color'];
		$read_more_hover_background_color   = $this->props['read_more_hover_background_color'];
		$read_more_hover_border_color       = $this->props['read_more_hover_border_color'];
		$read_more_hover_text_color         = $this->props['read_more_hover_text_color'];
		$blurb_hover_color                  = $this->props['blurb_hover_color'];
		$use_icon_font_size                 = $this->props['use_icon_font_size'];
		$icon_font_size                     = $this->props['icon_font_size'];
		$icon_font_size_tablet              = $this->props['icon_font_size_tablet'];
		$icon_font_size_phone               = $this->props['icon_font_size_phone'];
		$icon_font_size_last_edited         = $this->props['icon_font_size_last_edited'];
		$image_max_width                    = $this->props['image_max_width'];
		$image_max_width_tablet             = $this->props['image_max_width_tablet'];
		$image_max_width_phone              = $this->props['image_max_width_phone'];
		$image_max_width_last_edited        = $this->props['image_max_width_last_edited'];
		$content_max_width                  = $this->props['content_max_width'];
		$content_max_width_tablet           = $this->props['content_max_width_tablet'];
		$content_max_width_phone            = $this->props['content_max_width_phone'];
		$content_max_width_last_edited      = $this->props['content_max_width_last_edited'];
		$header_level                       = $this->props['header_level'];
	
		$image_pathinfo         = pathinfo( $image );
		$is_image_svg           = isset( $image_pathinfo['extension'] ) ? 'svg' === $image_pathinfo['extension'] : false;
		$processed_header_level = et_pb_process_header_level( $header_level, 'h4' );
		
		if ( 'off' !== $use_icon_font_size ) {
			$font_size_responsive_active = et_pb_get_responsive_status( $icon_font_size_last_edited );
			
			$font_size_values = array(
				'desktop'   => $icon_font_size,
				'tablet'    => $font_size_responsive_active ? $icon_font_size_tablet : '',
				'phone'     => $font_size_responsive_active ? $icon_font_size_phone : '',
			);
			
			et_pb_generate_responsive_css( $font_size_values, '%%order_class%% .' . $blurb_layout . ' .et-pb-icon', 'font-size', $render_slug );
		}
		
		if ( '' !== $image_max_width_tablet || '' !== $image_max_width_phone || '' !== $image_max_width || $is_image_svg ) {
			// SVG image overwrite. SVG image needs its value to be explicit
			if ( '' === $image_max_width && $is_image_svg ) {
				$image_max_width = '100%';
			}

			$image_max_width_selector = '%%order_class%% .' . $blurb_layout . '.use-image .et_pb_main_blurb_image';
			$image_max_width_property =  'width'; //$is_image_svg ? 'width' : 'max-width';

			$image_max_width_responsive_active = et_pb_get_responsive_status( $image_max_width_last_edited );

			$image_max_width_values = array(
				'desktop' => $image_max_width,
				'tablet'  => $image_max_width_responsive_active ? $image_max_width_tablet : '',
				'phone'   => $image_max_width_responsive_active ? $image_max_width_phone : '',
			);

			et_pb_generate_responsive_css( $image_max_width_values, $image_max_width_selector, $image_max_width_property, $render_slug );
		}
		
		if ( '' !== $content_max_width_tablet || '' !== $content_max_width_phone || '' !== $content_max_width ) {
			$content_max_width_responsive_active = et_pb_get_responsive_status( $content_max_width_last_edited );

			$content_max_width_values = array(
				'desktop' => $content_max_width,
				'tablet'  => $content_max_width_responsive_active ? $content_max_width_tablet : '',
				'phone'   => $content_max_width_responsive_active ? $content_max_width_phone : '',
			);

			et_pb_generate_responsive_css( $content_max_width_values, '%%order_class%% .' . $blurb_layout . ' .et_pb_blurb_content', 'max-width', $render_slug );
		}
		
		if ( '' !== $title && '' !== $url ) {
			$title = sprintf( '<a href="%1$s"%3$s>%2$s</a>', esc_url( $url ), esc_html( $title ), ( 'on' === $url_new_window ? ' target="_blank"' : '' ) );
		}
		
		if ( '' !== $title ) {
			$title = sprintf( '<%1$s class="et_pb_module_header">%2$s</%1$s>', $processed_header_level, $title );
		}
		
		// Added for backward compatibility
		if ( empty( $animation ) ) {
			$animation = 'top';
		}
		
		if ( 'off' === $use_icon ) {
			    $image_class    = ( '' !== trim( $image ) ) ? ' use-image' : '';
				$image          = ( '' !== trim( $image ) ) ? sprintf( '<img src="%1$s" alt="%2$s" class="et-waypoint%3$s" />', esc_url( $image ), esc_attr( $alt ), esc_attr( " et_pb_animation_{$animation}" ) ) : '';
		} else {
			$icon_style     = sprintf( 'color: %1$s;', esc_attr( $icon_color ) );
			$image_class    = '';
			$icon_class     = '';
			$hexagon_start  = '';
			$hexagon_end    = '';
			
			if ( 'on' === $style_icon ) {
				
				if ( 'use_circle' === $icon_shape ) {
					$icon_class     = ' el-icon-circle';
					$icon_style    .= sprintf( ' background-color: %1$s;', esc_attr( $shape_color ) );
					if ( 'on' === $use_shape_border ) {
						$icon_style .= sprintf( ' border-color: %1$s;', esc_attr( $shape_border_color ) );
					}
				} else if ( 'use_square' === $icon_shape ) {
					$icon_class     = ' el-icon-square';
					$icon_style    .= sprintf( ' background-color: %1$s;', esc_attr( $shape_color ) );
					if ( 'on' === $use_shape_border ) {
						$icon_style .= sprintf( ' border-color: %1$s;', esc_attr( $shape_border_color ) );
					}
				} else if ( 'use_hexagon' === $icon_shape ) {
					$icon_class     = ' el-icon-hexagon';
					$hexagon_style  = sprintf( ' background-color: %1$s;', esc_attr( $shape_color ) );
					if ( 'on' === $use_shape_border ) {
						$hexagon_style  .= sprintf( ' border-color: %1$s;', esc_attr( $shape_border_color ) );
					}
					$hexagon_start = sprintf( '<div class="hexagon-wrapper et-waypoint%2$s"><div class="hex"><div class="hexagon' . ( 'on' === $use_shape_border ? ' et-pb-icon-shape-border' : '' ) . '" style="%1$s">', $hexagon_style, esc_attr( " et_pb_animation_{$animation}" ) );
					$hexagon_end   = '</div></div></div>';
				}
				
			}
			
			$image = ( '' !== $font_icon ) ? sprintf( $hexagon_start . '<span class="et-pb-icon%7$s%6$s%2$s%3$s%4$s" style="%5$s">%1$s</span>' . $hexagon_end,
			            esc_attr( et_pb_process_font_icon( $font_icon ) ),
			            esc_attr( " et_pb_animation_{$animation}" ),
			            $icon_class,
			            ( 'on' === $style_icon && 'on' === $use_shape_border && 'use_hexagon' !== $icon_shape ? ' et-pb-icon-shape-border' : '' ),
			            $icon_style,
			            ( 'on' === $style_icon && 'use_hexagon' !== $icon_shape ? ' et-waypoint' : '' ),
			            ( 'off' === $style_icon ? ' et-waypoint' : '' ) ) : '';
		}
		
		if ( 'image_card' !== $blurb_layout ) {
			$image = $image ? sprintf( '<div class="et_pb_main_blurb_image">%1$s</div>', ( '' !== $url ? sprintf( '<a href="%1$s"%3$s>%2$s</a>', esc_url( $url ), $image, ( 'on' === $url_new_window ? ' target="_blank"' : '' ) ) : $image ) ) : '';
		}
		
		$read_more_hover_background_color = $this->props['read_more_hover_background_color'];
		$read_more_hover_border_color     = $this->props['read_more_hover_border_color'];
		$read_more_hover_text_color       = $this->props['read_more_hover_text_color'];
		
		if ( '' !== $read_more_hover_background_color ) {
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => 'body #page-container %%order_class%%.et_pb_blurb_extended .et_pb_more_button.et_pb_button:hover',
				'declaration'   => sprintf( 'background: %1$s;', esc_html( $read_more_hover_background_color ) )
			) );
		}
		if ( '' !== $read_more_hover_border_color ) {
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => 'body #page-container %%order_class%%.et_pb_blurb_extended .et_pb_more_button.et_pb_button:hover',
				'declaration'   => sprintf( 'border-color: %1$s;', esc_html( $read_more_hover_border_color ) )
			));
		}
		if ( '' !== $read_more_hover_text_color ) {
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => 'body #page-container %%order_class%%.et_pb_blurb_extended .et_pb_more_button.et_pb_button:hover',
				'declaration'   => sprintf( 'color: %1$s !important;', esc_html( $read_more_hover_text_color ) )
			));
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => 'body #page-container %%order_class%%.et_pb_blurb_extended .et_pb_more_button.et_pb_button:hover:after',
				'declaration'   => sprintf( 'color: %1$s !important;', esc_html( $read_more_hover_text_color ) )
			));
		}

		if( 'flipbox' !== $blurb_layout ) {
			if ( '' !== $content_background_color ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'      => '%%order_class%%.et_pb_blurb_extended .et_pb_blurb_content',
					'declaration'   => sprintf( 'background: %1$s !important;', esc_html( $content_background_color ) ),
				));
			}
		}
						
		if ( file_exists( get_stylesheet_directory() . '/divi-blurb-extended/layouts/' . $blurb_layout . '.php' ) ) {
            include get_stylesheet_directory() . '/divi-blurb-extended/layouts/' . $blurb_layout . '.php';
        } elseif ( file_exists( plugin_dir_path( __FILE__ ) . 'layouts/' . $blurb_layout . '.php' ) ) {
            include ( plugin_dir_path( __FILE__ ) . 'layouts/' . $blurb_layout . '.php' );
        }
        
		$this->add_classname( array(
			$this->get_text_orientation_classname()
		) );

		$class = '';
		$class .= 'et_pb_blurb_position_'.esc_attr( $icon_placement );
		$class .= ' ' . $blurb_layout;
		$class .= ( 'on' === $style_icon ) ? esc_html( ' '.$icon_shape ) : '';
		$class .= ' '.trim( $image_class );
		$class .= ' et_pb_bg_layout_'.$background_layout;
	
		$output = sprintf( '<div class="%2$s"> 
			        			%1$s
			        		</div>
		             <!-- .et_pb_blurb -->',
			        $layout,
			        $class
			      );
		
		return $output;
		
	}
}

new El_Blurb_Module;