<?php
/**
 * The Template for displaying Image Card Layout
 *
 * This template can be overridden by copying it to yourtheme/divi-blurb-extended/layouts/image_card.php.
 *
 * HOWEVER, on occasion divi-blurb-extended will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen.
 *
 * @author      Elicus Technologies <hello@elicus.com>
 * @link        https://elicus.com/
 * @copyright   2020 Elicus Technologies Private Limited
 * @version     2.1.0
 */
 
$ic_image   	= ( '' !== trim( $ic_image ) ) ?
				  sprintf( '<div class="et_pb_main_ic_image"><img src="%1$s" alt="%2$s" /></div>',
				  		esc_url( $ic_image ),
				  		esc_attr( $ic_image_alt )
				  ) :
				  '';

if ( '' !== trim( $ic_image ) ) {
	
	if ( 'on' === $use_icon ) {
		if ( $font_icon ) {
			if ( 'off' === $use_icon_font_size ) {
				/* 
				default font_size 32px
				margin = font_size/2 + 30(padding)
				margin = 46px
				*/
				$margin = '-46px';
				if ( 'on' === $style_icon ) {
					/* 
					if border 4px will be added else 0
					margin = (font_size+border)/2 + 30(padding)
					margin = margin + 16(icon_padding)
					*/
					$margin = ( 'on' === $use_shape_border )  ? '-64px'   : '-62px';
				}
				/* Add margin to icon */
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'      => '%%order_class%% .image_card .card-icon',
					'declaration'   => sprintf( 'margin-top' . ': %1$s;', esc_html( $margin ) ),
				));
			} else {

				$margin_units = array(
					'desktop'   => str_replace( floatval( $font_size_values['desktop'] ), '', (string) $font_size_values['desktop'] ),
					'tablet'    => str_replace( floatval( $font_size_values['tablet'] ), '', (string) $font_size_values['tablet'] ),
					'phone'     => str_replace( floatval( $font_size_values['phone'] ), '', (string) $font_size_values['phone'] ),
				);

				$margin_values = array(
					'desktop' => 'px' === $margin_units['desktop'] ?
								 '-' . ( floatval( floatval( $icon_font_size ) / 2 ) + 30 ) . 'px' :
								 'calc(-' . floatval( floatval( $icon_font_size ) / 2 ) . $margin_units['desktop'] . ' - 30px)',
					'tablet'  => ! empty( $font_size_values['tablet'] ) ?
								 'px' === $margin_units['tablet'] ?
								 '-' . ( floatval( floatval( $font_size_values['tablet'] ) / 2 ) + 30 ) . 'px' :
								 'calc(-' . floatval( floatval( $font_size_values['tablet'] ) / 2 ) . $margin_units['tablet'] . ' - 30px)' :
								 '',
					'phone'   => ! empty( $font_size_values['phone'] ) ?
								 'px' === $margin_units['phone'] ?
								 '-' . ( floatval( floatval( $font_size_values['phone'] ) / 2 ) + 30 ) . 'px' :
								 'calc(-' . floatval( floatval( $font_size_values['phone'] ) / 2 ) . $margin_units['phone'] . ' - 30px)' :
								 '',
				);

				if ( 'on' === $style_icon ) {
					$margin_values = array(
						'desktop' => 'px' === $margin_units['desktop'] ?
									 '-' . ( floatval( ( floatval( $icon_font_size ) + 32 ) / 2 ) + 30 ) . 'px' :
									 'calc(-' . floatval( floatval( $icon_font_size ) / 2 ) . $margin_units['desktop'] . ' - 46px)',
						'tablet'  => ! empty( $font_size_values['tablet'] ) ?
									 'px' === $margin_units['tablet'] ?
									 '-' . ( floatval( ( floatval( $font_size_values['tablet'] ) + 32 ) / 2 ) + 30 ) . 'px' :
									 'calc(-' . floatval( floatval( $font_size_values['tablet'] ) / 2 ) . $margin_units['tablet'] . ' - 46px)' :
									 '',
						'phone'   => ! empty( $font_size_values['phone'] ) ?
									 'px' === $margin_units['phone'] ?
									 '-' . ( floatval( ( floatval( $font_size_values['phone'] ) + 32 ) / 2 ) + 30 ) . 'px' :
									 'calc(-' . floatval( floatval( $font_size_values['phone'] ) / 2 ) . $margin_units['phone'] . ' - 46px)' :
									 '',
					);
					
					if ( 'on' === $use_shape_border ) {
						$margin_values = array(
							'desktop' => 'px' === $margin_units['desktop'] ?
										 '-' . ( floatval( ( floatval( $icon_font_size ) + 36 ) / 2 ) + 30 ) . 'px' :
										 'calc(-' . floatval( floatval( $icon_font_size ) / 2 ) . $margin_units['desktop'] . ' - 48px)',
							'tablet'  => ! empty( $font_size_values['tablet'] ) ?
										 'px' === $margin_units['tablet'] ?
										 '-' . ( floatval( ( floatval( $font_size_values['tablet'] ) + 36 ) / 2 ) + 30 ) . 'px' :
										 'calc(-' . floatval( floatval( $font_size_values['tablet'] ) / 2 ) . $margin_units['tablet'] . ' - 48px)' :
										 '',
							'phone'   => ! empty( $font_size_values['phone'] ) ?
										 'px' === $margin_units['phone'] ?
										 '-' . ( floatval( ( floatval( $font_size_values['phone'] ) + 36 ) / 2 ) + 30 ) . 'px' :
										 'calc(-' . floatval( floatval( $font_size_values['phone'] ) / 2 ) . $margin_units['phone'] . ' - 48px)' :
										 '',
						);
					}
				}

				/* Add margin to icon */
				$margin_selector = '%%order_class%% .image_card .card-icon';
				$margin_property = 'margin-top';
				et_pb_generate_responsive_css( $margin_values, $margin_selector, $margin_property, $render_slug );
			}
		} else {
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%% .image_card .card-icon',
				'declaration'   => 'margin-bottom: 0;',
			));
		}
	} else {
		if ( '' !== $image ) {
			/* Add margin to icon */
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%% .image_card .card-icon',
				'declaration'   => 'margin-top: -70px;',
			));
		} else {
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%% .image_card .card-icon',
				'declaration'   => 'margin-bottom: 0;',
			));
		}
	}
}

if ( 'off' !== $read_more_button ) {
    $read_more_text     = ( '' !== $read_more_text )     ? esc_html( $read_more_text ) : 'Read more';
    $url                = ( '' !== $url ) ? esc_url( $url ) : '#';
    $read_more_button = $this->render_button( array(
        'button_text'      => esc_html__( $read_more_text, 'divi-blurb-extended' ),
        'button_url'       => $url,
        'button_custom'    => esc_html( $custom_read_more ),
        'custom_icon'      => $read_more_icon,
        'has_wrapper'      => false,
        'url_new_window'   => esc_html( $url_new_window ),
        'button_classname' => array( 'et_pb_more_button' ),
    ) );

    $button = '<span class="et_pb_blurb_extended_btn">'. $read_more_button .'</span>';
} else {
    $button = '';
}

$blurb_content  = __( wp_kses_post( $this->content ), 'divi-blurb-extended' );

$layout =  '<div class="et_pb_blurb_content">'
                . $ic_image .'
                <div class="et_pb_blurb_container">
                    <span class="card-icon">'. $image .'</span>'
        		     . $title .'
        		     <div class="et_pb_blurb_description">'
        		        . $blurb_content .
        		        $button .
    	            '</div>
	            </div>
            </div> <!-- .et_pb_blurb_content -->';