<?php
/**
 * @author      Elicus Technologies <hello@elicus.com>
 * @link        https://elicus.com/
 * @copyright   2021 Elicus Technologies Private Limited
 * @version     2.2.4
 */

class El_Blurb_Module extends ET_Builder_Module {

	protected $module_credits = array(
		'module_uri' => 'https://diviextended.com/product/divi-blurb-extended/',
		'author'     => 'Elicus',
		'author_uri' => 'https://elicus.com/',
	);

	public function init() {
		$this->name             = esc_html__( 'Divi Blurb Extended', 'divi-blurb-extended' );
		$this->slug       		= 'et_pb_blurb_extended';
		$this->main_css_element = '%%order_class%%.et_pb_blurb_extended';
		$this->vb_support 		= 'on';
		add_filter( 'et_builder_processed_range_value', array( $this, 'el_et_builder_processed_range_value' ), 10, 3 );
		add_filter( 'et_late_global_assets_list', array( $this, 'el_blurb_extended_late_assets' ), 10, 3 );
		add_filter( 'et_required_module_assets', array( $this, 'el_dbe_required_module_assets' ), 20 );
	}

	public function el_blurb_extended_late_assets( $assets_list, $assets_args, $dynamic_assets ) {
		if ( function_exists( 'et_get_dynamic_assets_path' ) && function_exists( 'et_is_cpt' ) ) {
			$cpt_suffix = et_is_cpt() ? '_cpt' : '';
            $assets_list['et_icons_all'] = array(
                'css' => $assets_args['assets_prefix'] . "/css/icons_all.css",
            );
            $assets_list['et_overlay'] = array(
                'css' => $assets_args['assets_prefix'] . "/css/overlay{$cpt_suffix}.css",
            );
            $assets_list['et_icons_fa'] = array(
                'css' => $assets_args['assets_prefix'] . "/css/icons_fa_all.css",
            );
            $assets_list['animations'] = array(
                'css' => $assets_args['assets_prefix'] . "/css/animations{$cpt_suffix}.css",
            );
            $assets_list['et_icons_social'] = array(
                'css' => $assets_args['assets_prefix'] . "/css/icons_base_social.css",
            );
			$assets_list['et_legacy_animations'] = array(
				'css' => $assets_args['assets_prefix'] . "/css/legacy_animations{$cpt_suffix}.css",
			);
		}
		return $assets_list;
	}

	public function el_dbe_required_module_assets( $modules ) {
		array_push( $modules, 'et_pb_blurb' );
		return $modules;
	}

	public function el_et_builder_processed_range_value( $result, $range, $range_string ) {
		if ( false !== strpos( $result, '0calc' ) ) {
			return $range;
		}
		return $result;
	}

	public function get_settings_modal_toggles() {
        return array(
            'general' => array(
                'toggles' => array(
                    'main_content' => array(
                        'title' => esc_html__( 'Blurb Content', 'divi-blurb-extended' ),
                    ),
                    'link' => array(
                        'title' => esc_html__( 'Blurb Link', 'divi-blurb-extended' ),
                    ),
                    'button' => array(
                        'title' => esc_html__( 'Button', 'divi-blurb-extended' ),
                    ),
                    'image' => array(
                        'title' => esc_html__( 'Image & Icon', 'divi-blurb-extended' ),
                    ),
                ),
            ),
            'advanced' => array(
                'toggles' => array(
                    'layout_settings' => array(
                        'title' => esc_html__( 'Layout', 'divi-blurb-extended' ),
                        'priority'  => 1,
                    ),
                    'content_background' => array(
                        'title' => esc_html__( 'Content Background', 'divi-blurb-extended' ),
                        'priority'  => 2,
                    ),
                    'flipbox_layout' => array(
                        'title' => esc_html__( 'Flipbox Settings', 'divi-blurb-extended' ),
                        'priority'  => 3,
                    ),
                    'easebox_layout' => array(
                        'title' => esc_html__( 'Easebox', 'divi-blurb-extended' ),
                        'priority'  => 3,
                    ),
                    'image_card_layout' => array(
                        'title' => esc_html__( 'Image Card', 'divi-blurb-extended' ),
                        'priority'  => 3,
                    ),
                    'borderbox_layout' => array(
                        'title' => esc_html__( 'Borderbox', 'divi-blurb-extended' ),
                        'priority'  => 3,
                    ),
                    'icon_settings' => array(
                        'title' => esc_html__( 'Image & Icon', 'divi-blurb-extended' ),
                        'priority'  => 4,
                    ),
                    'text_settings' => array(
                        'title'     => esc_html__( 'Blurb Text Settings', 'divi-blurb-extended' ),
                        'priority'  => 5,
                        'sub_toggles'	=> array(
                        						'blurb_text'		=> array(
												'name'		=> 'General',
											),
												'title_text'		=> array(
												'name'		=> 'Title',
											),
												'body_text'		=> array(
												'name'		=> 'Content',
											),
										),
                        'tabbed_subtoggles'	=> true,
                    ),
                    'hover_state' => array(
                        'title' => esc_html__( 'Hover State', 'divi-blurb-extended' ),
                        'priority'  => 6,
                        'sub_toggles'	=> array(
                        						'text_hover'		=> array(
													'name'		=> 'Text',
												),
                        						'button_hover'		=> array(
													'name'		=> 'Button',
												),
												'blurb_hover'		=> array(
													'name'		=> 'Elements',
												),
											),
                        'tabbed_subtoggles'	=> true,
                    ),
                    'width' => array(
    					'title'    => esc_html__( 'Sizing', 'divi-blurb-extended' ),
    					'priority' => 7,
    				),
                ),
            ),
        );
    }
    
    public function get_advanced_fields_config() {
        return array(
            'fonts' => array(
                'header' => array(
                    'label'     => esc_html__( 'Title', 'divi-blurb-extended' ),
                    'font_size' => array(
                        'default'           => '18px',
                        'range_settings'    => array(
                            'min'   => '1',
                            'max'   => '100',
                            'step'  => '1',
                        ),
                        'validate_unit'     => true,
                    ),
                    'line_height' => array(
                        'default'           => '1.5em',
                        'range_settings'    => array(
                            'min'   => '0.1',
                            'max'   => '10',
                            'step'  => '0.1',
                        ),
                    ),
                    'letter_spacing' => array(
                        'default'           => '0px',
                        'range_settings'    => array(
                            'min'   => '0',
                            'max'   => '10',
                            'step'  => '1',
                        ),
                        'validate_unit'     => true,
                    ),
					'css'       => array(
						'main'  => "{$this->main_css_element} h4, {$this->main_css_element} h4 a, {$this->main_css_element} h1.et_pb_module_header, {$this->main_css_element} h1.et_pb_module_header a, {$this->main_css_element} h2.et_pb_module_header, {$this->main_css_element} h2.et_pb_module_header a, {$this->main_css_element} h3.et_pb_module_header, {$this->main_css_element} h3.et_pb_module_header a, {$this->main_css_element} h5.et_pb_module_header, {$this->main_css_element} h5.et_pb_module_header a, {$this->main_css_element} h6.et_pb_module_header, {$this->main_css_element} h6.et_pb_module_header a",
					),
					'header_level'  => array(
						'default'   => 'h4',
					),
					'important' 			=> 'all',
					'tab_slug'				=> 'advanced',
					'toggle_slug'			=> 'text_settings',
					'sub_toggle'			=> 'title_text',
				),
				'body'  => array(
				    'label' => esc_html__( 'Body', 'divi-blurb-extended' ),
				    'font_size' => array(
                        'default'           => '14px',
                        'range_settings'    => array(
                            'min'   => '1',
                            'max'   => '100',
                            'step'  => '1',
                        ),
                        'validate_unit'     => true,
                    ),
                    'line_height' => array(
                        'default'           => '1.7em',
                        'range_settings'    => array(
                            'min'   => '0',
                            'max'   => '5',
                            'step'  => '0.1',
                        ),
                    ),
                    'letter_spacing' => array(
                        'default'           => '0px',
                        'range_settings'    => array(
                            'min'   => '0',
                            'max'   => '10',
                            'step'  => '1',
                        ),
                        'validate_unit'     => true,
                    ),
					'css'   => array(
						'main' => "{$this->main_css_element} .et_pb_blurb_description",
					),
					'important' 			=> 'all',
					'tab_slug'				=> 'advanced',
					'toggle_slug'			=> 'text_settings',
					'sub_toggle'			=> 'body_text',
				)
			),
			'text'  => array(
				'use_background_layout' => true,
				'options' => array(
					'background_layout' => array(
						'default_on_front' => 'light',
					),
					'text_orientation' => array(
						'default_on_front' => 'left',
					),
				),
				'important' 			=> 'all',
				'tab_slug'				=> 'advanced',
				'toggle_slug'			=> 'text_settings',
				'sub_toggle'			=> 'blurb_text',
			),
			'background' => array(
			    'css' => array(
				    'main' => "%%order_class%%",
			    ),
			),
			'button' => array(
			    'read_more' => array(
				    'label'             => esc_html__( 'Button', 'divi-blurb-extended' ),
				    'css'               => array(
				        'main' => "{$this->main_css_element} .et_pb_more_button",
						'plugin_main' => "{$this->main_css_element} .et_pb_more_button.et_pb_button",
				    ),
				    'no_rel_attr'       => true,
				    'use_alignment'     => false,
				    'box_shadow'        => false,
				    'depends_on'        => array( 'read_more_button' ),
		            'depends_show_if'   => 'on',
				    'tab_slug'          => 'general',
				    'toggle_slug'       => 'button',
			    ),
			),
			'custom_margin_padding' => array(
			    'css' => array(
				    'main'      => "{$this->main_css_element} .et_pb_blurb_content",
					'important' => 'all',
			    ),
			),
			'max_width' => array(
				'css' => array(
					'main'              => $this->main_css_element,
					'module_alignment'  => '%%order_class%%.et_pb_blurb_extended.et_pb_module',
				),
			),
			'filters'   => false,
			'borders' => array(
			    'default' => array(
    			    'css' => array(
    				    'main' => array(
    				        'border_styles' => "%%order_class%%",
    				        'border_radii'  => "%%order_class%%",
    				    ),
    			    ),
    			)
			),
        );
    }
    
    public function get_custom_css_fields_config() {
        return array(
            'blurb_image' => array(
				'label'     => esc_html__( 'Blurb Image', 'divi-blurb-extended' ),
				'selector'  => '.et_pb_main_blurb_image'
			),
			'blurb_title' => array(
				'label'     => esc_html__( 'Blurb Title', 'divi-blurb-extended' ),
				'selector'  => '.et_pb_module_header'
			),
			'blurb_content' => array(
				'label'     => esc_html__( 'Blurb Content', 'divi-blurb-extended' ),
				'selector'  => '.et_pb_blurb_content'
			),
			'read_more' => array(
				'label'     => esc_html__( 'Read More Button', 'divi-blurb-extended' ),
				'selector'  => '.et_pb_more_button.et_pb_button'
			),
        );
    }

	public function get_fields() {
	    $et_accent_color = et_builder_accent_color();

		return array(
			'title' => array(
				'label'                 => esc_html__( 'Blurb Title', 'divi-blurb-extended' ),
				'type'                  => 'text',
				'option_category'       => 'basic_option',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'main_content',
				'description'           => esc_html__( 'Here you can input the text to be used for the blurb title.', 'divi-blurb-extended' ),
			),
			'url' => array(
				'label'                 => esc_html__( 'Blurb Url', 'divi-blurb-extended' ),
				'type'                  => 'text',
				'option_category'       => 'basic_option',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'link',
				'description'           => esc_html__( 'Here you can input the URL of the page that you want to open when the user clicks on the blurb.', 'divi-blurb-extended' ),
			),
			'url_new_window' => array(
				'label'                 => esc_html__( 'Url Opens in New Window', 'divi-blurb-extended' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'configuration',
				'options'               => array(
				    'off'   => esc_html__( 'No', 'divi-blurb-extended' ),
					'on'    => esc_html__( 'YES', 'divi-blurb-extended' ),
				),
				'default'               => 'off',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'link',
				'description'           => esc_html__( 'Here you can choose whether or not your link opens in a new window', 'divi-blurb-extended' ),
			),
			'read_more_button' => array(
				'label'                 => esc_html__( 'Read More Button', 'divi-blurb-extended' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'basic_option',
				'options'               => array(
					'off'   => esc_html__( 'No', 'divi-blurb-extended' ),
					'on'    => esc_html__( 'Yes', 'divi-blurb-extended' ),
				),
				'affects'               => array(
				    'custom_read_more',
				),
				'default'               => 'off',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'button',
				'description'           => esc_html__( 'Here you can choose whether or not use read more button on the blurb.', 'divi-blurb-extended' ),
			),
			'read_more_text' => array(
				'label'                 => esc_html__( 'Read More Button Text', 'divi-blurb-extended' ),
				'type'                  => 'text',
				'option_category'       => 'basic_option',
				'show_if'               => array(
				    'read_more_button'  => 'on',
				),
				'tab_slug'              => 'general',
				'toggle_slug'           => 'button',
				'description'           => esc_html__( 'Here you can input the text to be used for the  Read More Button.', 'divi-blurb-extended' ),
			),
			'read_more_hover_background_color' => array(
				'label'                 => esc_html__( 'Button Background Color', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
				    'read_more_button'  => 'on',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'hover_state',
				'description'           => esc_html__( 'Pick a color to be used for the Button Background on hover.', 'divi-blurb-extended' ),
				'sub_toggle'			=> 'button_hover',
			),
			'read_more_hover_border_color' => array(
				'label'                 => esc_html__( 'Button Border Color', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
				    'read_more_button'  => 'on',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'hover_state',
				'description'           => esc_html__( 'Pick a color to be used for the Button Border on hover.', 'divi-blurb-extended' ),
				'sub_toggle'			=> 'button_hover',
			),
			'read_more_hover_text_color' => array(
				'label'                 => esc_html__( 'Button Text Color', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
				    'read_more_button'  => 'on',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'hover_state',
				'description'           => esc_html__( 'Pick a color to be used for the Button Text on hover.', 'divi-blurb-extended' ),
				'sub_toggle'			=> 'button_hover',
			),
			'use_icon' => array(
				'label'                 => esc_html__( 'Use Icon', 'divi-blurb-extended' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'basic_option',
				'options'               => array(
					'off'   => esc_html__( 'No', 'divi-blurb-extended' ),
					'on'    => esc_html__( 'Yes', 'divi-blurb-extended' ),
				),
				'default'               => 'off',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'image',
				'description'           => esc_html__( 'Here you can choose whether or not to use an icon above blurb title.', 'divi-blurb-extended' ),
			),
			'font_icon' => array(
				'label'                 => esc_html__( 'Icon', 'divi-blurb-extended' ),
				'type'                  => 'select_icon',
				'option_category'       => 'basic_option',
				'class'                 => array(
					'et-pb-font-icon'
				),
				'show_if'               => array(
				    'use_icon'  => 'on',
				),
				'tab_slug'              => 'general',
				'toggle_slug'           => 'image',
				'description'           => esc_html__( 'Choose an icon to display with the blurb.', 'divi-blurb-extended' ),
			),
			'icon_placement' => array(
				'label'                 => esc_html__( 'Image/Icon Placement', 'divi-blurb-extended' ),
				'type'                  => 'select',
				'option_category'       => 'layout',
				'options'               => array(
        			'top'   => esc_html__( 'Top', 'divi-blurb-extended' ),
        			'left'  => esc_html__( 'Left', 'divi-blurb-extended' ),
        			'right' => esc_html__( 'Right', 'divi-blurb-extended' ),
        		),
        		'default'               => 'top',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
				'description'           => esc_html__( 'Here you can choose where to place an icon or image on the blurb.', 'divi-blurb-extended' ),
			),
			'icon_color' => array(
				'label'                 => esc_html__( 'Icon Color', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'show_if'               => array(
				    'use_icon'  => 'on',
				),
				'default'               => $et_accent_color,
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
				'description'           => esc_html__('Pick a color to be used for the icon on the blurb.', 'divi-blurb-extended'),
			),
			'use_icon_font_size' => array(
				'label'                 => esc_html__( 'Use Icon Font Size', 'divi-blurb-extended' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'font_option',
				'options'               => array(
					'off'   => esc_html__( 'No', 'divi-blurb-extended' ),
					'on'    => esc_html__( 'Yes', 'divi-blurb-extended' )
				),
				'show_if'               => array(
				    'use_icon'  => 'on',
				),
				'default'               => 'off',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
				'description'           => esc_html__('Here you can choose whether or not to adjust the icon size.', 'divi-blurb-extended'),

			),
			'icon_font_size' => array(
				'label'                 => esc_html__( 'Icon Font Size', 'divi-blurb-extended' ),
				'type'                  => 'range',
				'option_category'       => 'font_option',
				'range_settings'        => array(
					'min'   => '1',
					'max'   => '120',
					'step'  => '1',
				),
				'mobile_options'        => true,
				'show_if'               => array(
					'use_icon'  			=> 'on',
				    'use_icon_font_size'    => 'on',
				),
				'default'               => '32px',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
				'description'           => esc_html__('Increase or decrease the icon size.', 'divi-blurb-extended'),

			),
			'icon_hover_color' => array(
				'label'                 => esc_html__( 'Icon Color', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
				    'use_icon'  => 'on',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'hover_state',
				'sub_toggle'			=> 'blurb_hover',
				'description'           => esc_html__( 'Pick a color to be used for the icon on hover.', 'divi-blurb-extended' ),
			),
			'style_icon' => array(
				'label'                 => esc_html__( 'Style Icon', 'divi-blurb-extended' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'configuration',
				'options'               => array(
					'off'   => esc_html__( 'No', 'divi-blurb-extended' ),
					'on'    => esc_html__( 'Yes', 'divi-blurb-extended' )
				),
				'show_if'               => array(
				    'use_icon'  => 'on',
				),
				'default'               => 'off',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
				'description'           => esc_html__( 'Here you can choose whether icon set above the blurb title should display within a shape or not.', 'divi-blurb-extended' ),
			),
			'icon_shape' => array(
				'label'                 => esc_html__( 'Shape', 'divi-blurb-extended' ),
				'type'                  => 'select',
				'option_category'       => 'configuration',
				'options'               => array(
					'use_square'    => esc_html__( 'Square', 'divi-blurb-extended' ),
					'use_circle'    => esc_html__( 'Circle', 'divi-blurb-extended' ),
					'use_hexagon'   => esc_html__( 'Hexagon', 'divi-blurb-extended' )
				),
				'show_if'               => array(
					'use_icon'  	=> 'on',
				    'style_icon'    => 'on',
				),
				'default' 				=> 'use_square',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
				'description'           => esc_html__( 'Here you can choose shape to display icon within.', 'divi-blurb-extended' ),
			),
			'shape_color' => array(
				'label'                 => esc_html__( 'Shape Background', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
					'use_icon'  	=> 'on',
				    'style_icon'    => 'on',
				),
				'default'               => $et_accent_color,
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
				'description'           => esc_html__( 'Pick a color to be used for the icon shape.', 'divi-blurb-extended' ),
			),
			'shape_hover_color' => array(
				'label'                 => esc_html__( 'Icon Shape Background Color', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
					'use_icon'  	=> 'on',
				    'style_icon'    => 'on',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'hover_state',
				'sub_toggle'			=> 'blurb_hover',
				'description'           => esc_html__( 'Pick a color to be used for the icon shape background on hover.', 'divi-blurb-extended' ),
			),
			'use_shape_border' => array(
				'label'                 => esc_html__( 'Display Shape Border', 'divi-blurb-extended' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'layout',
				'options'               => array(
					'off'   => esc_html__( 'No', 'divi-blurb-extended' ),
					'on'    => esc_html__( 'Yes', 'divi-blurb-extended' )
				),
				'show_if'               => array(
					'use_icon'  	=> 'on',
				    'style_icon'    => 'on',
				),
				'default'               => 'off',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
				'description'           => esc_html__( 'Here you can choose whether or not to display shape border.', 'divi-blurb-extended' ),
			),
			'shape_border_color' => array(
				'label'                 => esc_html__( 'Shape Border Color', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
					'use_icon'  		=> 'on',
					'style_icon'    	=> 'on',
				    'use_shape_border'  => 'on',
				),
				'default'               => $et_accent_color,
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
				'description'           => esc_html__( 'Pick a color to be used for the shape border.', 'divi-blurb-extended' ),
			),
			'shape_border_hover_color' => array(
				'label'                 => esc_html__( 'Shape Border Color', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
					'use_icon'  		=> 'on',
					'style_icon'    	=> 'on',
				    'use_shape_border'  => 'on',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'hover_state',
				'sub_toggle'			=> 'blurb_hover',
				'description'           => esc_html__( 'Pick a color to be used for the icon shape border on hover.', 'divi-blurb-extended' ),
			),
			'image' => array(
				'label'                 => esc_html__( 'Image', 'divi-blurb-extended' ),
				'type'                  => 'upload',
				'option_category'       => 'basic_option',
				'upload_button_text'    => esc_attr__( 'Upload an image', 'divi-blurb-extended' ),
				'choose_text'           => esc_attr__( 'Choose an Image', 'divi-blurb-extended' ),
				'update_text'           => esc_attr__( 'Set As Image', 'divi-blurb-extended' ),
				'show_if'               => array(
				    'use_icon'  => 'off',
				),
				'tab_slug'              => 'general',
				'toggle_slug'           => 'image',
				'description'           => esc_html__( 'Upload an image to display at the top of your blurb.', 'divi-blurb-extended' ),
			),
			'alt' => array(
				'label'                 => esc_html__( 'Image Alt Text', 'divi-blurb-extended' ),
				'type'                  => 'text',
				'option_category'       => 'basic_option',
				'show_if'               => array(
				    'use_icon'  => 'off',
				),
				'tab_slug'              => 'general',
				'toggle_slug'           => 'image',
				'description'           => esc_html__( 'Here you can input the text to be used for the image as HTML ALT text.', 'divi-blurb-extended' ),
			),
			'image_max_width' => array(
				'label'                 => esc_html__( 'Image Width', 'divi-blurb-extended' ),
				'type'                  => 'range',
				'option_category'       => 'layout',
				'range_settings'        => array(
					'min'   => '50',
					'max'   => '550',
					'step'  => '1',
				),
				'show_if'               => array(
				    'use_icon'  => 'off',
				),
				'allowed_units'   		=> array( 'px' ),
				'default_unit'    		=> 'px',
				'default' 				=> '64px',
				'mobile_options'        => true,
				'validate_unit'         => true,
				'allow_empty'           => true,
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
				'description'           => esc_html__( 'Here you can increase or decrease the width of the image.', 'divi-blurb-extended' ),
			),
			'content_background_color' => array(
				'label'                 => esc_html__( 'Content Background Color', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if_not'               => array(
					'blurb_layout'    	=> 'flipbox',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'content_background',
				'description'           => esc_html__( 'Pick a color to be used for the blurb content background.', 'divi-blurb-extended' ),
			),
			'title_hover_color' => array(
				'label'                 => esc_html__( 'Title Text Color', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'hover_state',
				'sub_toggle'			=> 'text_hover',
				'description'           => esc_html__( 'Pick a color to be used for the Blurb Title Text on hover.', 'divi-blurb-extended' ),
			),
			'text_hover_color' => array(
				'label'                 => esc_html__( 'Content Text Color', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'hover_state',
				'sub_toggle'			=> 'text_hover',
				'description'           => esc_html__( 'Pick a color to be used for the Blurb Content Text on hover.', 'divi-blurb-extended' ),
			),
			'blurb_hover_color' => array(
				'label'                 => esc_html__( 'Content Background Color on Hover', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if_not'           => array(
					'blurb_layout'  => 'flipbox',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'hover_state',
				'sub_toggle'			=> 'blurb_hover',
				'description'           => esc_html__( 'Pick a color to be used for the content background of the blurb on hover.', 'divi-blurb-extended' ),
			),
			'content_max_width' => array(
				'label'                 => esc_html__( 'Content Width', 'divi-blurb-extended' ),
				'type'                  => 'range',
				'option_category'       => 'layout',
				'mobile_options'        => true,
				'validate_unit'         => true,
				'allow_empty'           => true,
				'range_settings'        => array(
					'min'   => '0',
					'max'   => '1100',
					'step'  => '1',
				),
				'default'               => '550px',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
				'description'           => esc_html__( 'Here you can increase or decrease the width of the blurb content.', 'divi-blurb-extended' ),
			),
			'blurb_layout' => array(
				'label'                 => esc_html__( 'Layout', 'divi-blurb-extended' ),
				'type'                  => 'select',
				'option_category'       => 'layout',
				'options'               => array(
					'classic'       => esc_html__( 'Classic', 'divi-blurb-extended' ),
					'flipbox'       => esc_html__( 'Flipbox', 'divi-blurb-extended' ),
					'easebox'       => esc_html__( 'Easebox', 'divi-blurb-extended' ),
					'borderbox'     => esc_html__( 'Borderbox', 'divi-blurb-extended' ),
					'image_card'    => esc_html__( 'Image Card', 'divi-blurb-extended' ),
				),
				'default'               => 'classic',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'layout_settings',
				'description'           => esc_html__( 'Here you can choose the blurb layout.', 'divi-blurb-extended' ),
			),
			'fb_front_background' => array(
				'label'                 => esc_html__( 'Front', 'divi-blurb-extended' ),
				'type'                  => 'select',
				'option_category'       => 'layout',
				'options'               => array(
					'color'     => esc_html__( 'Color', 'divi-blurb-extended' ),
					'image'     => esc_html__( 'Image', 'divi-blurb-extended' ),
				),
				'show_if'               => array(
				    'blurb_layout'  => 'flipbox',
				),
				'default'               => 'color',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'flipbox_layout',
				'description'           => esc_html__( 'Here you can customize the frontside of the flipbox by adjusting background color or image.', 'divi-blurb-extended' ),
			),
			'fb_front_background_color' => array(
				'label'                 => esc_html__( 'Front Color', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
				    'blurb_layout'          => 'flipbox',
				    'fb_front_background'   => 'color',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'flipbox_layout',
				'default' 				=> '#ffffff',
				'description'           => esc_html__( 'Pick a color to be used for the background on the frontside of the flipbox.', 'divi-blurb-extended' ),
			),
			'fb_front_background_image' => array(
				'label'                 => esc_html__( 'Front Image', 'divi-blurb-extended' ),
				'type'                  => 'upload',
				'option_category'       => 'basic_option',
				'upload_button_text'    => esc_attr__( 'Upload an image', 'divi-blurb-extended' ),
				'choose_text'           => esc_attr__( 'Choose an Image', 'divi-blurb-extended' ),
				'update_text'           => esc_attr__( 'Set As Image', 'divi-blurb-extended' ),
				'show_if'               => array(
				    'blurb_layout'          => 'flipbox',
				    'fb_front_background'   => 'image',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'flipbox_layout',
				'description'           => esc_html__( 'Upload an image to display at the background on the frontside of the flipbox.', 'divi-blurb-extended' ),
			),
			'fb_back_background' => array(
				'label'                 => esc_html__( 'Back', 'divi-blurb-extended' ),
				'type'                  => 'select',
				'option_category'       => 'layout',
				'options'               => array(
					'color'     => esc_html__( 'Color', 'divi-blurb-extended' ),
					'image'     => esc_html__( 'Image', 'divi-blurb-extended' ),
				),
				'show_if'               => array(
				    'blurb_layout'  => 'flipbox',
				),
				'default'               => 'color',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'flipbox_layout',
				'description'           => esc_html__( 'Here you can customize the backside of the flipbox by adjusting the background color or image.', 'divi-blurb-extended' ),

			),
			'fb_back_background_color' => array(
				'label'                 => esc_html__( 'Back Color', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
				    'blurb_layout'          => 'flipbox',
				    'fb_back_background'    => 'color',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'flipbox_layout',
				'default' 				=> '#ffffff',
				'description'           => esc_html__( 'Pick a color to be used for the background on the backside of the flipbox.', 'divi-blurb-extended' ),

			),
			'fb_back_background_image' => array(
				'label'                 => esc_html__( 'Back Image', 'divi-blurb-extended' ),
				'type'                  => 'upload',
				'option_category'       => 'basic_option',
				'upload_button_text'    => esc_attr__( 'Upload an image', 'divi-blurb-extended' ),
				'choose_text'           => esc_attr__( 'Choose an Image', 'divi-blurb-extended' ),
				'update_text'           => esc_attr__( 'Set As Image', 'divi-blurb-extended' ),
				'show_if'               => array(
				    'blurb_layout'          => 'flipbox',
				    'fb_back_background'    => 'image',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'flipbox_layout',
				'description'           => esc_html__( 'Upload an image to display at the background on the backside of the flipbox.', 'divi-blurb-extended' ),
			),
			'fb_height' => array(
				'label'                 => esc_html__( 'Flipbox Height', 'divi-blurb-extended' ),
				'type'                  => 'range',
				'range_settings'        => array(
					'min'   => '100',
					'max'   => '1000',
					'step'  => '10',
				),
				'mobile_options'        => true,
				'show_if'               => array(
				    'blurb_layout'          => 'flipbox',
				),
				'default'               => '350px',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'flipbox_layout',
				'description'           => esc_html__( 'Increase or decrease the height of the Flipbox.', 'divi-blurb-extended' ),
			),
			'fb_height_last_edited' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'flipbox_layout',
			),
			'fb_height_tablet' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'flipbox_layout',
			),
			'fb_height_phone' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'flipbox_layout',
			),
			'ic_image' => array(
				'label'                 => esc_html__( 'Top Image', 'divi-blurb-extended' ),
				'type'                  => 'upload',
				'option_category'       => 'basic_option',
				'upload_button_text'    => esc_attr__( 'Upload an image', 'divi-blurb-extended' ),
				'choose_text'           => esc_attr__( 'Choose an Image', 'divi-blurb-extended' ),
				'update_text'           => esc_attr__( 'Set As Image', 'divi-blurb-extended' ),
				'show_if'               => array(
				    'blurb_layout'  => 'image_card',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'image_card_layout',
				'description'           => esc_html__( 'Upload an image to display at the top of your Image Card.', 'divi-blurb-extended' ),
			),
			'ic_image_alt' => array(
				'label'                 => esc_html__( 'Image Alt Text', 'divi-blurb-extended' ),
				'type'                  => 'text',
				'option_category'       => 'basic_option',
				'show_if'               => array(
				    'blurb_layout'  => 'image_card',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'image_card_layout',
				'description'           => esc_html__( 'Define the HTML ALT text for your image here.', 'divi-blurb-extended' ),
			),
			'borderbox_border_color' => array(
				'label'                 => esc_html__( 'Border Color', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
				    'blurb_layout'  => 'borderbox',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'borderbox_layout',
				'description'           => esc_html__( 'Here you can define a custom color for the border.', 'divi-blurb-extended' ),
			),
			'borderbox_hover_border_color' => array(
				'label'                 => esc_html__( 'Borderbox Border Color', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
				    'blurb_layout'  => 'borderbox',
				),
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'hover_state',
				'sub_toggle'			=> 'blurb_hover',
				'description'           => esc_html__( 'Pick a color to be used for the border of the Borderbox layout.', 'divi-blurb-extended' ),
			),
			'animation' => array(
				'label'                 => esc_html__( 'Image/Icon Animation', 'divi-blurb-extended' ),
				'type'                  => 'select',
				'option_category'       => 'configuration',
				'options'               => array(
					'top'       => esc_html__( 'Top To Bottom', 'divi-blurb-extended' ),
					'left'      => esc_html__( 'Left To Right', 'divi-blurb-extended' ),
					'right'     => esc_html__( 'Right To Left', 'divi-blurb-extended' ),
					'bottom'    => esc_html__( 'Bottom To Top', 'divi-blurb-extended' ),
					'off'       => esc_html__( 'No Animation', 'divi-blurb-extended' ),
				),
				'default'               => 'top',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'animation',
				'description'           => esc_html__( 'This controls the direction of the lazy-loading animation.', 'divi-blurb-extended' ),
			),
			'content' => array(
				'label'                 => esc_html__( 'Blurb Content', 'divi-blurb-extended' ),
				'type'                  => 'tiny_mce',
				'option_category'       => 'basic_option',
				'toggle_slug'           => 'main_content',
				'description'           => esc_html__( 'Here you can input the text to be used for the blurb content.', 'divi-blurb-extended' ),
			),
			'image_max_width_tablet' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'image_max_width_phone' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'image_max_width_last_edited' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'content_max_width_tablet' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'content_max_width_phone' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'content_max_width_last_edited' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'icon_font_size_last_edited' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
			),
			'icon_font_size_tablet' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
			),
			'icon_font_size_phone' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'icon_settings',
			),
			'disabled_on' => array(
				'label'                 => esc_html__( 'Disable on', 'divi-blurb-extended' ),
				'type'                  => 'multiple_checkboxes',
				'options'               => array(
					'phone'     => esc_html__( 'Phone', 'divi-blurb-extended' ),
					'tablet'    => esc_html__( 'Tablet', 'divi-blurb-extended' ),
					'desktop'   => esc_html__( 'Desktop', 'divi-blurb-extended' ),
				),
				'additional_att'        => 'disable_on',
				'option_category'       => 'configuration',
				'tab_slug'              => 'custom_css',
				'toggle_slug'           => 'visibility',
				'description'           => esc_html__( 'This will disable the module on selected devices', 'divi-blurb-extended' ),
			),
			'admin_label' => array(
				'label'                 => esc_html__( 'Admin Label', 'divi-blurb-extended' ),
				'type'                  => 'text',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'admin_label',
				'description'           => esc_html__('This will change the label of the module in the builder for easy identification.', 'divi-blurb-extended'),
			),
			'module_id' => array(
				'label'                 => esc_html__( 'CSS ID', 'divi-blurb-extended' ),
				'type'                  => 'text',
				'option_category'       => 'configuration',
				'option_class'          => 'et_pb_custom_css_regular',
				'tab_slug'              => 'custom_css',
				'toggle_slug'           => 'classes',
				'description'           => esc_html__('Here you can input the custom id of the module.', 'divi-blurb-extended'),
			),
			'module_class' => array(
				'label'                 => esc_html__( 'CSS Class', 'divi-blurb-extended' ),
				'type'                  => 'text',
				'option_category'       => 'configuration',
				'option_class'          => 'et_pb_custom_css_regular',
				'tab_slug'              => 'custom_css',
				'toggle_slug'           => 'classes',
				'description'           => esc_html__('Here you can input the custom classes of the module.', 'divi-blurb-extended'),
			)
		);
	}

	public function render( $attrs, $content, $render_slug ) {
		$module_id                          = esc_attr( $this->props['module_id'] );
		$module_class                       = esc_attr( $this->props['module_class'] );
		$title                              = esc_attr( $this->props['title'] );
		$url                                = esc_url( $this->props['url'] );
		$image                              = esc_attr( $this->props['image'] );
		$url_new_window                     = esc_attr( $this->props['url_new_window'] );
		$read_more_button                   = esc_attr( $this->props['read_more_button'] );
		$read_more_text                     = esc_attr( $this->props['read_more_text'] );
		$read_more_icon                     = $this->props['read_more_icon'];
		$read_more_use_icon                 = esc_attr( $this->props['read_more_use_icon'] );
		$custom_read_more                   = esc_attr( $this->props['custom_read_more'] );
		$alt                                = esc_attr( $this->props['alt'] );
		$background_layout                  = esc_attr( $this->props['background_layout'] );
		$text_orientation                   = esc_attr( $this->props['text_orientation'] );
		$animation                          = esc_attr( $this->props['animation'] );
		$blurb_layout                       = esc_attr( $this->props['blurb_layout'] );
		$content_background_color 			= esc_attr( $this->props['content_background_color'] );
		$fb_front_background                = esc_attr( $this->props['fb_front_background'] );
		$fb_back_background                 = esc_attr( $this->props['fb_back_background'] );
		$fb_front_color                     = esc_attr( $this->props['fb_front_background_color'] );
		$fb_front_image                     = esc_attr( $this->props['fb_front_background_image'] );
		$fb_back_color                      = esc_attr( $this->props['fb_back_background_color'] );
		$fb_back_image                      = esc_attr( $this->props['fb_back_background_image'] );
		$fb_height 							= esc_attr( $this->props['fb_height'] );
		$fb_height_tablet					= esc_attr( $this->props['fb_height_tablet'] );
		$fb_height_phone					= esc_attr( $this->props['fb_height_phone'] );
		$fb_height_last_edited 				= esc_attr( $this->props['fb_height_last_edited'] );
		$ic_image                           = esc_attr( $this->props['ic_image'] );
		$ic_image_alt                       = esc_attr( $this->props['ic_image_alt'] );
		$borderbox_border_color             = esc_attr( $this->props['borderbox_border_color'] );
		$borderbox_hover_border_color       = esc_attr( $this->props['borderbox_hover_border_color'] );
		$icon_placement                     = esc_attr( $this->props['icon_placement'] );
		$font_icon                          = esc_attr( $this->props['font_icon'] );
		$use_icon                           = esc_attr( $this->props['use_icon'] );
		$icon_color                         = esc_attr( $this->props['icon_color'] );
		$style_icon                         = esc_attr( $this->props['style_icon'] );
		$icon_shape                         = esc_attr( $this->props['icon_shape'] );
		$shape_color                        = esc_attr( $this->props['shape_color'] );
		$use_shape_border                   = esc_attr( $this->props['use_shape_border'] );
		$shape_border_color                 = esc_attr( $this->props['shape_border_color'] );
		$shape_hover_color                  = esc_attr( $this->props['shape_hover_color'] );
		$shape_border_hover_color           = esc_attr( $this->props['shape_border_hover_color'] );
		$icon_hover_color                   = esc_attr( $this->props['icon_hover_color'] );
		$title_hover_color                  = esc_attr( $this->props['title_hover_color'] );
		$text_hover_color                   = esc_attr( $this->props['text_hover_color'] );
		$read_more_hover_background_color   = esc_attr( $this->props['read_more_hover_background_color'] );
		$read_more_hover_border_color       = esc_attr( $this->props['read_more_hover_border_color'] );
		$read_more_hover_text_color         = esc_attr( $this->props['read_more_hover_text_color'] );
		$blurb_hover_color                  = esc_attr( $this->props['blurb_hover_color'] );
		$use_icon_font_size                 = esc_attr( $this->props['use_icon_font_size'] );
		$icon_font_size                     = esc_attr( $this->props['icon_font_size'] );
		$icon_font_size_tablet              = esc_attr( $this->props['icon_font_size_tablet'] );
		$icon_font_size_phone               = esc_attr( $this->props['icon_font_size_phone'] );
		$icon_font_size_last_edited         = esc_attr( $this->props['icon_font_size_last_edited'] );
		$image_max_width                    = esc_attr( $this->props['image_max_width'] );
		$image_max_width_tablet             = esc_attr( $this->props['image_max_width_tablet'] );
		$image_max_width_phone              = esc_attr( $this->props['image_max_width_phone'] );
		$image_max_width_last_edited        = esc_attr( $this->props['image_max_width_last_edited'] );
		$content_max_width                  = esc_attr( $this->props['content_max_width'] );
		$content_max_width_tablet           = esc_attr( $this->props['content_max_width_tablet'] );
		$content_max_width_phone            = esc_attr( $this->props['content_max_width_phone'] );
		$content_max_width_last_edited      = esc_attr( $this->props['content_max_width_last_edited'] );
		$header_level                       = esc_attr( $this->props['header_level'] );
	
		$image_pathinfo         = pathinfo( $image );
		$is_image_svg           = isset( $image_pathinfo['extension'] ) ? 'svg' === $image_pathinfo['extension'] : false;
		$processed_header_level = et_pb_process_header_level( $header_level, 'h4' );
		$processed_header_level = esc_html( $processed_header_level );

		
		
		if ( 'off' !== $use_icon_font_size ) {
			$font_size_responsive_active = et_pb_get_responsive_status( $icon_font_size_last_edited );
			
			$font_size_values = array(
				'desktop'   => $icon_font_size,
				'tablet'    => $font_size_responsive_active ? $icon_font_size_tablet : '',
				'phone'     => $font_size_responsive_active ? $icon_font_size_phone : '',
			);
			
			et_pb_generate_responsive_css( $font_size_values, '%%order_class%% .' . $blurb_layout . ' .et-pb-icon', 'font-size', $render_slug );
		}
		
		if ( '' !== $image_max_width_tablet || '' !== $image_max_width_phone || '' !== $image_max_width || $is_image_svg ) {
			// SVG image overwrite. SVG image needs its value to be explicit
			if ( '' === $image_max_width && $is_image_svg ) {
				$image_max_width = '100%';
			}

			$image_max_width_selector = '%%order_class%% .' . $blurb_layout . '.use-image .et_pb_main_blurb_image';
			$image_max_width_property =  'width'; //$is_image_svg ? 'width' : 'max-width';

			$image_max_width_responsive_active = et_pb_get_responsive_status( $image_max_width_last_edited );

			$image_max_width_values = array(
				'desktop' => $image_max_width,
				'tablet'  => $image_max_width_responsive_active ? $image_max_width_tablet : '',
				'phone'   => $image_max_width_responsive_active ? $image_max_width_phone : '',
			);

			et_pb_generate_responsive_css( $image_max_width_values, $image_max_width_selector, $image_max_width_property, $render_slug );
		}
		
		if ( '' !== $content_max_width_tablet || '' !== $content_max_width_phone || '' !== $content_max_width ) {
			$content_max_width_responsive_active = et_pb_get_responsive_status( $content_max_width_last_edited );

			$content_max_width_values = array(
				'desktop' => $content_max_width,
				'tablet'  => $content_max_width_responsive_active ? $content_max_width_tablet : '',
				'phone'   => $content_max_width_responsive_active ? $content_max_width_phone : '',
			);

			et_pb_generate_responsive_css( $content_max_width_values, '%%order_class%% .' . $blurb_layout . ' .et_pb_blurb_content', 'max-width', $render_slug );
		}
		
		if ( '' !== $title && '' !== $url ) {
			$title = sprintf( '<a href="%1$s"%3$s>%2$s</a>',
						esc_url( $url ),
						esc_html__( $title, 'divi-blurb-extended' ),
						(
							'on' === $url_new_window ?
							' target="_blank"' :
							''
						)
					);
		}
		
		if ( '' !== $title ) {
			$title = sprintf( '<%1$s class="et_pb_module_header">%2$s</%1$s>',
						$processed_header_level,
						$title
					);
		}
		
		// Added for backward compatibility
		if ( empty( $animation ) ) {
			$animation = 'top';
		}
		
		if ( 'off' === $use_icon ) {
			    $image_class    = ( '' !== trim( $image ) ) ? ' use-image' : '';
				$image          = ( '' !== trim( $image ) ) ?
									sprintf( '<img src="%1$s" alt="%2$s" class="et-waypoint%3$s" />',
										esc_url( $image ),
										esc_attr( $alt ),
										esc_attr( " et_pb_animation_{$animation}" )
									) :
									'';
		} else {
			$icon_style     = sprintf( 'color: %1$s;', esc_attr( $icon_color ) );
			$image_class    = '';
			$icon_class     = '';
			$hexagon_start  = '';
			$hexagon_end    = '';
			
			if ( 'on' === $style_icon ) {
				
				if ( 'use_circle' === $icon_shape ) {
					$icon_class     = ' el-icon-circle';
					$icon_style    .= sprintf( ' background-color: %1$s;', esc_attr( $shape_color ) );
					if ( 'on' === $use_shape_border ) {
						$icon_style .= sprintf( ' border-color: %1$s;', esc_attr( $shape_border_color ) );
					}
				} else if ( 'use_square' === $icon_shape ) {
					$icon_class     = ' el-icon-square';
					$icon_style    .= sprintf( ' background-color: %1$s;', esc_attr( $shape_color ) );
					if ( 'on' === $use_shape_border ) {
						$icon_style .= sprintf( ' border-color: %1$s;', esc_attr( $shape_border_color ) );
					}
				} else if ( 'use_hexagon' === $icon_shape ) {
					$icon_class     = ' el-icon-hexagon';
					$hexagon_style  = sprintf( ' background-color: %1$s;', esc_attr( $shape_color ) );
					if ( 'on' === $use_shape_border ) {
						$hexagon_style  .= sprintf( ' border-color: %1$s;', esc_attr( $shape_border_color ) );
					}
					$hexagon_start = sprintf( '<div class="hexagon-wrapper et-waypoint%2$s"><div class="hex"><div class="hexagon%3$s" style="%1$s">',
									 	$hexagon_style,
									 	esc_attr( " et_pb_animation_{$animation}" ),
									 	( 'on' === $use_shape_border ? ' et-pb-icon-shape-border' : '' )
									 );
					$hexagon_end   = '</div></div></div>';
				}
				
			}
			
			$image = ( '' !== $font_icon ) ?
					sprintf( $hexagon_start . '<span class="et-pb-icon%7$s%6$s%2$s%3$s%4$s" style="%5$s">%1$s</span>' . $hexagon_end,
		            	esc_attr( et_pb_process_font_icon( $font_icon ) ),
		            	esc_attr( " et_pb_animation_{$animation}" ),
		            	$icon_class,
		            	( 
		            		'on' === $style_icon && 'on' === $use_shape_border && 'use_hexagon' !== $icon_shape ?
		            		' et-pb-icon-shape-border' :
		            		''
		            	),
		            	$icon_style,
		            	( 
		            		'on' === $style_icon && 'use_hexagon' !== $icon_shape ?
		            		' et-waypoint' :
		            		''
		            	),
		            	( 
		            		'off' === $style_icon ?
		            		' et-waypoint' :
		            		''
		            	)
		            ) :
			        '';

			if ( '' !== $font_icon ) {
				if ( class_exists( 'ET_Builder_Module_Helper_Style_Processor' ) && method_exists( 'ET_Builder_Module_Helper_Style_Processor', 'process_extended_icon' ) ) {
	                $this->generate_styles(
	                    array(
	                        'utility_arg'    => 'icon_font_family',
	                        'render_slug'    => $render_slug,
	                        'base_attr_name' => 'font_icon',
	                        'important'      => true,
	                        'selector'       => '%%order_class%% .et-pb-icon',
	                        'processor'      => array(
	                            'ET_Builder_Module_Helper_Style_Processor',
	                            'process_extended_icon',
	                        ),
	                    )
	                );
	            }
			}
		}
		
		if ( 'image_card' !== $blurb_layout ) {
			$image = $image ? 
					 sprintf( '<div class="et_pb_main_blurb_image">%1$s</div>',
					 	'' !== $url ?
					 	sprintf( '<a href="%1$s"%3$s>%2$s</a>', 
				 			esc_url( $url ),
				 			$image,
				 			( 
				 				'on' === $url_new_window ?
				 				' target="_blank"' :
				 				''
				 			) 
				 		) :
				 		$image
					 ) :
					 '';
		}
		
		$read_more_hover_background_color = $this->props['read_more_hover_background_color'];
		$read_more_hover_border_color     = $this->props['read_more_hover_border_color'];
		$read_more_hover_text_color       = $this->props['read_more_hover_text_color'];
		
		if ( '' !== $read_more_hover_background_color ) {
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => 'body #page-container %%order_class%%.et_pb_blurb_extended .et_pb_more_button.et_pb_button:hover',
				'declaration'   => sprintf( 'background: %1$s;', esc_html( $read_more_hover_background_color ) )
			) );
		}

		if ( '' !== $read_more_hover_border_color ) {
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => 'body #page-container %%order_class%%.et_pb_blurb_extended .et_pb_more_button.et_pb_button:hover',
				'declaration'   => sprintf( 'border-color: %1$s;', esc_html( $read_more_hover_border_color ) )
			));
		}

		if ( '' !== $read_more_hover_text_color ) {
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => 'body #page-container %%order_class%%.et_pb_blurb_extended .et_pb_more_button.et_pb_button:hover',
				'declaration'   => sprintf( 'color: %1$s !important;', esc_html( $read_more_hover_text_color ) )
			));
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => 'body #page-container %%order_class%%.et_pb_blurb_extended .et_pb_more_button.et_pb_button:hover:after',
				'declaration'   => sprintf( 'color: %1$s !important;', esc_html( $read_more_hover_text_color ) )
			));
		}

		if ( 'on' === $use_icon ) {
			if ( '' !== $icon_hover_color ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'      => '%%order_class%%:hover .et-pb-icon',
					'declaration'   => sprintf( 'color: %1$s !important;', esc_html( $icon_hover_color ) ),
				));
			}
			
			if ( 'on' === $style_icon ) {
				if ( '' !== $shape_hover_color ) {
					if ( 'use_hexagon' !== $icon_shape ) {
						ET_Builder_Element::set_style( $render_slug, array(
							'selector'      => '%%order_class%%:hover .et-pb-icon',
							'declaration'   => sprintf( 'background-color: %1$s !important;', esc_html( $shape_hover_color ) ),
						));
					}
					
					if ( 'use_hexagon' === $icon_shape ) {
						ET_Builder_Element::set_style( $render_slug, array(
							'selector'      => '%%order_class%%:hover .hexagon',
							'declaration'   => sprintf( 'background-color: %1$s !important;', esc_html( $shape_hover_color ) ),
						));
					}
				}
				
				if ( 'on' === $use_shape_border ) {
					if ( '' !== $shape_border_hover_color ) {
						if ( 'use_hexagon' !== $icon_shape ) {
							ET_Builder_Element::set_style( $render_slug, array(
								'selector'      => '%%order_class%%:hover .et-pb-icon',
								'declaration'   => sprintf( 'border-color: %1$s !important;', esc_html( $shape_border_hover_color ) ),
							));
						}
						if ( 'use_hexagon' === $icon_shape ) {
							ET_Builder_Element::set_style( $render_slug, array(
								'selector'      => '%%order_class%%:hover .hexagon',
								'declaration'   => sprintf( 'border-color: %1$s !important;', esc_html( $shape_border_hover_color ) ),
							));
						}
					}
				}
			}
		}

		if ( '' !== $title_hover_color ) {
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%%:hover .et_pb_blurb_container .et_pb_module_header',
				'declaration'   => sprintf( 'color: %1$s !important;', esc_html( $title_hover_color ) ),
			));
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%%:hover .et_pb_blurb_container .et_pb_module_header a',
				'declaration'   => sprintf( 'color: %1$s !important;', esc_html( $title_hover_color ) ),
			));
		}

		if ( '' !== $text_hover_color ) {
			ET_Builder_Element::set_style( $render_slug, array(
				'selector'      => '%%order_class%%:hover .et_pb_blurb_container .et_pb_blurb_description',
				'declaration'   => sprintf( 'color: %1$s !important;', esc_html( $text_hover_color ) ),
			));
		}

		if ( 'flipbox' !== $blurb_layout ) {
			if ( '' !== $content_background_color ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'      => '%%order_class%%.et_pb_blurb_extended .et_pb_blurb_content',
					'declaration'   => sprintf( 'background: %1$s !important;', esc_html( $content_background_color ) ),
				));
			}

			if ( '' !== $blurb_hover_color ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'      => '%%order_class%%.et_pb_blurb_extended:hover .et_pb_blurb_content',
					'declaration'   => sprintf( 'background: %1$s !important;', esc_html( $blurb_hover_color ) ),
				));
			}
		}
						
		if ( file_exists( get_stylesheet_directory() . '/divi-blurb-extended/layouts/' . $blurb_layout . '.php' ) ) {
            include get_stylesheet_directory() . '/divi-blurb-extended/layouts/' . $blurb_layout . '.php';
        } elseif ( file_exists( plugin_dir_path( __FILE__ ) . 'layouts/' . $blurb_layout . '.php' ) ) {
            include ( plugin_dir_path( __FILE__ ) . 'layouts/' . $blurb_layout . '.php' );
        }
        
		$this->add_classname( array(
			$this->get_text_orientation_classname()
		) );

		$class = '';
		$class .= 'et_pb_blurb_position_'.esc_attr( $icon_placement );
		$class .= ' ' . esc_attr( $blurb_layout );
		$class .= ( 'on' === $style_icon ) ? esc_html( ' ' . $icon_shape ) : '';
		$class .= ' '.trim( $image_class );
		$class .= ' et_pb_bg_layout_' . esc_attr( $background_layout );

		$output = sprintf( '<div class="%2$s" data-blurb-position="%3$s"> 
			        			%1$s
			        		</div>
		             <!-- .et_pb_blurb -->',
			        $layout,
			        $class,
			        esc_attr( $icon_placement )
			      );
		
		return $output;
		
	}
}

new El_Blurb_Module;