<?php
/**
 * @author      Elicus Technologies <hello@elicus.com>
 * @link        https://www.elicus.com/
 * @copyright   2022 Elicus Technologies Private Limited
 * @version     2.2.6
 */

class El_AdvancedFlipBox extends ET_Builder_Module {

	protected $module_credits = array(
		'module_uri' => 'https://diviextended.com/product/divi-blurb-extended/',
		'author'     => 'Elicus',
		'author_uri' => 'https://elicus.com/',
	);

	public function init() {
		$this->name             = esc_html__( 'Advanced Flip Box', 'divi-blurb-extended' );
		$this->slug       		= 'el_advanced_flipbox';
		$this->main_css_element = '%%order_class%%.el_advanced_flipbox';
		$this->vb_support 		= 'on';
		add_filter( 'et_late_global_assets_list', array( $this, 'el_blurb_extended_late_assets' ), 10, 3 );
	}

	public function el_blurb_extended_late_assets( $assets_list, $assets_args, $dynamic_assets ) {
		if ( function_exists( 'et_get_dynamic_assets_path' ) && function_exists( 'et_is_cpt' ) ) {
			$cpt_suffix = et_is_cpt() ? '_cpt' : '';
            $assets_list['et_icons_all'] = array(
                'css' => $assets_args['assets_prefix'] . "/css/icons_all.css",
            );
            $assets_list['et_overlay'] = array(
                'css' => $assets_args['assets_prefix'] . "/css/overlay{$cpt_suffix}.css",
            );
            $assets_list['et_icons_fa'] = array(
                'css' => $assets_args['assets_prefix'] . "/css/icons_fa_all.css",
            );
            $assets_list['animations'] = array(
                'css' => $assets_args['assets_prefix'] . "/css/animations{$cpt_suffix}.css",
            );
            $assets_list['et_icons_social'] = array(
                'css' => $assets_args['assets_prefix'] . "/css/icons_base_social.css",
            );
			$assets_list['et_legacy_animations'] = array(
				'css' => $assets_args['assets_prefix'] . "/css/legacy_animations{$cpt_suffix}.css",
			);
		}
		return $assets_list;
	}

	public function get_settings_modal_toggles() {
        return array(
            'general' => array(
                'toggles' => array(
                	'flipbox_layout' => array(
                        'title' => esc_html__( 'Flip Box Layout', 'divi-blurb-extended' ),
                        'priority'  => 1,
                    ),
                    'flipbox_content' => array(
                        'title' => esc_html__( 'Flip Box Content', 'divi-blurb-extended' ),
                        'priority' 	=> 2,
                        'sub_toggles'	=> array(
                        						'front_data'		=> array(
												'name'		=> 'Front Content',
											),
												'back_data'		=> array(
												'name'		=> 'Back Content',
											),
										),
                        'tabbed_subtoggles'	=> true,
                    ),
                    'flipbox_elements' => array(
                        'title' => esc_html__( 'Flip Box Elements', 'divi-blurb-extended' ),
                        'priority' 	=> 3,
                        'sub_toggles'	=> array(
                        						'front_elements'		=> array(
												'name'		=> 'Front Elements',
											),
												'back_elements'		=> array(
												'name'		=> 'Back Elements',
											),
										),
                        'tabbed_subtoggles'	=> true,
                    ),
                    'link_options' => array(
						'priority' 	=> 4,
                    ),
                    'flipbox_background' => array(
                        'title' => esc_html__( 'Flip Box Background', 'divi-blurb-extended' ),
                        'priority' 	=> 5,
                        'sub_toggles'	=> array(
                        						'front'		=> array(
													'name'		=> 'Front',
												),
												'back'		=> array(
													'name'		=> 'Back',
												),
											),
                        'tabbed_subtoggles'	=> true,
                    ),
                    'hide_background' => true,
                ),
            ),
            'advanced' => array(
                'toggles' => array(
                    'front_icon_settings' => array(
                        'title' => esc_html__( 'Front Image/Icon Style', 'divi-blurb-extended' ),
                        'priority'  => 1,
                    ),
                    'back_icon_settings' => array(
                        'title' => esc_html__( 'Back Image/Icon Style', 'divi-blurb-extended' ),
                        'priority'  => 2,
                    ),
                    'front_text_settings' => array(
                        'title'     => esc_html__( 'Front Text Style', 'divi-blurb-extended' ),
                        'priority'  => 3,
                        'sub_toggles'	=> array(
                        						'front_general'		=> array(
													'name'		=> 'General',
												),
												'front_title'		=> array(
													'name'		=> 'Title',
												),
												'front_body'		=> array(
													'name'		=> 'Content',
												),
											),
                        'tabbed_subtoggles'	=> true,
                    ),
                    'back_text_settings' => array(
                        'title'     => esc_html__( 'Back Text Style', 'divi-blurb-extended' ),
                        'priority'  => 4,
                        'sub_toggles'	=> array(
                        	                    'back_general'		=> array(
													'name'		=> 'General',
												),
												'back_title'		=> array(
													'name'		=> 'Title',
												),
												'back_body'		=> array(
													'name'		=> 'Content',
												),
											),
                        'tabbed_subtoggles'	=> true,
                    ),
                    'button' => array(
                        'title'     => esc_html__( 'Back Button Style', 'divi-blurb-extended' ),
                        'priority'  => 5,
                    ),
                    'front_style_settings' => array(
                        'title'     => esc_html__( 'Front Box Style', 'divi-blurb-extended' ),
                        'priority'  => 6,
                    ),
                    'back_style_settings' => array(
                        'title'     => esc_html__( 'Back Box Style', 'divi-blurb-extended' ),
                        'priority'  => 7,
                    ),
                    'width' => array(
    					'title'    => esc_html__( 'Sizing', 'divi-blurb-extended' ),
    					'priority' => 8,
    				),
                ),
            ),
        );
    }
    
    public function get_advanced_fields_config() {
        return array(
            'fonts' => array(
            	'front_general_settings' => array(
                    'label'     => esc_html__( 'General', 'divi-blurb-extended' ),
					'css'       => array(
						'main'  => "%%order_class%% .flipbox_front .et_pb_flipbox_heading .et_pb_module_header, %%order_class%% .flipbox_front .et_pb_flipbox_heading .et_pb_module_header a, %%order_class%% .flipbox_front .et_pb_flipbox_description, %%order_class%% .flipbox_front .et_pb_flipbox_description p, %%order_class%% .flipbox_front .et_pb_main_flipbox_image.use_icon",
					),
					'hide_font' 			=> true,
					'hide_font_size' 		=> true,
					'hide_font_weight' 		=> true,
					'hide_font_style' 		=> true,
					'hide_letter_spacing' 	=> true,
					'hide_line_height' 		=> true,
					'hide_text_color' 		=> true,
					'hide_text_shadow' 		=> true,
					'important' 			=> 'all',
					'tab_slug'				=> 'advanced',
					'toggle_slug'			=> 'front_text_settings',
					'sub_toggle'			=> 'front_general',
				),
                'front_header' => array(
                    'label'     => esc_html__( 'Title', 'divi-blurb-extended' ),
                    'font_size' => array(
                        'default'           => '18px',
                        'range_settings'    => array(
                            'min'   => '1',
                            'max'   => '100',
                            'step'  => '1',
                        ),
                        'validate_unit'     => true,
                    ),
                    'line_height' => array(
                        'default'           => '1.5em',
                        'range_settings'    => array(
                            'min'   => '0.1',
                            'max'   => '10',
                            'step'  => '0.1',
                        ),
                    ),
                    'letter_spacing' => array(
                        'default'           => '0px',
                        'range_settings'    => array(
                            'min'   => '0',
                            'max'   => '10',
                            'step'  => '1',
                        ),
                        'validate_unit'     => true,
                    ),
					'css'       => array(
						'main'  => "%%order_class%% .flipbox_front .et_pb_module_header, %%order_class%% .flipbox_front .et_pb_module_header a",
					),
					'header_level'  => array(
						'default'   => 'h4',
					),
					'hide_text_align'		=> true,
					'important' 			=> 'all',
					'tab_slug'				=> 'advanced',
					'toggle_slug'			=> 'front_text_settings',
					'sub_toggle'			=> 'front_title',
				),
				'front_body'  => array(
				    'label' => esc_html__( 'Body', 'divi-blurb-extended' ),
				    'font_size' => array(
                        'default'           => '14px',
                        'range_settings'    => array(
                            'min'   => '1',
                            'max'   => '100',
                            'step'  => '1',
                        ),
                        'validate_unit'     => true,
                    ),
                    'line_height' => array(
                        'default'           => '1em',
                        'range_settings'    => array(
                            'min'   => '0',
                            'max'   => '5',
                            'step'  => '0.1',
                        ),
                    ),
                    'letter_spacing' => array(
                        'default'           => '0px',
                        'range_settings'    => array(
                            'min'   => '0',
                            'max'   => '10',
                            'step'  => '1',
                        ),
                        'validate_unit'     => true,
                    ),
					'css'   => array(
						'main' => "%%order_class%% .flipbox_front .et_pb_flipbox_description, %%order_class%% .flipbox_front .et_pb_flipbox_description p",
					),
					'hide_text_align' 		=> true,
					'important' 			=> 'all',
					'tab_slug'				=> 'advanced',
					'toggle_slug'			=> 'front_text_settings',
					'sub_toggle'			=> 'front_body',
				),
				'back_general_settings' => array(
                    'label'     => esc_html__( 'General', 'divi-blurb-extended' ),
					'css'       => array(
						'main'  => "%%order_class%% .flipbox_back .et_pb_flipbox_heading_back .et_pb_module_header, %%order_class%% .flipbox_back .et_pb_flipbox_heading_back .et_pb_module_header a, %%order_class%% .flipbox_back .et_pb_flipbox_description, %%order_class%% .flipbox_back .et_pb_flipbox_description p, %%order_class%% .flipbox_back .et_pb_main_flipbox_image.use_icon",
					),
					'hide_font' 			=> true,
					'hide_font_size' 		=> true,
					'hide_font_weight' 		=> true,
					'hide_font_style' 		=> true,
					'hide_letter_spacing' 	=> true,
					'hide_line_height' 		=> true,
					'hide_text_color' 		=> true,
					'hide_text_shadow' 		=> true,
					'important' 			=> 'all',
					'tab_slug'				=> 'advanced',
					'toggle_slug'			=> 'back_text_settings',
					'sub_toggle'			=> 'back_general',
				),
				'back_header' => array(
                    'label'     => esc_html__( 'Title', 'divi-blurb-extended' ),
                    'font_size' => array(
                        'default'           => '18px',
                        'range_settings'    => array(
                            'min'   => '1',
                            'max'   => '100',
                            'step'  => '1',
                        ),
                        'validate_unit'     => true,
                    ),
                    'line_height' => array(
                        'default'           => '1.5em',
                        'range_settings'    => array(
                            'min'   => '0.1',
                            'max'   => '10',
                            'step'  => '0.1',
                        ),
                    ),
                    'letter_spacing' => array(
                        'default'           => '0px',
                        'range_settings'    => array(
                            'min'   => '0',
                            'max'   => '10',
                            'step'  => '1',
                        ),
                        'validate_unit'     => true,
                    ),
					'css'       => array(
						'main'  => "%%order_class%% .flipbox_back .et_pb_module_header, %%order_class%% .flipbox_back .et_pb_module_header a",
					),
					'header_level'  => array(
						'default'   => 'h4',
					),
					'hide_text_align' 		=> true,
					'important' 			=> 'all',
					'tab_slug'				=> 'advanced',
					'toggle_slug'			=> 'back_text_settings',
					'sub_toggle'			=> 'back_title',
				),
				'back_body'  => array(
				    'label' => esc_html__( 'Body', 'divi-blurb-extended' ),
				    'font_size' => array(
                        'default'           => '14px',
                        'range_settings'    => array(
                            'min'   => '1',
                            'max'   => '100',
                            'step'  => '1',
                        ),
                        'validate_unit'     => true,
                    ),
                    'line_height' => array(
                        'default'           => '1em',
                        'range_settings'    => array(
                            'min'   => '0',
                            'max'   => '5',
                            'step'  => '0.1',
                        ),
                    ),
                    'letter_spacing' => array(
                        'default'           => '0px',
                        'range_settings'    => array(
                            'min'   => '0',
                            'max'   => '10',
                            'step'  => '1',
                        ),
                        'validate_unit'     => true,
                    ),
					'css'   => array(
						'main' => "%%order_class%% .flipbox_back .et_pb_flipbox_description, %%order_class%% .flipbox_back .et_pb_flipbox_description p",
					),
					'hide_text_align' 		=> true,
					'important' 			=> 'all',
					'tab_slug'				=> 'advanced',
					'toggle_slug'			=> 'back_text_settings',
					'sub_toggle'			=> 'back_body',
				),
			),
			'background' => array(
			    'css' => array(
				    'main' => "%%order_class%%",
			    )
			),
			'button' => array(
			    'back_button' => array(
				    'label'             => esc_html__( 'Button', 'divi-blurb-extended' ),
				    'css'               => array(
				        'main'         => "%%order_class%% .flipbox_back .et_pb_button",
				        'background'         => "%%order_class%% .flipbox_back .et_pb_button",
				        'alignment'    => "%%order_class%% .flipbox_back .et_pb_button_wrapper",
				        'important'    => 'all',
				    ),
				    'margin_padding' => array(
						'css' => array(
						    'main'      => "%%order_class%% .flipbox_back .et_pb_button",
						    'hover'     => "%%order_class%% .flipbox_back .et_pb_button:hover",
						    'important'    => 'all',
						),
					),
				    'no_rel_attr'       => true,
				    'box_shadow'        => false,
				    'use_alignment' 	=> true,
				  	'depends_on'        => array( 'back_button_display' ),
		            'depends_show_if'   => 'on',
		           	'tab_slug'			=> 'advanced',
					'toggle_slug'		=> 'button',
			    ),
			),
			'custom_margin_padding' => array(
			    'css' => array(
				    'padding'   => "%%order_class%% .flipbox_front, %%order_class%% .flipbox_back",
				    'margin'    => "%%order_class%%",
				    'important' => 'all',
			    ),
			),
			'max_width' => array(
				'css' => array(
					'main'              => "%%order_class%%",
					'module_alignment'  => "%%order_class%%",
				),
			),
			'borders'		=> array(
				'default'	=> false,
				'front_image'	=> array(
					'css'				=> array(
						'main'			=> array(
							'border_radii'	=> "%%order_class%% .flipbox_front .et_pb_main_flipbox_image img",
							'border_styles'	=> "%%order_class%% .flipbox_front .et_pb_main_flipbox_image img",
						),
					),
					'label_prefix'    	=> esc_html__( 'Front Image', 'divi-blurb-extended' ),
					'depends_on'        => array( 'front_use_icon' ),
		            'depends_show_if'   => 'off',
					'tab_slug'        	=> 'advanced',
					'toggle_slug'     	=> 'front_icon_settings',
				),
				'back_image'		=> array(
					'css'				=> array(
						'main'			=> array(
							'border_radii'	=> "%%order_class%% .flipbox_back .et_pb_main_flipbox_image img",
							'border_styles'	=> "%%order_class%% .flipbox_back .et_pb_main_flipbox_image img",
						),
					),
					'label_prefix'    	=> esc_html__( 'Back Image', 'divi-blurb-extended' ),
					'depends_on'        => array( 'back_use_icon' ),
		            'depends_show_if'   => 'off',
					'tab_slug'        	=> 'advanced',
					'toggle_slug'     	=> 'back_icon_settings',
				),
				'front_box'		=> array(
					'css'				=> array(
						'main'			=> array(
						    'border_radii'	=> "%%order_class%% .flipbox_front",
							'border_styles'	=> "%%order_class%%.et_pb_with_border .flipbox_front",
						),
					),
					'label_prefix'    	=> esc_html__( 'Front', 'divi-blurb-extended' ),
					'tab_slug'        	=> 'advanced',
					'toggle_slug'     	=> 'front_style_settings',
				),
				'back_box'		=> array(
					'css'				=> array(
						'main'			=> array(
						    'border_radii'	=> "%%order_class%% .flipbox_back",
							'border_styles'	=> "%%order_class%%.et_pb_with_border .flipbox_back",
						),
					),
					'label_prefix'    	=> esc_html__( 'Back', 'divi-blurb-extended' ),
					'tab_slug'        	=> 'advanced',
					'toggle_slug'     	=> 'back_style_settings',
				),
			),
			'box_shadow'  	=> array(
			    'default'     => false,
			    'front_box'   => array(
			        'css' => array(
						'main' => "%%order_class%% .et_pb_flipbox_advanced_wrapper:not(.layout3) .flipbox_front, %%order_class%% .layout3:not(:hover)",
					),
					'tab_slug'     => 'advanced',
				    'toggle_slug'  => 'front_style_settings',
			     ),
			     'back_box'   => array(
			        'css' => array(
						'main' => "%%order_class%% .et_pb_flipbox_advanced_wrapper:not(.layout3) .flipbox_back, %%order_class%% .layout3:hover",
					),
					'tab_slug'     => 'advanced',
				    'toggle_slug'  => 'back_style_settings',
			     ),
			),
			'height'        => false,
			'filters'   	=> false,
			'text'  		=> false,
        );
    }
    
    public function get_custom_css_fields_config() {
        return array(
        	/*Front CSS Fields*/
            'front_container_css' => array(
				'label'     => esc_html__( 'Front Container', 'divi-blurb-extended' ),
				'selector'  => '.flipbox_front'
			),
			'front_title_css' => array(
				'label'     => esc_html__( 'Front Title', 'divi-blurb-extended' ),
				'selector'  => ' .flipbox_front .et_pb_module_header'
			),
			'front_content_css' => array(
				'label'     => esc_html__( 'Front Content', 'divi-blurb-extended' ),
				'selector'  => '.flipbox_front .et_pb_flipbox_description'
			),
			'front_icon_css' => array(
				'label'     => esc_html__( 'Front Image/Icon', 'divi-blurb-extended' ),
				'selector'  => '.flipbox_front .et_pb_main_flipbox_image'
			),
			/*Back CSS Fields*/
			'back_container_css' => array(
				'label'     => esc_html__( 'Back Container', 'divi-blurb-extended' ),
				'selector'  => '.flipbox_back'
			),
			'back_title_css' => array(
				'label'     => esc_html__( 'Back Title', 'divi-blurb-extended' ),
				'selector'  => '.flipbox_back .et_pb_module_header'
			),
			'back_content_css' => array(
				'label'     => esc_html__( 'Back Content', 'divi-blurb-extended' ),
				'selector'  => '.flipbox_back .et_pb_flipbox_description'
			),
			'back_icon_css' => array(
				'label'     => esc_html__( 'Back Image/Icon', 'divi-blurb-extended' ),
				'selector'  => '.flipbox_back .et_pb_main_flipbox_image'
			),
			'back_button_css' => array(
				'label'     => esc_html__( 'Back Button', 'divi-blurb-extended' ),
				'selector'  => '.flipbox_back .et_pb_flipbox_button_back .et_pb_button'
			),
        );
    }

	public function get_fields() {
	    $et_accent_color = et_builder_accent_color();
		
		$flip_box_fields = array(
			'flipbox_layout' => array(
				'label'                 => esc_html__( 'Select Layout', 'divi-blurb-extended' ),
				'type'                  => 'select',
				'option_category'       => 'layout',
				'options'               => array(
					'layout1'       => esc_html__( 'Flip', 'divi-blurb-extended' ),
					'layout2'       => esc_html__( 'Zoom', 'divi-blurb-extended' ),
					'layout3'       => esc_html__( 'Slide', 'divi-blurb-extended' ),
					'layout4'       => esc_html__( '3D Cube', 'divi-blurb-extended' ),
					'layout5'       => esc_html__( 'Grow', 'divi-blurb-extended' ),
					'layout6'       => esc_html__( 'Cover', 'divi-blurb-extended' ),
				),
				'default'               => 'layout1',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_layout',
				'description'           => esc_html__( 'Here you can choose the layout for Flip Box.', 'divi-blurb-extended' ),
			),
			'layout1_flip_style' => array(
				'label'                 => esc_html__( 'Flip Direction', 'divi-blurb-extended' ),
				'type'                  => 'select',
				'option_category'       => 'layout',
				'options'               => array(
					'top'       => esc_html__( 'Top', 'divi-blurb-extended' ),
					'bottom'       => esc_html__( 'Bottom', 'divi-blurb-extended' ),
					'left'       => esc_html__( 'Left', 'divi-blurb-extended' ),
					'right'       => esc_html__( 'Right', 'divi-blurb-extended' ),
					'diagonalLeft'       => esc_html__( 'Diagonal Left', 'divi-blurb-extended' ),
					'diagonalRight'       => esc_html__( 'Diagonal Right', 'divi-blurb-extended' ),
					'diagonalLeftInverted'       => esc_html__( 'Diagonal Left Inverted', 'divi-blurb-extended' ),
					'diagonalRightInverted'       => esc_html__( 'Diagonal Right Inverted', 'divi-blurb-extended' ),
				),
				'show_if'               => array(
				    'flipbox_layout'  => 'layout1',
				),
				'default'               => 'top',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_layout',
				'description'           => esc_html__( 'Here you can choose the flip direction.', 'divi-blurb-extended' ),
			),
			'layout1_3d_depth' => array(
				'label'                 => esc_html__( '3D Depth Effect', 'divi-blurb-extended' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'layout',
				'options'               => array(
					'off'   => esc_html__( 'No', 'divi-blurb-extended' ),
					'on'    => esc_html__( 'Yes', 'divi-blurb-extended' ),
				),
				'show_if'               => array(
				    'flipbox_layout'  => 'layout1',
				),
				'default'               => 'on',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_layout',
				'description'           => esc_html__( 'This option enable 3D depth effect on flip.', 'divi-blurb-extended' ),
			),
			'layout1_shake_effect' => array(
				'label'                 => esc_html__( 'Shake on Flip', 'divi-blurb-extended' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'layout',
				'options'               => array(
					'off'   => esc_html__( 'No', 'divi-blurb-extended' ),
					'on'    => esc_html__( 'Yes', 'divi-blurb-extended' ),
				),
				'show_if'               => array(
				    'flipbox_layout'  => 'layout1',
				),
				'default'               => 'off',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_layout',
				'description'           => esc_html__( 'This option will enable shake effect on flip.', 'divi-blurb-extended' ),
			),
			'layout2_flip_style' => array(
				'label'                 => esc_html__( 'Flip Style', 'divi-blurb-extended' ),
				'type'                  => 'select',
				'option_category'       => 'layout',
				'options'               => array(
					'fade'       => esc_html__( 'Fade', 'divi-blurb-extended' ),
					'zoomin'       => esc_html__( 'Zoom In', 'divi-blurb-extended' ),
					'zoomout'       => esc_html__( 'Zoom Out', 'divi-blurb-extended' ),
				),
				'show_if'               => array(
				    'flipbox_layout'  => 'layout2',
				),
				'default'               => 'fade',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_layout',
				'description'           => esc_html__( 'Here you can choose the entrance animation of the back part of Flip Box.', 'divi-blurb-extended' ),
			),
			'layout3_flip_style' => array(
				'label'                 => esc_html__( 'Entrance Direction', 'divi-blurb-extended' ),
				'type'                  => 'select',
				'option_category'       => 'layout',
				'options'               => array(
					'top'       => esc_html__( 'Top', 'divi-blurb-extended' ),
					'bottom'       => esc_html__( 'Bottom', 'divi-blurb-extended' ),
					'left'       => esc_html__( 'Left', 'divi-blurb-extended' ),
					'right'       => esc_html__( 'Right', 'divi-blurb-extended' ),
				),
				'show_if'               => array(
				    'flipbox_layout'  => 'layout3',
				),
				'default'               => 'top',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_layout',
				'description'           => esc_html__( 'Here you can choose the entrance direction of the back part.', 'divi-blurb-extended' ),
			),
			'layout4_flip_style' => array(
				'label'                 => esc_html__( 'Entrance Direction', 'divi-blurb-extended' ),
				'type'                  => 'select',
				'option_category'       => 'layout',
				'options'               => array(
					'top'       => esc_html__( 'Top', 'divi-blurb-extended' ),
					'bottom'       => esc_html__( 'Bottom', 'divi-blurb-extended' ),
					'left'       => esc_html__( 'Left', 'divi-blurb-extended' ),
					'right'       => esc_html__( 'Right', 'divi-blurb-extended' ),
				),
				'show_if'               => array(
				    'flipbox_layout'  => 'layout4',
				),
				'default'               => 'top',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_layout',
				'description'           => esc_html__( 'Here you can choose the entrance direction of the back part.', 'divi-blurb-extended' ),
			),
			'layout5_flip_style' => array(
				'label'                 => esc_html__( 'Entrance Direction', 'divi-blurb-extended' ),
				'type'                  => 'select',
				'option_category'       => 'layout',
				'options'               => array(
					'top'       => esc_html__( 'Top', 'divi-blurb-extended' ),
					'bottom'       => esc_html__( 'Bottom', 'divi-blurb-extended' ),
					'left'       => esc_html__( 'Left', 'divi-blurb-extended' ),
					'right'       => esc_html__( 'Right', 'divi-blurb-extended' ),
				),
				'show_if'               => array(
				    'flipbox_layout'  => 'layout5',
				),
				'default'               => 'top',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_layout',
				'description'           => esc_html__( 'Here you can choose the entrance direction of the back part.', 'divi-blurb-extended' ),
			),
			'layout6_flip_style' => array(
				'label'                 => esc_html__( 'Entrance Direction', 'divi-blurb-extended' ),
				'type'                  => 'select',
				'option_category'       => 'layout',
				'options'               => array(
					'top'       => esc_html__( 'Top', 'divi-blurb-extended' ),
					'bottom'       => esc_html__( 'Bottom', 'divi-blurb-extended' ),
					'left'       => esc_html__( 'Left', 'divi-blurb-extended' ),
					'right'       => esc_html__( 'Right', 'divi-blurb-extended' ),
				),
				'show_if'               => array(
				    'flipbox_layout'  => 'layout6',
				),
				'default'               => 'top',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_layout',
				'description'           => esc_html__( 'Here you can choose the entrance direction of the back part.', 'divi-blurb-extended' ),
			),
			'layout7_flip_style' => array(
				'label'                 => esc_html__( 'Entrance Direction', 'divi-blurb-extended' ),
				'type'                  => 'select',
				'option_category'       => 'layout',
				'options'               => array(
					'top'       => esc_html__( 'Top', 'divi-blurb-extended' ),
					'bottom'       => esc_html__( 'Bottom', 'divi-blurb-extended' ),
					'left'       => esc_html__( 'Left', 'divi-blurb-extended' ),
					'right'       => esc_html__( 'Right', 'divi-blurb-extended' ),
				),
				'show_if'               => array(
				    'flipbox_layout'  => 'layout7',
				),
				'default'               => 'top',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_layout',
				'description'           => esc_html__( 'Here you can choose the entrance direction of the back part.', 'divi-blurb-extended' ),
			),
			'flip_speed' => array(
				'label'                 => esc_html__( 'Flip Speed(in ms)', 'divi-blurb-extended' ),
				'type'                  => 'range',
				'option_category'       => 'layout',
				'validate_unit'         => true,
				'range_settings'        => array(
					'min'   => '100',
					'max'   => '10000',
					'step'  => '100',
				),
				'default'               => '700ms',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_layout',
				'description'           => esc_html__( 'Define the Flip speed(in ms).', 'divi-blurb-extended' ),
			),
			'front_title' => array(
				'label'                 => esc_html__( 'Title', 'divi-blurb-extended' ),
				'type'                  => 'text',
				'option_category'       => 'basic_option',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_content',
				'sub_toggle'			=> 'front_data',
				'description'           => esc_html__( 'The front title of your module.', 'divi-blurb-extended' ),
			),
			'front_content' => array(
				'label'                 => esc_html__( 'Content', 'divi-blurb-extended' ),
				'type'                  => 'textarea',
				'option_category'       => 'basic_option',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_content',
				'sub_toggle'			=> 'front_data',
				'description'           => esc_html__( 'Input the front text content for your module here.', 'divi-blurb-extended' ),
			),
			'back_title' => array(
				'label'                 => esc_html__( 'Title', 'divi-blurb-extended' ),
				'type'                  => 'text',
				'option_category'       => 'basic_option',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_content',
				'sub_toggle'			=> 'back_data',
				'description'           => esc_html__( 'The back title of your module.', 'divi-blurb-extended' ),
			),
			'content' => array(
				'label'                 => esc_html__( 'Content', 'divi-blurb-extended' ),
				'type'                  => 'tiny_mce',
				'option_category'       => 'basic_option',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_content',
				'sub_toggle'			=> 'back_data',
				'description'           => esc_html__( 'Input the back text content for your module here.', 'divi-blurb-extended' ),
			),
			'front_use_icon' => array(
				'label'                 => esc_html__( 'Use Icon on Front', 'divi-blurb-extended' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'basic_option',
				'options'               => array(
					'off'   => esc_html__( 'No', 'divi-blurb-extended' ),
					'on'    => esc_html__( 'Yes', 'divi-blurb-extended' ),
				),
				'default'               => 'off',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_elements',
				'sub_toggle'			=> 'front_elements',
				'description'           => esc_html__( 'Here you can choose whether icon set below should be used.', 'divi-blurb-extended' ),
			),
			'front_font_icon' => array(
				'label'                 => esc_html__( 'Front Icon', 'divi-blurb-extended' ),
				'type'                  => 'select_icon',
				'option_category'       => 'basic_option',
				'class'                 => array(
					'et-pb-font-icon'
				),
				'show_if'               => array(
				    'front_use_icon'  => 'on',
				),
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_elements',
				'sub_toggle'			=> 'front_elements',
				'description'           => esc_html__( 'Choose an icon to display on frontside of your flip box.', 'divi-blurb-extended' ),
			),
			'front_image' => array(
				'label'                 => esc_html__( 'Front Image', 'divi-blurb-extended' ),
				'type'                  => 'upload',
				'option_category'       => 'basic_option',
				'upload_button_text'    => esc_attr__( 'Upload an image', 'divi-blurb-extended' ),
				'choose_text'           => esc_attr__( 'Choose an Image', 'divi-blurb-extended' ),
				'update_text'           => esc_attr__( 'Set As Image', 'divi-blurb-extended' ),
				'show_if'               => array(
				    'front_use_icon'  => 'off',
				),
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_elements',
				'sub_toggle'			=> 'front_elements',
				'description'           => esc_html__( 'Upload an image to display on frontside of your flip box.', 'divi-blurb-extended' ),
			),
			'front_image_alt' => array(
				'label'                 => esc_html__( 'Front Image Alt Text', 'divi-blurb-extended' ),
				'type'                  => 'text',
				'option_category'       => 'basic_option',
				'show_if'               => array(
				    'front_use_icon'  => 'off',
				),
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_elements',
				'sub_toggle'			=> 'front_elements',
				'description'           => esc_html__( 'Define the HTML ALT text for your image here.', 'divi-blurb-extended' ),
			),
			/*General - Elements(Back)*/
			'back_use_icon' => array(
				'label'                 => esc_html__( 'Use Icon on Back', 'divi-blurb-extended' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'basic_option',
				'options'               => array(
					'off'   => esc_html__( 'No', 'divi-blurb-extended' ),
					'on'    => esc_html__( 'Yes', 'divi-blurb-extended' ),
				),
				'default'               => 'off',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_elements',
				'sub_toggle'			=> 'back_elements',
				'description'           => esc_html__( 'Here you can choose whether icon set below should be used.', 'divi-blurb-extended' ),
			),
			'back_font_icon' => array(
				'label'                 => esc_html__( 'Back Icon', 'divi-blurb-extended' ),
				'type'                  => 'select_icon',
				'option_category'       => 'basic_option',
				'class'                 => array(
					'et-pb-font-icon'
				),
				'show_if'               => array(
				    'back_use_icon'  => 'on',
				),
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_elements',
				'sub_toggle'			=> 'back_elements',
				'description'           => esc_html__( 'Choose an icon to display on backside of your flip box.', 'divi-blurb-extended' ),
			),
			'back_image' => array(
				'label'                 => esc_html__( 'Back Image', 'divi-blurb-extended' ),
				'type'                  => 'upload',
				'option_category'       => 'basic_option',
				'upload_button_text'    => esc_attr__( 'Upload an image', 'divi-blurb-extended' ),
				'choose_text'           => esc_attr__( 'Choose an Image', 'divi-blurb-extended' ),
				'update_text'           => esc_attr__( 'Set As Image', 'divi-blurb-extended' ),
				'show_if'               => array(
				    'back_use_icon'  => 'off',
				),
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_elements',
				'sub_toggle'			=> 'back_elements',
				'description'           => esc_html__( 'Upload an image to display on backside of your flip box.', 'divi-blurb-extended' ),
			),
			'back_image_alt' => array(
				'label'                 => esc_html__( 'Back Image Alt Text', 'divi-blurb-extended' ),
				'type'                  => 'text',
				'option_category'       => 'basic_option',
				'show_if'               => array(
				    'back_use_icon'  => 'off',
				),
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_elements',
				'sub_toggle'			=> 'back_elements',
				'description'           => esc_html__( 'Define the HTML ALT text for your image here.', 'divi-blurb-extended' ),
			),
			'back_button_display' => array(
				'label'                 => esc_html__( 'Display Button on Back', 'divi-blurb-extended' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'basic_option',
				'options'               => array(
					'off'   => esc_html__( 'No', 'divi-blurb-extended' ),
					'on'    => esc_html__( 'Yes', 'divi-blurb-extended' ),
				),
				'affects'               => array(
				    'custom_back_button',
				),
				'default'               => 'off',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_elements',
				'sub_toggle'			=> 'back_elements',
				'description'           => esc_html__( 'Here you can choose whether button should be used.', 'divi-blurb-extended' ),
			),
			'back_button_text' => array(
				'label'                 => esc_html__( 'Back Button Text', 'divi-blurb-extended' ),
				'type'                  => 'text',
				'option_category'       => 'basic_option',
				'show_if'               => array(
				    'back_button_display'  => 'on',
				),
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_elements',
				'sub_toggle'			=> 'back_elements',
				'description'           => esc_html__( 'Here you can define custom button text.', 'divi-blurb-extended' ),
			),
			'back_button_url' => array(
				'label'                 => esc_html__( 'Back Button Url', 'divi-blurb-extended' ),
				'type'                  => 'text',
				'option_category'       => 'basic_option',
				'tab_slug'              => 'general',
				'show_if'               => array(
				    'back_button_display'  => 'on',
				),
				'toggle_slug'           => 'flipbox_elements',
				'sub_toggle'			=> 'back_elements',
				'description'           => esc_html__( 'Your button link, input your destination URL here.', 'divi-blurb-extended' ),
			),
			'back_button_target' => array(
				'label'                 => esc_html__( 'Url Opens in New Window', 'divi-blurb-extended' ),
				'type'                  => 'select',
				'option_category'       => 'configuration',
				'show_if'               => array(
				    'back_button_display'  => 'on',
				),
				'options'               => array(
					'off'       => esc_html__( 'In The Same Window', 'divi-blurb-extended' ),
					'on'       => esc_html__( 'In The New Tab', 'divi-blurb-extended' ),
				),
				'default'               => 'off',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'flipbox_elements',
				'sub_toggle'			=> 'back_elements',
				'description'           => esc_html__( 'Here you can choose whether or not your button link opens in a new window', 'divi-blurb-extended' ),
			),
			'front_background_color' => array(
				'label'             => esc_html__( 'Front Background', 'divi-blurb-extended' ),
				'type'              => 'background-field',
				'base_name'         => 'front_background',
				'context'           => 'front_background_color',
				'custom_color'      => true,
				'background_fields' => $this->generate_background_options( "front_background", 'button', 'general', 'flipbox_background', 'front_background_color' ),
				'mobile_options'	=> true,
				'tab_slug'          => 'general',
				'toggle_slug'       => 'flipbox_background',
				'sub_toggle'		=> 'front',
				'description'		=> esc_html__( 'Adjust the background style of the frontside of your flip box by customizing the background color, gradient, and image.' ),
			),
			/*General - Background(Back)*/
			'back_background_color' => array(
				'label'             => esc_html__( 'Back Background', 'divi-blurb-extended' ),
				'type'              => 'background-field',
				'base_name'         => 'back_background',
				'context'           => 'back_background_color',
				'custom_color'      => true,
				'background_fields' => $this->generate_background_options( "back_background", 'button', 'general', 'flipbox_background', 'back_background_color' ),
				'mobile_options'	=> true,
				'tab_slug'          => 'general',
				'toggle_slug'       => 'flipbox_background',
				'sub_toggle'		=> 'back',
				'description'		=> esc_html__( 'Adjust the background style of the backside of your flip box by customizing the background color, gradient, and image.' ),
			),
			'front_icon_placement' => array(
				'label'                 => esc_html__( 'Image/Icon Placement', 'divi-blurb-extended' ),
				'type'                  => 'select',
				'option_category'       => 'layout',
				'options'               => array(
        			'top'   => esc_html__( 'Top', 'divi-blurb-extended' ),
        			'left'  => esc_html__( 'Left', 'divi-blurb-extended' ),
        			'right' => esc_html__( 'Right', 'divi-blurb-extended' ),
        		),
        		'default'               => 'top',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'front_icon_settings',
				'description'           => esc_html__( 'Here you can choose where to place the icon.', 'divi-blurb-extended' ),
			),
			'front_icon_color' => array(
				'label'                 => esc_html__( 'Icon Color', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'show_if'               => array(
				    'front_use_icon'  => 'on',
				),
				'default'               => $et_accent_color,
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'front_icon_settings',
				'description'           => esc_html__('Here you can define a custom color for your icon.', 'divi-blurb-extended'),
			),
			'front_use_icon_font_size' => array(
				'label'                 => esc_html__( 'Use Icon Font Size', 'divi-blurb-extended' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'font_option',
				'options'               => array(
					'off'   => esc_html__( 'No', 'divi-blurb-extended' ),
					'on'    => esc_html__( 'Yes', 'divi-blurb-extended' )
				),
				'show_if'               => array(
				    'front_use_icon'  => 'on',
				),
				'default'               => 'off',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'front_icon_settings',
			),
			'front_icon_font_size' => array(
				'label'                 => esc_html__( 'Icon Font Size', 'divi-blurb-extended' ),
				'type'                  => 'range',
				'option_category'       => 'font_option',
				'range_settings'        => array(
					'min'   => '1',
					'max'   => '120',
					'step'  => '1',
				),
				'mobile_options'        => true,
				'show_if'               => array(
					'front_use_icon'  				=> 'on',
				    'front_use_icon_font_size'   	=> 'on',
				),
				'default'               => '32px',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'front_icon_settings',
			),
			'front_icon_font_size_last_edited' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'front_icon_settings',
			),
			'front_icon_font_size_tablet' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'front_icon_settings',
			),
			'front_icon_font_size_phone' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'front_icon_settings',
			),
			'front_style_icon' => array(
				'label'                 => esc_html__( 'Style Icon', 'divi-blurb-extended' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'configuration',
				'options'               => array(
					'off'   => esc_html__( 'No', 'divi-blurb-extended' ),
					'on'    => esc_html__( 'Yes', 'divi-blurb-extended' )
				),
				'show_if'               => array(
				    'front_use_icon'  => 'on',
				),
				'default'               => 'off',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'front_icon_settings',
				'description'           => esc_html__( 'Here you can choose whether icon set above should display within a shape.', 'divi-blurb-extended' ),
			),
			'front_icon_shape' => array(
				'label'                 => esc_html__( 'Shape', 'divi-blurb-extended' ),
				'type'                  => 'select',
				'option_category'       => 'configuration',
				'options'               => array(
					'use_square'    => esc_html__( 'Square', 'divi-blurb-extended' ),
					'use_circle'    => esc_html__( 'Circle', 'divi-blurb-extended' ),
					'use_hexagon'   => esc_html__( 'Hexagon', 'divi-blurb-extended' )
				),
				'show_if'               => array(
					'front_use_icon'  		=> 'on',
				    'front_style_icon'   	=> 'on',
				),
				'default' 				=> 'use_square',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'front_icon_settings',
				'description'           => esc_html__( 'Here you can choose shape.', 'divi-blurb-extended' ),
			),
			'front_shape_color' => array(
				'label'                 => esc_html__( 'Shape Background', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
					'front_use_icon'  		=> 'on',
				    'front_style_icon'  	=> 'on',
				),
				'default'               => '#000000',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'front_icon_settings',
				'description'           => esc_html__( 'Here you can define a custom color for the icon shape.', 'divi-blurb-extended' ),
			),
			'front_use_shape_border' => array(
				'label'                 => esc_html__( 'Display Shape Border', 'divi-blurb-extended' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'layout',
				'options'               => array(
					'off'   => esc_html__( 'No', 'divi-blurb-extended' ),
					'on'    => esc_html__( 'Yes', 'divi-blurb-extended' )
				),
				'show_if'               => array(
					'front_use_icon'  		=> 'on',
				    'front_style_icon'   	=> 'on',
				),
				'default'               => 'off',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'front_icon_settings',
				'description'           => esc_html__( 'Here you can choose whether if the icon border should display.', 'divi-blurb-extended' ),
			),
			'front_shape_border_color' => array(
				'label'                 => esc_html__( 'Shape Border Color', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
					'front_use_icon'  			=> 'on',
					'front_style_icon'    		=> 'on',
				    'front_use_shape_border'  	=> 'on',
				),
				'default'               => $et_accent_color,
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'front_icon_settings',
				'description'           => esc_html__( 'Here you can define a custom color for the icon border.', 'divi-blurb-extended' ),
			),
			'back_icon_placement' => array(
				'label'                 => esc_html__( 'Image/Icon Placement', 'divi-blurb-extended' ),
				'type'                  => 'select',
				'option_category'       => 'layout',
				'options'               => array(
        			'top'   => esc_html__( 'Top', 'divi-blurb-extended' ),
        			'left'  => esc_html__( 'Left', 'divi-blurb-extended' ),
        			'right' => esc_html__( 'Right', 'divi-blurb-extended' ),
        		),
        		'default'               => 'top',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'back_icon_settings',
				'description'           => esc_html__( 'Here you can choose where to place the icon.', 'divi-blurb-extended' ),
			),
			'back_icon_color' => array(
				'label'                 => esc_html__( 'Icon Color', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'show_if'               => array(
				    'back_use_icon'  => 'on',
				),
				'default'               => $et_accent_color,
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'back_icon_settings',
				'description'           => esc_html__('Here you can define a custom color for your icon.', 'divi-blurb-extended'),
			),
			'back_use_icon_font_size' => array(
				'label'                 => esc_html__( 'Use Icon Font Size', 'divi-blurb-extended' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'font_option',
				'options'               => array(
					'off'   => esc_html__( 'No', 'divi-blurb-extended' ),
					'on'    => esc_html__( 'Yes', 'divi-blurb-extended' )
				),
				'show_if'               => array(
				    'back_use_icon'  => 'on',
				),
				'default'               => 'off',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'back_icon_settings',
			),
			'back_icon_font_size' => array(
				'label'                 => esc_html__( 'Icon Font Size', 'divi-blurb-extended' ),
				'type'                  => 'range',
				'option_category'       => 'font_option',
				'range_settings'        => array(
					'min'   => '1',
					'max'   => '120',
					'step'  => '1',
				),
				'mobile_options'        => true,
				'show_if'               => array(
					'back_use_icon'  			=> 'on',
				    'back_use_icon_font_size'   => 'on',
				),
				'default'               => '32px',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'back_icon_settings',
			),
			'back_icon_font_size_last_edited' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'back_icon_settings',
			),
			'back_icon_font_size_tablet' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'back_icon_settings',
			),
			'back_icon_font_size_phone' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'back_icon_settings',
			),
			'back_style_icon' => array(
				'label'                 => esc_html__( 'Style Icon', 'divi-blurb-extended' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'configuration',
				'options'               => array(
					'off'   => esc_html__( 'No', 'divi-blurb-extended' ),
					'on'    => esc_html__( 'Yes', 'divi-blurb-extended' )
				),
				'show_if'               => array(
				    'back_use_icon'  => 'on',
				),
				'default'               => 'off',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'back_icon_settings',
				'description'           => esc_html__( 'Here you can choose whether icon set above should display within a shape.', 'divi-blurb-extended' ),
			),
			'back_icon_shape' => array(
				'label'                 => esc_html__( 'Shape', 'divi-blurb-extended' ),
				'type'                  => 'select',
				'option_category'       => 'configuration',
				'options'               => array(
					'use_square'    => esc_html__( 'Square', 'divi-blurb-extended' ),
					'use_circle'    => esc_html__( 'Circle', 'divi-blurb-extended' ),
					'use_hexagon'   => esc_html__( 'Hexagon', 'divi-blurb-extended' )
				),
				'show_if'               => array(
					'back_use_icon'  	 => 'on',
				    'back_style_icon'    => 'on',
				),
				'default' 				=> 'use_square',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'back_icon_settings',
				'description'           => esc_html__( 'Here you can choose shape.', 'divi-blurb-extended' ),
			),
			'back_shape_color' => array(
				'label'                 => esc_html__( 'Shape Background', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
					'back_use_icon'     => 'on',
				    'back_style_icon'   => 'on',
				),
				'default'               => '#000000',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'back_icon_settings',
				'description'           => esc_html__( 'Here you can define a custom color for the icon shape.', 'divi-blurb-extended' ),
			),
			'back_use_shape_border' => array(
				'label'                 => esc_html__( 'Display Shape Border', 'divi-blurb-extended' ),
				'type'                  => 'yes_no_button',
				'option_category'       => 'layout',
				'options'               => array(
					'off'   => esc_html__( 'No', 'divi-blurb-extended' ),
					'on'    => esc_html__( 'Yes', 'divi-blurb-extended' )
				),
				'show_if'               => array(
					'back_use_icon'      => 'on',
				    'back_style_icon'    => 'on',
				),
				'default'               => 'off',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'back_icon_settings',
				'description'           => esc_html__( 'Here you can choose whether if the icon border should display.', 'divi-blurb-extended' ),
			),
			'back_shape_border_color' => array(
				'label'                 => esc_html__( 'Shape Border Color', 'divi-blurb-extended' ),
				'type'                  => 'color-alpha',
				'custom_color'          => true,
				'show_if'               => array(
					'back_use_icon'  		 => 'on',
					'back_style_icon'     	 => 'on',
				    'back_use_shape_border'  => 'on',
				),
				'default'               => $et_accent_color,
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'back_icon_settings',
				'description'           => esc_html__( 'Here you can define a custom color for the icon border.', 'divi-blurb-extended' ),
			),
			/*Advanced - Sizing*/
			'front_image_max_width' => array(
				'label'                 => esc_html__( 'Front Image Width', 'divi-blurb-extended' ),
				'type'                  => 'range',
				'option_category'       => 'layout',
				'mobile_options'        => true,
				'validate_unit'         => true,
				'allow_empty'           => true,
				'range_settings'        => array(
					'min'   => '0',
					'max'   => '1100',
					'step'  => '1',
				),
				'show_if'               => array(
				    'front_use_icon'  => 'off',
				),
				'default' 				=> '150px',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
				'description'           => esc_html__( 'Here you can set the minimum width of front image.', 'divi-blurb-extended' ),
			),
			'front_image_max_width_tablet' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'front_image_max_width_phone' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'front_image_max_width_last_edited' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'front_image_alignment' => array(
				'label'                 => esc_html__( 'Front Image Alignment', 'divi-blurb-extended' ),
				'type'                  => 'text_align',
				'option_category'       => 'layout',
				'options'               => et_builder_get_text_orientation_options( array( 'justified' ) ),
				'mobile_options'        => true,
				'show_if'               => array(
				    'front_use_icon' => 'off',
				    'front_icon_placement' => 'top'
				),
				'default'				=> 'center',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
				'description'           => esc_html__( 'Here you can set the alignment of front image.', 'divi-blurb-extended' ),
			),
			'front_image_alignment_tablet' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'front_image_alignment_phone' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'front_image_alignment_last_edited' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'back_image_max_width' => array(
				'label'                 => esc_html__( 'Back Image Width', 'divi-blurb-extended' ),
				'type'                  => 'range',
				'option_category'       => 'layout',
				'mobile_options'        => true,
				'validate_unit'         => true,
				'allow_empty'           => true,
				'range_settings'        => array(
					'min'   => '64',
					'max'   => '1100',
					'step'  => '1',
				),
				'show_if'               => array(
				    'back_use_icon'  => 'off',
				),
				'default' 				=> '150px',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
				'description'           => esc_html__( 'Here you can set the minimum width of back image.', 'divi-blurb-extended' ),
			),
			'back_image_max_width_tablet' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'back_image_max_width_phone' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'back_image_max_width_last_edited' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'back_image_alignment' => array(
				'label'                 => esc_html__( 'Back Image Alignment', 'divi-blurb-extended' ),
				'type'                  => 'text_align',
				'option_category'       => 'layout',
				'options'               => et_builder_get_text_orientation_options( array( 'justified' ) ),
				'mobile_options'        => true,
				'show_if'               => array(
				    'back_use_icon' => 'off',
				    'back_icon_placement' => 'top'
				),
				'default'				=> 'center',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
				'description'           => esc_html__( 'Here you can set the alignment of back image.', 'divi-blurb-extended' ),
			),
			'back_image_alignment_tablet' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'back_image_alignment_phone' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'back_image_alignment_last_edited' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'content_max_width' => array(
				'label'                 => esc_html__( 'Content Width', 'divi-blurb-extended' ),
				'type'                  => 'range',
				'option_category'       => 'layout',
				'mobile_options'        => true,
				'validate_unit'         => true,
				'allow_empty'           => true,
				'range_settings'        => array(
					'min'   => '0',
					'max'   => '1100',
					'step'  => '1',
				),
				'default'               => '550px',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
				'description'           => esc_html__( 'Here you can set the width of the Flip Box.', 'divi-blurb-extended' ),
			),
			'content_max_width_tablet' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'content_max_width_phone' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'content_max_width_last_edited' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'flipbox_min_height' => array(
				'label'                 => esc_html__( 'Min Height', 'divi-blurb-extended' ),
				'type'                  => 'range',
				'option_category'       => 'layout',
				'mobile_options'        => true,
				'validate_unit'         => true,
				'allow_empty'           => true,
				'range_settings'        => array(
					'min'   => '0',
					'max'   => '1000',
					'step'  => '1',
				),
				'default'               => '200px',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
				'description'           => esc_html__( 'Increase or decrease the height of the Flip Box.', 'divi-blurb-extended' ),
			),
			'flipbox_min_height_tablet' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'flipbox_min_height_phone' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			'flipbox_min_height_last_edited' => array(
				'type'                  => 'skip',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'width',
			),
			/*Content Alignmenr*/
			'front_content_align' => array(
				'label'                 => esc_html__( 'Front Content Alignment', 'divi-blurb-extended' ),
				'type'                  => 'select',
				'option_category'       => 'configuration',
				'options'               => array(
					'top'       => esc_html__( 'Top', 'divi-blurb-extended' ),
					'center'      => esc_html__( 'Center', 'divi-blurb-extended' ),
					'bottom'     => esc_html__( 'Bottom', 'divi-blurb-extended' ),
				),
				'default'               => 'center',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'front_style_settings',
				'description'            => esc_html__( 'This controls the content alignment of front box.', 'divi-blurb-extended' ),
			),
			'back_content_align' => array(
				'label'                 => esc_html__( 'Back Content Alignment', 'divi-blurb-extended' ),
				'type'                  => 'select',
				'option_category'       => 'configuration',
				'options'               => array(
					'top'       => esc_html__( 'Top', 'divi-blurb-extended' ),
					'center'      => esc_html__( 'Center', 'divi-blurb-extended' ),
					'bottom'     => esc_html__( 'Bottom', 'divi-blurb-extended' ),
				),
				'default'               => 'center',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'back_style_settings',
				'description'            => esc_html__( 'This controls the content alignment of back box.', 'divi-blurb-extended' ),
			),
			'animation' => array(
				'label'                 => esc_html__( 'Image/Icon Animation', 'divi-blurb-extended' ),
				'type'                  => 'select',
				'option_category'       => 'configuration',
				'options'               => array(
					'top'       => esc_html__( 'Top To Bottom', 'divi-blurb-extended' ),
					'left'      => esc_html__( 'Left To Right', 'divi-blurb-extended' ),
					'right'     => esc_html__( 'Right To Left', 'divi-blurb-extended' ),
					'bottom'    => esc_html__( 'Bottom To Top', 'divi-blurb-extended' ),
					'off'       => esc_html__( 'No Animation', 'divi-blurb-extended' ),
				),
				'default'               => 'top',
				'tab_slug'              => 'advanced',
				'toggle_slug'           => 'animation',
				'description'            => esc_html__( 'This controls the direction of the lazy-loading animation.', 'divi-blurb-extended' ),
			),
			'disabled_on' => array(
				'label'                 => esc_html__( 'Disable on', 'divi-blurb-extended' ),
				'type'                  => 'multiple_checkboxes',
				'options'               => array(
					'phone'     => esc_html__( 'Phone', 'divi-blurb-extended' ),
					'tablet'    => esc_html__( 'Tablet', 'divi-blurb-extended' ),
					'desktop'   => esc_html__( 'Desktop', 'divi-blurb-extended' ),
				),
				'additional_att'        => 'disable_on',
				'option_category'       => 'configuration',
				'tab_slug'              => 'custom_css',
				'toggle_slug'           => 'visibility',
				'description'           => esc_html__( 'This will disable the module on selected devices', 'divi-blurb-extended' ),
			),
			'admin_label' => array(
				'label'                 => esc_html__( 'Admin Label', 'divi-blurb-extended' ),
				'type'                  => 'text',
				'tab_slug'              => 'general',
				'toggle_slug'           => 'admin_label',
				'description'           => esc_html__('This will change the label of the module in the builder for easy identification.', 'divi-blurb-extended'),
			),
			'module_id' => array(
				'label'                 => esc_html__( 'CSS ID', 'divi-blurb-extended' ),
				'type'                  => 'text',
				'option_category'       => 'configuration',
				'option_class'          => 'et_pb_custom_css_regular',
				'tab_slug'              => 'custom_css',
				'toggle_slug'           => 'classes',
			),
			'module_class' => array(
				'label'                 => esc_html__( 'CSS Class', 'divi-blurb-extended' ),
				'type'                  => 'text',
				'option_category'       => 'configuration',
				'option_class'          => 'et_pb_custom_css_regular',
				'tab_slug'              => 'custom_css',
				'toggle_slug'           => 'classes',
			));
  			$flip_box_fields = array_merge( $flip_box_fields, $this->generate_background_options( 'front_background', 'skip', 'general', 'flipbox_background', 'front_background_color' ) );
  			$flip_box_fields = array_merge( $flip_box_fields, $this->generate_background_options( 'back_background', 'skip', 'general', 'flipbox_background', 'back_background_color' ) );
  			return $flip_box_fields;
	}

	public function render( $attrs, $content, $render_slug ) {

		$flipbox_layout 					= esc_attr( $this->props['flipbox_layout'] );
		$layout1_flip_style 				= esc_attr( $this->props['layout1_flip_style'] );
		$layout1_3d_depth 					= esc_attr( $this->props['layout1_3d_depth'] );
		$layout1_shake_effect				= esc_attr( $this->props['layout1_shake_effect'] );
		$layout2_flip_style 				= esc_attr( $this->props['layout2_flip_style'] );
		$flip_speed 						= esc_attr( $this->props['flip_speed'] );
		$layout3_flip_style 				= esc_attr( $this->props['layout3_flip_style'] );
		$layout4_flip_style 				= esc_attr( $this->props['layout4_flip_style'] );
		$layout5_flip_style 				= esc_attr( $this->props['layout5_flip_style'] );
		$layout6_flip_style 				= esc_attr( $this->props['layout6_flip_style'] );
		$front_title 						= wp_kses_post( $this->props['front_title'] );
		$front_content                      = wp_kses_post( $this->props['front_content'] );
		$back_title 						= wp_kses_post( $this->props['back_title'] );
		$front_use_icon 					= esc_attr( $this->props['front_use_icon'] );
		$front_font_icon 					= $this->props['front_font_icon'];
		$front_image 						= esc_attr( $this->props['front_image'] );
		$front_image_alt 					= esc_attr( $this->props['front_image_alt'] );
		$back_use_icon 						= esc_attr( $this->props['back_use_icon'] );
		$back_font_icon 					= $this->props['back_font_icon'];
		$back_image 						= esc_attr( $this->props['back_image'] );
		$back_image_alt 					= esc_attr( $this->props['back_image_alt'] );
		$back_button_display 				= esc_attr( $this->props['back_button_display'] );
		$back_button_use_icon 				= esc_attr( $this->props['back_button_use_icon'] );
		$back_button_text 					= esc_attr( $this->props['back_button_text'] );
		$back_button_url 					= esc_attr( $this->props['back_button_url'] );
		$back_button_target 				= esc_attr( $this->props['back_button_target'] );
		$custom_back_button					= esc_attr( $this->props['custom_back_button'] );
		$back_button_use_icon       		= esc_attr( $this->props['back_button_use_icon'] );
		$back_data_icon 					= $this->props['back_button_icon'];
		$front_icon_placement 				= esc_attr( $this->props['front_icon_placement'] );
		$front_icon_color 					= esc_attr( $this->props['front_icon_color'] );
		$front_use_icon_font_size 			= esc_attr( $this->props['front_use_icon_font_size'] );
		$front_icon_font_size 				= esc_attr( $this->props['front_icon_font_size'] );
		$front_icon_font_size_last_edited 	= esc_attr( $this->props['front_icon_font_size_last_edited'] );
		$front_icon_font_size_tablet 		= esc_attr( $this->props['front_icon_font_size_tablet'] );
		$front_icon_font_size_phone 		= esc_attr( $this->props['front_icon_font_size_phone'] );
		$front_style_icon 					= esc_attr( $this->props['front_style_icon'] );
		$front_icon_shape 					= esc_attr( $this->props['front_icon_shape'] );
		$front_shape_color 					= esc_attr( $this->props['front_shape_color'] );
		$front_use_shape_border 			= esc_attr( $this->props['front_use_shape_border'] );
		$front_shape_border_color 			= esc_attr( $this->props['front_shape_border_color'] );
		$back_icon_placement 				= esc_attr( $this->props['back_icon_placement'] );
		$back_icon_color 					= esc_attr( $this->props['back_icon_color'] );
		$back_use_icon_font_size 			= esc_attr( $this->props['back_use_icon_font_size'] );
		$back_icon_font_size 				= esc_attr( $this->props['back_icon_font_size'] );
		$back_icon_font_size_last_edited 	= esc_attr( $this->props['back_icon_font_size_last_edited'] );
		$back_icon_font_size_tablet 		= esc_attr( $this->props['back_icon_font_size_tablet'] );
		$back_icon_font_size_phone 			= esc_attr( $this->props['back_icon_font_size_phone'] );
		$back_style_icon 					= esc_attr( $this->props['back_style_icon'] );
		$back_icon_shape 					= esc_attr( $this->props['back_icon_shape'] );
		$back_shape_color 					= esc_attr( $this->props['back_shape_color'] );
		$back_use_shape_border 				= esc_attr( $this->props['back_use_shape_border'] );
		$back_shape_border_color 			= esc_attr( $this->props['back_shape_border_color'] );
		$front_image_max_width 				= esc_attr( $this->props['front_image_max_width'] );
		$front_image_max_width_tablet 		= esc_attr( $this->props['front_image_max_width_tablet'] );
		$front_image_max_width_phone 		= esc_attr( $this->props['front_image_max_width_phone'] );
		$front_image_max_width_last_edited 	= esc_attr( $this->props['front_image_max_width_last_edited'] );
		$front_image_alignment              = esc_attr( $this->props['front_image_alignment'] );
		$back_image_max_width 				= esc_attr( $this->props['back_image_max_width'] );
		$back_image_max_width_tablet 		= esc_attr( $this->props['back_image_max_width_tablet'] );
		$back_image_max_width_phone 		= esc_attr( $this->props['back_image_max_width_phone'] );
		$back_image_max_width_last_edited 	= esc_attr( $this->props['back_image_max_width_last_edited'] );
		$back_image_alignment               = esc_attr( $this->props['back_image_alignment'] );
		$content_max_width 					= esc_attr( $this->props['content_max_width'] );
		$content_max_width_tablet 			= esc_attr( $this->props['content_max_width_tablet'] );
		$content_max_width_phone 			= esc_attr( $this->props['content_max_width_phone'] );
		$content_max_width_last_edited 		= esc_attr( $this->props['content_max_width_last_edited'] );
		$flipbox_min_height 				= esc_attr( $this->props['flipbox_min_height'] );
		$flipbox_min_height_tablet 			= esc_attr( $this->props['flipbox_min_height_tablet'] );
		$flipbox_min_height_phone 			= esc_attr( $this->props['flipbox_min_height_phone'] );
		$flipbox_min_height_last_edited 	= esc_attr( $this->props['flipbox_min_height_last_edited'] );
		$animation 							= esc_attr( $this->props['animation'] );
		$module_id 							= esc_attr( $this->props['module_id'] );
		$module_class 						= esc_attr( $this->props['module_class'] );
		$front_header_level                 = esc_attr( $this->props['front_header_level'] );
		$back_header_level                  = esc_attr( $this->props['back_header_level'] );
		$front_content_align 				= esc_attr( $this->props['front_content_align'] );
		$back_content_align 				= esc_attr( $this->props['back_content_align'] );
		$processed_header_level_front 		= et_pb_process_header_level( esc_attr( $front_header_level ), 'h4' );
		$processed_header_level_back 		= et_pb_process_header_level( esc_attr( $back_header_level ), 'h4' );

		wp_enqueue_script( 'elicus-images-loaded-script' );

		/*Default Animation Class Added for backward compatibility*/
		if ( empty( $animation ) ) {
			$animation = 'top';
		}

		/*Advanced Flip Box Front Title*/
		if ( '' !== $front_title ) {
			$front_title = sprintf( '<%1$s class="et_pb_module_header">%2$s</%1$s>', $processed_header_level_front, $front_title );
		}

		/*Advanced Flip Box Back Title*/
		if ( '' !== $back_title ) {
			$back_title = sprintf( '<%1$s class="et_pb_module_header">%2$s</%1$s>', $processed_header_level_back, $back_title );
		}

		/*Advanced Flip Box Front Content reponsive CSS*/
		if ( '' !== $content_max_width_tablet || '' !== $content_max_width_phone || '' !== $content_max_width ) {
			$content_max_width_responsive_active = et_pb_get_responsive_status( $content_max_width_last_edited );

			$content_max_width_values = array(
				'desktop' => $content_max_width,
				'tablet'  => $content_max_width_responsive_active ? $content_max_width_tablet : '',
				'phone'   => $content_max_width_responsive_active ? $content_max_width_phone : '',
			);

			et_pb_generate_responsive_css( $content_max_width_values, '%%order_class%% .et_pb_flipbox_advanced_wrapper', 'max-width', $render_slug );
		}

		if ( '' !== $flipbox_min_height_tablet || '' !== $flipbox_min_height_phone || '' !== $flipbox_min_height ) {
			$flipbox_min_height_responsive_active = et_pb_get_responsive_status( $flipbox_min_height_last_edited );

			$flipbox_min_height_values = array(
				'desktop' => $flipbox_min_height,
				'tablet'  => $flipbox_min_height_responsive_active ? $flipbox_min_height_tablet : '',
				'phone'   => $flipbox_min_height_responsive_active ? $flipbox_min_height_phone : '',
			);

			et_pb_generate_responsive_css( $flipbox_min_height_values, '%%order_class%% .flipbox_side', 'min-height', $render_slug );
		}


		/*Advanced Flip Box Back Content*/
		if ( '' !== $this->content ) {
			$back_content = sprintf( '%1$s', __( wp_kses_post( $this->content ), 'divi-blurb-extended' ) );
		} else {
			$back_content = '';
		} 

		/*Advanced Flip Box Front Image & Icon responsive CSS*/
		if ( 'off' !== $front_use_icon_font_size ) {
			$front_font_size_responsive_active = et_pb_get_responsive_status( $front_icon_font_size_last_edited );
			
			$front_font_size_values = array(
				'desktop'   => $front_icon_font_size,
				'tablet'    => $front_font_size_responsive_active ? $front_icon_font_size_tablet : '',
				'phone'     => $front_font_size_responsive_active ? $front_icon_font_size_phone : '',
			);
			/*SEE*/
			et_pb_generate_responsive_css( $front_font_size_values, '%%order_class%% .flipbox_front .et-pb-icon', 'font-size', $render_slug );
		}
		
		$image_alignment_styles = array(
			'left'   => 'margin-left: 0px !important; margin-right: auto !important; text-align: left;',
			'center' => 'margin-left: auto !important; margin-right: auto !important; text-align: center;',
			'right'  => 'margin-left: auto !important; margin-right: 0px !important; text-align: right;',
		);

		$front_image_pathinfo 	= pathinfo( $front_image );
		$is_front_image_svg		= isset( $front_image_pathinfo['extension'] ) ? 'svg' === $front_image_pathinfo['extension'] : false;
		if ( 'off' === $front_use_icon && ('' !== $front_image_max_width_tablet || '' !== $front_image_max_width_phone || '' !== $front_image_max_width || $is_front_image_svg) ) {
			// SVG image overwrite. SVG image needs its value to be explicit
			if ( '' === $front_image_max_width && $is_front_image_svg ) {
				$image_max_width = '100%';
			}

			$front_image_max_width_selector = '%%order_class%% .flipbox_front .et_pb_main_flipbox_image';
			$front_image_max_width_property =  'width'; //$is_image_svg ? 'width' : 'max-width';

			$front_image_max_width_responsive_active = et_pb_get_responsive_status( $front_image_max_width_last_edited );

			$front_image_max_width_values = array(
				'desktop' => $front_image_max_width,
				'tablet'  => $front_image_max_width_responsive_active ? $front_image_max_width_tablet : '',
				'phone'   => $front_image_max_width_responsive_active ? $front_image_max_width_phone : '',
			);

			et_pb_generate_responsive_css( $front_image_max_width_values, $front_image_max_width_selector, $front_image_max_width_property, $render_slug );
			
			if ( 'top' === $front_icon_placement ) {
			    if ( isset( $image_alignment_styles[$front_image_alignment] ) ) {
    			    ET_Builder_Element::set_style( $render_slug, array(
        			    'selector'      => $front_image_max_width_selector,
        			    'declaration'   => $image_alignment_styles[$front_image_alignment]
            		) );
			    }
			    
			    
			    $front_image_alignment_tablet = $this->props['front_image_alignment_tablet'];
				if ( isset( $image_alignment_styles[ $front_image_alignment_tablet ] ) ) {
					ET_Builder_Element::set_style( $render_slug, array(
        			    'selector'    => $front_image_max_width_selector,
						'declaration' => $image_alignment_styles[$front_image_alignment_tablet],
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					) );
				}

				$front_image_alignment_phone = $this->props['front_image_alignment_phone'];
				if ( isset( $image_alignment_styles[ $front_image_alignment_phone ] ) ) {
					ET_Builder_Element::set_style( $render_slug, array(
        			    'selector'    => $front_image_max_width_selector,
						'declaration' => $image_alignment_styles[ $front_image_alignment_phone ],
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					) );
				}
			}
		}

		if (
            'layout1' === $flipbox_layout &&
            (
            	'diagonalLeft' === $layout1_flip_style ||
            	'diagonalRight' === $layout1_flip_style ||
            	'diagonalLeftInverted' === $layout1_flip_style ||
            	'diagonalRightInverted' === $layout1_flip_style
            )
        ) {
        	ET_Builder_Element::set_style( $render_slug, array(
			    'selector'    => '%%order_class%% .layout1',
				'declaration' => 'backface-visibility: visible;',
			) );
		}

		/*Advanced Flip Box back image & icon responsive CSS*/
		if ( 'off' !== $back_use_icon_font_size ) {
			$back_font_size_responsive_active = et_pb_get_responsive_status( $back_icon_font_size_last_edited );
			
			$back_font_size_values = array(
				'desktop'   => $back_icon_font_size,
				'tablet'    => $back_font_size_responsive_active ? $back_icon_font_size_tablet : '',
				'phone'     => $back_font_size_responsive_active ? $back_icon_font_size_phone : '',
			);
			/*SEE*/
			et_pb_generate_responsive_css( $back_font_size_values, '%%order_class%% .flipbox_back .et-pb-icon', 'font-size', $render_slug );
		}

		$back_image_pathinfo 	= pathinfo( $back_image );
		$is_back_image_svg		= isset( $back_image_pathinfo['extension'] ) ? 'svg' === $back_image_pathinfo['extension'] : false;
		if ( 'off' === $back_use_icon && ('' !== $back_image_max_width_tablet || '' !== $back_image_max_width_phone || '' !== $back_image_max_width || $is_back_image_svg) ) {
			// SVG image overwrite. SVG image needs its value to be explicit
			if ( '' === $back_image_max_width && $is_back_image_svg ) {
				$image_max_width = '100%';
			}

			$back_image_max_width_selector = '%%order_class%% .flipbox_back .et_pb_main_flipbox_image';
			$back_image_max_width_property =  'width'; //$is_image_svg ? 'width' : 'max-width';

			$back_image_max_width_responsive_active = et_pb_get_responsive_status( $back_image_max_width_last_edited );

			$back_image_max_width_values = array(
				'desktop' => $back_image_max_width,
				'tablet'  => $back_image_max_width_responsive_active ? $back_image_max_width_tablet : '',
				'phone'   => $back_image_max_width_responsive_active ? $back_image_max_width_phone : '',
			);

			et_pb_generate_responsive_css( $back_image_max_width_values, $back_image_max_width_selector, $back_image_max_width_property, $render_slug );
			
			if ( 'top' === $back_icon_placement ) {
			    if ( isset( $image_alignment_styles[$back_image_alignment] ) ) {
    			    ET_Builder_Element::set_style( $render_slug, array(
        			    'selector'      => $back_image_max_width_selector,
        			    'declaration'   => $image_alignment_styles[$back_image_alignment]
            		) );
			    }
			    
			    $back_image_alignment_tablet = $this->props['back_image_alignment_tablet'];
				if ( isset( $image_alignment_styles[ $back_image_alignment_tablet ] ) ) {
					ET_Builder_Element::set_style( $render_slug, array(
        			    'selector'    => $back_image_max_width_selector,
						'declaration' => $image_alignment_styles[$back_image_alignment_tablet],
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					) );
				}

				$back_image_alignment_phone = $this->props['back_image_alignment_phone'];
				if ( isset( $image_alignment_styles[ $back_image_alignment_phone ] ) ) {
					ET_Builder_Element::set_style( $render_slug, array(
        			    'selector'    => $back_image_max_width_selector,
						'declaration' => $image_alignment_styles[ $back_image_alignment_phone ],
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					) );
				}
			}
		}

		/*Advanced Flip Box front image/icon Display*/
		if ( 'off' === $front_use_icon && '' !== $front_image ) {
			    $front_image_class    = ( '' !== trim( $front_image ) ) ? ' use-image-front' : '';
				$front_image          = ( '' !== trim( $front_image ) ) ? sprintf( '<img src="%1$s" alt="%2$s"/>', esc_url( $front_image ), esc_attr( $front_image_alt ) ) : '';
		} else {
			$front_icon_style     = sprintf( 'color: %1$s;', esc_attr( $front_icon_color ) );
			$front_image_class    = '';
			$front_icon_class     = '';
			$hexagon_start  = '';
			$hexagon_end    = '';
			
			if ( 'on' === $front_style_icon ) {
				
				if ( 'use_circle' === $front_icon_shape ) {
					$front_icon_class     = ' el-icon-circle';
					$front_icon_style    .= sprintf( ' background-color: %1$s;', esc_attr( $front_shape_color ) );
					if ( 'on' === $front_use_shape_border ) {
						$front_icon_style .= sprintf( ' border-color: %1$s;', esc_attr( $front_shape_border_color ) );
					}
				} else if ( 'use_square' === $front_icon_shape ) {
					$front_icon_class     = ' el-icon-square';
					$front_icon_style    .= sprintf( ' background-color: %1$s;', esc_attr( $front_shape_color ) );
					if ( 'on' === $front_use_shape_border ) {
						$front_icon_style .= sprintf( ' border-color: %1$s;', esc_attr( $front_shape_border_color ) );
					}
				} else if ( 'use_hexagon' === $front_icon_shape ) {
					$front_icon_class     = ' el-icon-hexagon';
					$hexagon_style  = sprintf( ' background-color: %1$s;', esc_attr( $front_shape_color ) );
					if ( 'on' === $front_use_shape_border ) {
						$hexagon_style  .= sprintf( ' border-color: %1$s;', esc_attr( $front_shape_border_color ) );
					}
					$hexagon_start = sprintf( '<div class="hexagon-wrapper et-waypoint%2$s"><div class="hex"><div class="hexagon' . ( 'on' === $front_use_shape_border ? ' et-pb-icon-shape-border' : '' ) . '" style="%1$s">', $hexagon_style, esc_attr( " et_pb_animation_{$animation}" ) );
					$hexagon_end   = '</div></div></div>';
				}	
			}

			$front_image = ( '' !== $front_font_icon ) ? sprintf( $hexagon_start . '<span class="et-pb-icon%7$s%6$s%2$s%3$s%4$s" style="%5$s">%1$s</span>' . $hexagon_end,
				            esc_attr( et_pb_process_font_icon( $front_font_icon ) ),
				            esc_attr( " et_pb_animation_{$animation}" ),
				            $front_icon_class,
				            ( 'on' === $front_style_icon && 'on' === $front_use_shape_border && 'use_hexagon' !== $front_icon_shape ? ' et-pb-icon-shape-border' : '' ),
				            $front_icon_style,
				            ( 'on' === $front_style_icon && 'use_hexagon' !== $front_icon_shape ? ' et-waypoint' : '' ),
				            ( 'off' === $front_style_icon ? ' et-waypoint' : '' ) ) : '';

			if ( '' !== $front_font_icon ) {
				if ( class_exists( 'ET_Builder_Module_Helper_Style_Processor' ) && method_exists( 'ET_Builder_Module_Helper_Style_Processor', 'process_extended_icon' ) ) {
	                $this->generate_styles(
	                    array(
	                        'utility_arg'    => 'icon_font_family',
	                        'render_slug'    => $render_slug,
	                        'base_attr_name' => 'front_font_icon',
	                        'important'      => true,
	                        'selector'       => '%%order_class%% .flipbox_front .et-pb-icon',
	                        'processor'      => array(
	                            'ET_Builder_Module_Helper_Style_Processor',
	                            'process_extended_icon',
	                        ),
	                    )
	                );
	            }
			}
		}

		/*Advanced Flip Box back image/icon Display*/
		if ( 'off' === $back_use_icon && '' !== $back_image ) {
			    $back_image_class    = ( '' !== trim( $back_image ) ) ? ' use-image-back' : '';
				$back_image          = ( '' !== trim( $back_image ) ) ? sprintf( '<img src="%1$s" alt="%2$s"/>', esc_url( $back_image ), esc_attr( $back_image_alt ) ) : '';
		} else {
			$back_icon_style     = sprintf( 'color: %1$s;', esc_attr( $back_icon_color ) );
			$back_image_class    = '';
			$back_icon_class     = '';
			$hexagon_start  = '';
			$hexagon_end    = '';
			
			if ( 'on' === $back_style_icon ) {
				
				if ( 'use_circle' === $back_icon_shape ) {
					$back_icon_class     = ' el-icon-circle';
					$back_icon_style    .= sprintf( ' background-color: %1$s;', esc_attr( $back_shape_color ) );
					if ( 'on' === $back_use_shape_border ) {
						$back_icon_style .= sprintf( ' border-color: %1$s;', esc_attr( $back_shape_border_color ) );
					}
				} else if ( 'use_square' === $back_icon_shape ) {
					$back_icon_class     = ' el-icon-square';
					$back_icon_style    .= sprintf( ' background-color: %1$s;', esc_attr( $back_shape_color ) );
					if ( 'on' === $back_use_shape_border ) {
						$back_icon_style .= sprintf( ' border-color: %1$s;', esc_attr( $back_shape_border_color ) );
					}
				} else if ( 'use_hexagon' === $back_icon_shape ) {
					$back_icon_class     = ' el-icon-hexagon';
					$hexagon_style  = sprintf( ' background-color: %1$s;', esc_attr( $back_shape_color ) );
					if ( 'on' === $back_use_shape_border ) {
						$hexagon_style  .= sprintf( ' border-color: %1$s;', esc_attr( $back_shape_border_color ) );
					}
					$hexagon_start = sprintf( '<div class="hexagon-wrapper et-waypoint%2$s"><div class="hex"><div class="hexagon' . ( 'on' === $back_use_shape_border ? ' et-pb-icon-shape-border' : '' ) . '" style="%1$s">', $hexagon_style, esc_attr( " et_pb_animation_{$animation}" ) );
					$hexagon_end   = '</div></div></div>';
				}
				
			}

			$back_image = ( '' !== $back_font_icon ) ? sprintf( $hexagon_start . '<span class="et-pb-icon%7$s%6$s%2$s%3$s%4$s" style="%5$s">%1$s</span>' . $hexagon_end,
			            esc_attr( et_pb_process_font_icon( $back_font_icon ) ),
			            esc_attr( " et_pb_animation_{$animation}" ),
			            $back_icon_class,
			            ( 'on' === $back_style_icon && 'on' === $back_use_shape_border && 'use_hexagon' !== $back_icon_shape ? ' et-pb-icon-shape-border' : '' ),
			            $back_icon_style,
			            ( 'on' === $back_style_icon && 'use_hexagon' !== $back_icon_shape ? ' et-waypoint' : '' ),
			        	( 'off' === $back_style_icon ? ' et-waypoint' : '' ) ) : '';

			if ( '' !== $back_font_icon ) {
				if ( class_exists( 'ET_Builder_Module_Helper_Style_Processor' ) && method_exists( 'ET_Builder_Module_Helper_Style_Processor', 'process_extended_icon' ) ) {
	                $this->generate_styles(
	                    array(
	                        'utility_arg'    => 'icon_font_family',
	                        'render_slug'    => $render_slug,
	                        'base_attr_name' => 'back_font_icon',
	                        'important'      => true,
	                        'selector'       => '%%order_class%% .flipbox_back .et-pb-icon',
	                        'processor'      => array(
	                            'ET_Builder_Module_Helper_Style_Processor',
	                            'process_extended_icon',
	                        ),
	                    )
	                );
	            }
			}
		}

		/*Advanced Flip Box back Button Display*/
		if ( 'off' !== $back_button_display ) {
			$back_button_output = $this->render_button( array(
				'button_text'      => esc_html( $back_button_text ),
				'button_url'       => esc_url( $back_button_url ),
				'url_new_window'   => $back_button_target,
				'button_custom'    => $custom_back_button,
				'custom_icon'	   => $back_data_icon,
			) );
		} else {
			$back_button_output = '';
		}
		
 		if ( file_exists( plugin_dir_path( __FILE__ ) . 'layouts/' . $flipbox_layout . '.php' ) ) {
            include ( plugin_dir_path( __FILE__ ) . 'layouts/' . $flipbox_layout . '.php' );
        }

        $backgrounds = array(
			'front_background' => array(
				'normal' => "{$this->main_css_element} .flipbox_front",
				'hover' => "{$this->main_css_element} .flipbox_front:hover",
 			),
 			'back_background' => array(
 				'normal' => "{$this->main_css_element} .flipbox_back",
 				'hover' => "{$this->main_css_element} .flipbox_back:hover",
 			),
		);
		
		if ( ET_BUILDER_PRODUCT_VERSION >= '4.16.0' ) {
			foreach( $backgrounds as $basename => $css_element ) {
	            $bg_args = array(
	                'base_prop_name'                => $basename,
	                'props'                         => $this->props,
	                'important'                     => ' !important',
	                'fields_definition'             => $this->fields_unprocessed,
	                'selector'                      => $css_element['normal'],
	                'selector_hover'                => $css_element['hover'],
	                'function_name'                 => $render_slug,
	                'has_background_color_toggle'   => false,
	                'use_background_color'          => true,
	                'use_background_image'          => true,
	                'use_background_color_reset'    => true,
	                'use_background_video'          => false,
	                'use_background_pattern'        => false,
	                'use_background_mask'           => false,
	                'use_background_image_parallax' => false,
	                'prop_name_aliases'             => array(
	                    "use_{$basename}_color_gradient" => "{$basename}_use_color_gradient",
	                    "{$basename}" => "{$basename}_color",
	                ),
	            );

	            // Process background style.
	            et_pb_background_options()->get_background_style( $bg_args );
	        }
	    } else {
	    	$this->process_custom_background( $backgrounds, $render_slug );
	    }
        
		return 	$flipbox_content;
	}

	public function process_custom_background( $backgrounds, $function_name ) {

		foreach ( $backgrounds as $basename => $css_element ) {

			// Place to store processed background. It will be compared with the smaller device
			// background processed value to avoid rendering the same styles.
			$processed_background_color = '';
			$processed_background_image = '';
			$processed_background_blend = '';

			// Store background images status because the process is extensive.
			$background_image_status = array(
				'desktop' => false,
				'tablet'  => false,
				'phone'   => false,
			);

			// Background Options Styling.
			foreach ( et_pb_responsive_options()->get_modes() as $device ) {
				$background_base_name = $basename;
				$background_prefix    = "{$basename}_";
				$background_style     = '';
				$is_desktop           = 'desktop' === $device;
				$suffix               = ! $is_desktop ? "_{$device}" : '';

				$background_color_style = '';
				$background_image_style = '';
				$background_images      = array();

				$has_background_color_gradient         = false;
				$has_background_image                  = false;
				$has_background_gradient_and_image     = false;
				$is_background_color_gradient_disabled = false;
				$is_background_image_disabled          = false;

				$background_color_gradient_overlays_image = 'off';

				// Ensure responsive is active.
				if ( ! $is_desktop && ! et_pb_responsive_options()->is_responsive_enabled( $this->props, "{$basename}_color" ) ) {
					continue;
				}

				// A. Background Gradient.
				$use_background_color_gradient = et_pb_responsive_options()->get_inheritance_background_value( $this->props, "{$background_prefix}use_color_gradient", $device, $background_base_name, $this->fields_unprocessed );

				if ( 'on' === $use_background_color_gradient ) {
					$background_color_gradient_overlays_image = et_pb_responsive_options()->get_any_value( $this->props, "{$background_prefix}color_gradient_overlays_image{$suffix}", '', true );

					$gradient_properties = array(
						'type'             => et_pb_responsive_options()->get_any_value( $this->props, "{$background_prefix}color_gradient_type{$suffix}", '', true ),
						'direction'        => et_pb_responsive_options()->get_any_value( $this->props, "{$background_prefix}color_gradient_direction{$suffix}", '', true ),
						'radial_direction' => et_pb_responsive_options()->get_any_value( $this->props, "{$background_prefix}color_gradient_direction_radial{$suffix}", '', true ),
						'color_start'      => et_pb_responsive_options()->get_any_value( $this->props, "{$background_prefix}color_gradient_start{$suffix}", '', true ),
						'color_end'        => et_pb_responsive_options()->get_any_value( $this->props, "{$background_prefix}color_gradient_end{$suffix}", '', true ),
						'start_position'   => et_pb_responsive_options()->get_any_value( $this->props, "{$background_prefix}color_gradient_start_position{$suffix}", '', true ),
						'end_position'     => et_pb_responsive_options()->get_any_value( $this->props, "{$background_prefix}color_gradient_end_position{$suffix}", '', true ),
					);

					// Save background gradient into background images list.
					$background_images[] = $this->get_gradient( $gradient_properties );

					// Flag to inform BG Color if current module has Gradient.
					$has_background_color_gradient = true;
				} elseif ( 'off' === $use_background_color_gradient ) {
					$is_background_color_gradient_disabled = true;
				}

				// B. Background Image.
				$background_image = et_pb_responsive_options()->get_inheritance_background_value( $this->props, "{$background_prefix}image", $device, $background_base_name, $this->fields_unprocessed );
				$parallax         = et_pb_responsive_options()->get_any_value( $this->props, "{$background_prefix}parallax{$suffix}", 'off' );

				// BG image and parallax status.
				$is_background_image_active         = '' !== $background_image && 'on' !== $parallax;
				$background_image_status[ $device ] = $is_background_image_active;

				if ( $is_background_image_active ) {
					// Flag to inform BG Color if current module has Image.
					$has_background_image = true;

					// Check previous BG image status. Needed to get the correct value.
					$is_prev_background_image_active = true;
					if ( ! $is_desktop ) {
						$is_prev_background_image_active = 'tablet' === $device ? $background_image_status['desktop'] : $background_image_status['tablet'];
					}

					// Size.
					$background_size_default = ET_Builder_Element::$_->array_get( $this->fields_unprocessed, "{$background_prefix}size.default", '' );
					$background_size         = et_pb_responsive_options()->get_any_value( $this->props, "{$background_prefix}size{$suffix}", $background_size_default, ! $is_prev_background_image_active );

					if ( '' !== $background_size ) {
						$background_style .= sprintf(
							'background-size: %1$s; ',
							esc_html( $background_size )
						);
					}

					// Position.
					$background_position_default = ET_Builder_Element::$_->array_get( $this->fields_unprocessed, "{$background_prefix}position.default", '' );
					$background_position         = et_pb_responsive_options()->get_any_value( $this->props, "{$background_prefix}position{$suffix}", $background_position_default, ! $is_prev_background_image_active );

					if ( '' !== $background_position ) {
						$background_style .= sprintf(
							'background-position: %1$s; ',
							esc_html( str_replace( '_', ' ', $background_position ) )
						);
					}

					// Repeat.
					$background_repeat_default = ET_Builder_Element::$_->array_get( $this->fields_unprocessed, "{$background_prefix}repeat.default", '' );
					$background_repeat         = et_pb_responsive_options()->get_any_value( $this->props, "{$background_prefix}repeat{$suffix}", $background_repeat_default, ! $is_prev_background_image_active );

					if ( '' !== $background_repeat ) {
						$background_style .= sprintf(
							'background-repeat: %1$s; ',
							esc_html( $background_repeat )
						);
					}

					// Blend.
					$background_blend_default = ET_Builder_Element::$_->array_get( $this->fields_unprocessed, "{$background_prefix}blend.default", '' );
					$background_blend         = et_pb_responsive_options()->get_any_value( $this->props, "{$background_prefix}blend{$suffix}", $background_blend_default, ! $is_prev_background_image_active );
					$background_blend_inherit = et_pb_responsive_options()->get_any_value( $this->props, "{$background_prefix}blend{$suffix}", '', true );

					if ( '' !== $background_blend_inherit ) {
						// Don't print the same image blend style.
						if ( '' !== $background_blend ) {
							$background_style .= sprintf(
								'background-blend-mode: %1$s; ',
								esc_html( $background_blend )
							);
						}

						// Reset - If background has image and gradient, force background-color: initial.
						if ( $has_background_color_gradient && $has_background_image && $background_blend_inherit !== $background_blend_default ) {
							$has_background_gradient_and_image = true;
							$background_color_style            = 'initial';
							$background_style                 .= 'background-color: initial; ';
						}

						$processed_background_blend = $background_blend;
					}

					// Only append background image when the image is exist.
					$background_images[] = sprintf( 'url(%1$s)', esc_html( $background_image ) );
				} elseif ( '' === $background_image ) {
					// Reset - If background image is disabled, ensure we reset prev background blend mode.
					if ( '' !== $processed_background_blend ) {
						$background_style          .= 'background-blend-mode: normal; ';
						$processed_background_blend = '';
					}

					$is_background_image_disabled = true;
				}

				if ( ! empty( $background_images ) ) {
					// The browsers stack the images in the opposite order to what you'd expect.
					if ( 'on' !== $background_color_gradient_overlays_image ) {
						$background_images = array_reverse( $background_images );
					}

					// Set background image styles only it's different compared to the larger device.
					$background_image_style = join( ', ', $background_images );
					if ( $processed_background_image !== $background_image_style ) {
						$background_style .= sprintf(
							'background-image: %1$s !important;',
							esc_html( $background_image_style )
						);
					}
				} elseif ( ! $is_desktop && $is_background_color_gradient_disabled && $is_background_image_disabled ) {
					// Reset - If background image and gradient are disabled, reset current background image.
					$background_image_style = 'initial';
					$background_style      .= 'background-image: initial !important;';
				}

				// Save processed background images.
				$processed_background_image = $background_image_style;

				// C. Background Color.
				if ( ! $has_background_gradient_and_image ) {
					// Background color `initial` was added by default to reset button background
					// color when user disable it on mobile preview mode. However, it should
					// be applied only when the background color is really disabled because user
					// may use theme customizer to setup global button background color. We also
					// need to ensure user still able to disable background color on mobile.
					$background_color_enable  = ET_Builder_Element::$_->array_get( $this->props, "{$background_prefix}enable_color{$suffix}", '' );
					$background_color_initial = 'off' === $background_color_enable && ! $is_desktop ? 'initial' : '';

					$background_color       = et_pb_responsive_options()->get_inheritance_background_value( $this->props, "{$background_prefix}color", $device, $background_base_name, $this->fields_unprocessed );
					$background_color       = '' !== $background_color ? $background_color : $background_color_initial;
					$background_color_style = $background_color;

					if ( '' !== $background_color && $processed_background_color !== $background_color ) {
						$background_style .= sprintf(
							'background-color: %1$s; ',
							esc_html( $background_color )
						);
					}
				}

				// Save processed background color.
				$processed_background_color = $background_color_style;

				// Print background gradient and image styles.
				if ( '' !== $background_style ) {
					$background_style_attrs = array(
						'selector'    => $css_element['normal'],
						'declaration' => rtrim( $background_style ),
						'priority'    => $this->_style_priority,
					);

					// Add media query attribute to background style attrs.
					if ( 'desktop' !== $device ) {
						$current_media_query                   = 'tablet' === $device ? 'max_width_980' : 'max_width_767';
						$background_style_attrs['media_query'] = ET_Builder_Element::get_media_query( $current_media_query );
					}

					ET_Builder_Element::set_style( $function_name, $background_style_attrs );
				}
			}

			// Background Hover.
			if ( et_builder_is_hover_enabled( "{$basename}_color", $this->props ) ) {

				$background_base_name    = $basename;
				$background_prefix       = "{$basename}_";
				$background_images_hover = array();
				$background_hover_style  = '';

				$has_background_color_gradient_hover         = false;
				$has_background_image_hover                  = false;
				$has_background_gradient_and_image_hover     = false;
				$is_background_color_gradient_hover_disabled = false;
				$is_background_image_hover_disabled          = false;

				$background_color_gradient_overlays_image_desktop = et_pb_responsive_options()->get_any_value( $this->props, "{$background_prefix}color_gradient_overlays_image", 'off', true );

				$gradient_properties_desktop = array(
					'type'             => et_pb_responsive_options()->get_any_value( $this->props, "{$background_prefix}color_gradient_type", '', true ),
					'direction'        => et_pb_responsive_options()->get_any_value( $this->props, "{$background_prefix}color_gradient_direction", '', true ),
					'radial_direction' => et_pb_responsive_options()->get_any_value( $this->props, "{$background_prefix}color_gradient_direction_radial", '', true ),
					'color_start'      => et_pb_responsive_options()->get_any_value( $this->props, "{$background_prefix}color_gradient_start", '', true ),
					'color_end'        => et_pb_responsive_options()->get_any_value( $this->props, "{$background_prefix}color_gradient_end", '', true ),
					'start_position'   => et_pb_responsive_options()->get_any_value( $this->props, "{$background_prefix}color_gradient_start_position", '', true ),
					'end_position'     => et_pb_responsive_options()->get_any_value( $this->props, "{$background_prefix}color_gradient_end_position", '', true ),
				);

				$background_color_gradient_overlays_image_hover = 'off';

				// Background Gradient Hover.
				// This part is little bit different compared to other hover implementation. In
				// this case, hover is enabled on the background field, not on the each of those
				// fields. So, built in function get_value() doesn't work in this case.
				// Temporarily, we need to fetch the the value from get_raw_value().
				$use_background_color_gradient_hover = et_pb_responsive_options()->get_inheritance_background_value( $this->props, "{$background_prefix}use_color_gradient", 'hover', $background_base_name, $this->fields_unprocessed );

				if ( 'on' === $use_background_color_gradient_hover ) {
					// Desktop value as default.
					$background_color_gradient_type_desktop             = ET_Builder_Element::$_->array_get( $gradient_properties_desktop, 'type', '' );
					$background_color_gradient_direction_desktop        = ET_Builder_Element::$_->array_get( $gradient_properties_desktop, 'direction', '' );
					$background_color_gradient_radial_direction_desktop = ET_Builder_Element::$_->array_get( $gradient_properties_desktop, 'radial_direction', '' );
					$background_color_gradient_color_start_desktop      = ET_Builder_Element::$_->array_get( $gradient_properties_desktop, 'color_start', '' );
					$background_color_gradient_color_end_desktop        = ET_Builder_Element::$_->array_get( $gradient_properties_desktop, 'color_end', '' );
					$background_color_gradient_start_position_desktop   = ET_Builder_Element::$_->array_get( $gradient_properties_desktop, 'start_position', '' );
					$background_color_gradient_end_position_desktop     = ET_Builder_Element::$_->array_get( $gradient_properties_desktop, 'end_position', '' );

					// Hover value.
					$background_color_gradient_type_hover             = et_pb_hover_options()->get_raw_value( "{$background_prefix}color_gradient_type", $this->props, $background_color_gradient_type_desktop );
					$background_color_gradient_direction_hover        = et_pb_hover_options()->get_raw_value( "{$background_prefix}color_gradient_direction", $this->props, $background_color_gradient_direction_desktop );
					$background_color_gradient_direction_radial_hover = et_pb_hover_options()->get_raw_value( "{$background_prefix}color_gradient_direction_radial", $this->props, $background_color_gradient_radial_direction_desktop );
					$background_color_gradient_start_hover            = et_pb_hover_options()->get_raw_value( "{$background_prefix}color_gradient_start", $this->props, $background_color_gradient_color_start_desktop );
					$background_color_gradient_end_hover              = et_pb_hover_options()->get_raw_value( "{$background_prefix}color_gradient_end", $this->props, $background_color_gradient_color_end_desktop );
					$background_color_gradient_start_position_hover   = et_pb_hover_options()->get_raw_value( "{$background_prefix}color_gradient_start_position", $this->props, $background_color_gradient_start_position_desktop );
					$background_color_gradient_end_position_hover     = et_pb_hover_options()->get_raw_value( "{$background_prefix}color_gradient_end_position", $this->props, $background_color_gradient_end_position_desktop );
					$background_color_gradient_overlays_image_hover   = et_pb_hover_options()->get_raw_value( "{$background_prefix}color_gradient_overlays_image", $this->props, $background_color_gradient_overlays_image_desktop );

					$has_background_color_gradient_hover = true;

					$gradient_values_hover = array(
						'type'             => '' !== $background_color_gradient_type_hover ? $background_color_gradient_type_hover : $background_color_gradient_type_desktop,
						'direction'        => '' !== $background_color_gradient_direction_hover ? $background_color_gradient_direction_hover : $background_color_gradient_direction_desktop,
						'radial_direction' => '' !== $background_color_gradient_direction_radial_hover ? $background_color_gradient_direction_radial_hover : $background_color_gradient_radial_direction_desktop,
						'color_start'      => '' !== $background_color_gradient_start_hover ? $background_color_gradient_start_hover : $background_color_gradient_color_start_desktop,
						'color_end'        => '' !== $background_color_gradient_end_hover ? $background_color_gradient_end_hover : $background_color_gradient_color_end_desktop,
						'start_position'   => '' !== $background_color_gradient_start_position_hover ? $background_color_gradient_start_position_hover : $background_color_gradient_start_position_desktop,
						'end_position'     => '' !== $background_color_gradient_end_position_hover ? $background_color_gradient_end_position_hover : $background_color_gradient_end_position_desktop,
					);

					$background_images_hover[] = $this->get_gradient( $gradient_values_hover );
				} elseif ( 'off' === $use_background_color_gradient_hover ) {
					$is_background_color_gradient_hover_disabled = true;
				}

				// Background Image Hover.
				// This part is little bit different compared to other hover implementation. In
				// this case, hover is enabled on the background field, not on the each of those
				// fields. So, built in function get_value() doesn't work in this case.
				// Temporarily, we need to fetch the the value from get_raw_value().
				$background_image_hover = et_pb_responsive_options()->get_inheritance_background_value( $this->props, "{$background_prefix}image", 'hover', $background_base_name, $this->fields_unprocessed );
				$parallax_hover         = et_pb_hover_options()->get_raw_value( "{$background_prefix}parallax", $this->props );

				if ( '' !== $background_image_hover && null !== $background_image_hover && 'on' !== $parallax_hover ) {
					// Flag to inform BG Color if current module has Image.
					$has_background_image_hover = true;

					// Size.
					$background_size_hover   = et_pb_hover_options()->get_raw_value( "{$background_prefix}size", $this->props );
					$background_size_desktop = ET_Builder_Element::$_->array_get( $this->props, "{$background_prefix}size", '' );
					$is_same_background_size = $background_size_hover === $background_size_desktop;
					if ( empty( $background_size_hover ) && ! empty( $background_size_desktop ) ) {
						$background_size_hover = $background_size_desktop;
					}

					if ( ! empty( $background_size_hover ) && ! $is_same_background_size ) {
						$background_hover_style .= sprintf(
							'background-size: %1$s; ',
							esc_html( $background_size_hover )
						);
					}

					// Position.
					$background_position_hover   = et_pb_hover_options()->get_raw_value( "{$background_prefix}position", $this->props );
					$background_position_desktop = ET_Builder_Element::$_->array_get( $this->props, "{$background_prefix}position", '' );
					$is_same_background_position = $background_position_hover === $background_position_desktop;
					if ( empty( $background_position_hover ) && ! empty( $background_position_desktop ) ) {
						$background_position_hover = $background_position_desktop;
					}

					if ( ! empty( $background_position_hover ) && ! $is_same_background_position ) {
						$background_hover_style .= sprintf(
							'background-position: %1$s; ',
							esc_html( str_replace( '_', ' ', $background_position_hover ) )
						);
					}

					// Repeat.
					$background_repeat_hover   = et_pb_hover_options()->get_raw_value( "{$background_prefix}repeat", $this->props );
					$background_repeat_desktop = ET_Builder_Element::$_->array_get( $this->props, "{$background_prefix}repeat", '' );
					$is_same_background_repeat = $background_repeat_hover === $background_repeat_desktop;
					if ( empty( $background_repeat_hover ) && ! empty( $background_repeat_desktop ) ) {
						$background_repeat_hover = $background_repeat_desktop;
					}

					if ( ! empty( $background_repeat_hover ) && ! $is_same_background_repeat ) {
						$background_hover_style .= sprintf(
							'background-repeat: %1$s; ',
							esc_html( $background_repeat_hover )
						);
					}

					// Blend.
					$background_blend_hover   = et_pb_hover_options()->get_raw_value( "{$background_prefix}blend", $this->props );
					$background_blend_default = ET_Builder_Element::$_->array_get( $this->fields_unprocessed, "{$background_prefix}blend.default", '' );
					$background_blend_desktop = ET_Builder_Element::$_->array_get( $this->props, "{$background_prefix}blend", '' );
					$is_same_background_blend = $background_blend_hover === $background_blend_desktop;
					if ( empty( $background_blend_hover ) && ! empty( $background_blend_desktop ) ) {
						$background_blend_hover = $background_blend_desktop;
					}

					if ( ! empty( $background_blend_hover ) ) {
						if ( ! $is_same_background_blend ) {
							$background_hover_style .= sprintf(
								'background-blend-mode: %1$s; ',
								esc_html( $background_blend_hover )
							);
						}

						// Force background-color: initial.
						if ( $has_background_color_gradient_hover && $has_background_image_hover && $background_blend_hover !== $background_blend_default ) {
							$has_background_gradient_and_image_hover = true;
							$background_hover_style                 .= 'background-color: initial !important;';
						}
					}

					// Only append background image when the image exists.
					$background_images_hover[] = sprintf( 'url(%1$s)', esc_html( $background_image_hover ) );
				} elseif ( '' === $background_image_hover ) {
					$is_background_image_hover_disabled = true;
				}

				if ( ! empty( $background_images_hover ) ) {
					// The browsers stack the images in the opposite order to what you'd expect.
					if ( 'on' !== $background_color_gradient_overlays_image_hover ) {
						$background_images_hover = array_reverse( $background_images_hover );
					}

					$background_hover_style .= sprintf(
						'background-image: %1$s !important;',
						esc_html( join( ', ', $background_images_hover ) )
					);
				} elseif ( $is_background_color_gradient_hover_disabled && $is_background_image_hover_disabled ) {
					$background_hover_style .= 'background-image: initial !important;';
				}

				// Background Color Hover.
				if ( ! $has_background_gradient_and_image_hover ) {
					$background_color_hover = et_pb_responsive_options()->get_inheritance_background_value( $this->props, "{$background_prefix}color", 'hover', $background_base_name, $this->fields_unprocessed );
					$background_color_hover = '' !== $background_color_hover ? $background_color_hover : 'transparent';

					if ( '' !== $background_color_hover ) {
						$background_hover_style .= sprintf(
							'background-color: %1$s !important; ',
							esc_html( $background_color_hover )
						);
					}
				}

				// Print background hover gradient and image styles.
				if ( '' !== $background_hover_style ) {
					$background_hover_style_attrs = array(
						'selector'    => $css_element['hover'],
						'declaration' => rtrim( $background_hover_style ),
						'priority'    => $this->_style_priority,
					);

					ET_Builder_Element::set_style( $function_name, $background_hover_style_attrs );
				}
			}
		}
	}
}
new El_AdvancedFlipBox;