<?php
/**
 * The Template for displaying Fipbox Layout
 *
 * This template can be overridden by copying it to yourtheme/divi-blurb-extended/layouts/flipbox.php.
 *
 * HOWEVER, on occasion divi-blurb-extended will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen.
 *
 * @author      Elicus Technologies <hello@elicus.com>
 * @link        https://elicus.com/
 * @copyright   2020 Elicus Technologies Private Limited
 * @version     2.1.0
 */
 
if ( 'color' === $fb_front_background ) {
	if ( '' !== $fb_front_color ) {
		ET_Builder_Element::set_style( $render_slug, array(
			'selector'      => '%%order_class%% .front',
			'declaration'   => sprintf( 'background-color: %1$s;', esc_html( $fb_front_color ) ),
		));
	}
}

if ( 'image' === $fb_front_background ) {
	if ( '' !== $fb_front_image ) {
		ET_Builder_Element::set_style( $render_slug, array(
			'selector'      => '%%order_class%% .front',
			'declaration'   => sprintf( 'background-image: url(%1$s); background-size: cover; background-position: center; background-repeat: no-repeat;', esc_html( $fb_front_image ) ),
		));
	} else {
		ET_Builder_Element::set_style( $render_slug, array(
			'selector'      => '%%order_class%% .front',
			'declaration'   => 'background: #fff;',
		));
	}
}

if ( 'color' === $fb_back_background ) {
	if ( '' !== $fb_back_color ) {
		ET_Builder_Element::set_style( $render_slug, array(
			'selector'      => '%%order_class%% .back',
			'declaration'   => sprintf( 'background-color: %1$s;', esc_html( $fb_back_color ) ),
		));
	}
}

if ( 'image' === $fb_back_background ) {
	if ( '' !== $fb_back_image ) {
		ET_Builder_Element::set_style( $render_slug, array(
			'selector'      => '%%order_class%% .back',
			'declaration'   => sprintf( 'background-image: url(%1$s); background-size: cover; background-position: center; background-repeat: no-repeat;', esc_html( $fb_back_image ) ),
		));
	} else {
		ET_Builder_Element::set_style( $render_slug, array(
			'selector'      => '%%order_class%% .back',
			'declaration'   => 'background: #fff;',
		));
	}
}

if ( '' !== $fb_height || '' !== $fb_height_tablet || '' !== $fb_height_phone ) {
	$fb_height_selector = '%%order_class%% .flipbox .et_pb_blurb_content';
	$fb_height_responsive_active = et_pb_get_responsive_status( $fb_height_last_edited );

	$fb_height_values = array(
		'desktop' => $fb_height,
		'tablet'  => $fb_height_responsive_active ? $fb_height_tablet : '',
		'phone'   => $fb_height_responsive_active ? $fb_height_phone : '',
	);

	et_pb_generate_responsive_css( $fb_height_values, $fb_height_selector, 'height', $render_slug );
}

if ( 'off' !== $read_more_button ) {
    $read_more_text     = ( '' !== $read_more_text )     ? esc_html( $read_more_text ) : 'Read more';
    $url                = ( '' !== $url ) ? esc_url( $url ) : '#';
    $read_more_button = $this->render_button( array(
        'button_text'      => esc_html__( $read_more_text, 'divi-blurb-extended' ),
        'button_url'       => $url,
        'button_custom'    => esc_html( $custom_read_more ),
        'custom_icon'      => $read_more_icon,
        'has_wrapper'      => false,
        'url_new_window'   => esc_html( $url_new_window ),
        'button_classname' => array( 'et_pb_more_button' ),
    ) );

    $button = '<span class="et_pb_blurb_extended_btn">'. $read_more_button .'</span>';
} else {
    $button = '';
}

$blurb_content  = __( wp_kses_post( $this->content ), 'divi-blurb-extended' );

$layout = '<div class="et_pb_blurb_content">
                <div class="front">
                    <div class="before-flip">
                        <div class="before-flip-content">' . $image . '
                            <div class="et_pb_blurb_container">
                		    ' . $title . '
                            </div>
                        </div>
                    </div>
                </div>
                <div class="back">
                    <div class="after-flip">
        	            <div class="et_pb_blurb_container">
            		    '. $title .'
                		    <div class="et_pb_blurb_description">'
                		     . $blurb_content .
                		     $button .
            	            '</div>
        	            </div>
        	        </div>
        	   </div>
            </div> <!-- .et_pb_blurb_content -->';
