<?php
/**
 * The Template for displaying Easebox Layout
 *
 * This template can be overridden by copying it to yourtheme/divi-blurb-extended/layouts/easebox.php.
 *
 * HOWEVER, on occasion divi-blurb-extended will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen.
 *
 * @author      Elicus Technologies <hello@elicus.com>
 * @link        https://elicus.com/
 * @copyright   2020 Elicus Technologies Private Limited
 * @version     2.1.0
 */
 
if ( 'off' !== $read_more_button ) {
    $read_more_text     = ( '' !== $read_more_text )     ? esc_html( $read_more_text ) : 'Read more';
    $url                = ( '' !== $url ) ? esc_url( $url ) : '#';
    $read_more_button = $this->render_button( array(
        'button_text'      => esc_html__( $read_more_text, 'divi-blurb-extended' ),
        'button_url'       => $url,
        'button_custom'    => esc_html( $custom_read_more ),
        'custom_icon'      => $read_more_icon,
        'has_wrapper'      => false,
        'url_new_window'   => esc_html( $url_new_window ),
        'button_classname' => array( 'et_pb_more_button' ),
    ) );

    $button = '<span class="et_pb_blurb_extended_btn">'. $read_more_button .'</span>';
} else {
    $button = '';
}

$blurb_content  = __( wp_kses_post( $this->content ), 'divi-blurb-extended' );

$layout = 	'<div class="et_pb_blurb_content">'
                . $image .'
                <div class="et_pb_blurb_container">
    		    '. $title .'
        		    <div class="et_pb_blurb_description">'
        		     . $blurb_content .
        		     $button .
    	            '</div>
	            </div>
            </div> <!-- .et_pb_blurb_content -->';
