<?php
/**
 * The Template for displaying Borderbox Layout
 *
 * This template can be overridden by copying it to yourtheme/divi-blurb-extended/layouts/borderbox.php.
 *
 * HOWEVER, on occasion divi-blurb-extended will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen.
 *
 * @author      Elicus Technologies <hello@elicus.com>
 * @link        https://elicus.com/
 * @copyright   2023 Elicus Technologies Private Limited
 * @version     2.2.8
 */

 if ( $this->props['custom_padding'] ) {

	$all_values		 	   	= $this->props;
	$responsive      		= ET_Builder_Module_Helper_ResponsiveOptions::instance();
	$is_padding_responsive 	= $responsive->is_responsive_enabled( $all_values, "custom_padding" );

	$padding_desktop = $responsive->get_any_value( $all_values, "custom_padding" );
	$padding_tablet  = $is_padding_responsive ? $responsive->get_any_value( $all_values, "custom_padding_tablet" ) : '';
	$padding_phone   = $is_padding_responsive ? $responsive->get_any_value( $all_values, "custom_padding_phone" ) : '';

	$padding_top_values = array(
		'desktop' => '' !== $padding_desktop 	? trim( explode( '|', $padding_desktop )[0] )   : '',
		'tablet'  => '' !== $padding_tablet 	? trim( explode( '|', $padding_tablet )[0] ) 	: '',
		'phone'   => '' !== $padding_phone  	? trim( explode( '|', $padding_phone )[0] ) 	: '',
	);

	$padding_right_values = array(
		'desktop' => '' !== $padding_desktop 	? trim( explode( '|', $padding_desktop )[1] )   : '',
		'tablet'  => '' !== $padding_tablet 	? trim( explode( '|', $padding_tablet )[1] ) 	: '',
		'phone'   => '' !== $padding_phone  	? trim( explode( '|', $padding_phone )[1] ) 	: '',
	);

	$padding_left_values = array(
		'desktop' => '' !== $padding_desktop 	? trim( explode( '|', $padding_desktop )[3] )   : '',
		'tablet'  => '' !== $padding_tablet 	? trim( explode( '|', $padding_tablet )[3] ) 	: '',
		'phone'   => '' !== $padding_phone  	? trim( explode( '|', $padding_phone )[3] ) 	: '',
	);
}

$alignicon = ( 'left' === $text_orientation || 'justified' === $text_orientation ) ? 'left' : 'right';

if ( 'on' === $use_icon ) {
	if ( 'off' === $use_icon_font_size ) {
		
		$position = '-16px';
		
		if ( 'on' === $style_icon ) {
			$position = ( 'on' === $use_shape_border )  ? '-34px'   : '-32px';
		}

		/* Add position to icon */
		ET_Builder_Element::set_style( $render_slug, array(
			'selector'      => '%%order_class%% .borderbox .et_pb_main_blurb_image',
			'declaration'   => sprintf( '%1$s: %2$s;', esc_html( $icon_placement ), esc_html( $position ) ),
		));

		/* Add padding to container */
		ET_Builder_Element::set_style( $render_slug, array(
			'selector'      => '%%order_class%% .borderbox .et_pb_blurb_container',
			'declaration'   => sprintf( 'padding-%1$s: %2$s;', esc_html( $icon_placement ), esc_html( abs( floatval( $position ) ) . 'px' ) ),
		));

		/* Add padding to blurb */
		ET_Builder_Element::set_style( $render_slug, array(
			'selector'      => '%%order_class%%',
			'declaration'   => sprintf( 'padding-%1$s: %2$s;', esc_html( $icon_placement ), esc_html( abs( floatval( $position ) ) . 'px' ) ),
		));	
	} else {

		$position_units = array(
			'desktop'   => str_replace( floatval( $font_size_values['desktop'] ), '', (string) $font_size_values['desktop'] ),
			'tablet'    => str_replace( floatval( $font_size_values['tablet'] ), '', (string) $font_size_values['tablet'] ),
			'phone'     => str_replace( floatval( $font_size_values['phone'] ), '', (string) $font_size_values['phone'] ),
		);

		$position_values = array(
			'desktop' => '-' . floatval( floatval( $icon_font_size ) / 2 ) . $position_units['desktop'],
			'tablet'  => ! empty( $font_size_values['tablet'] )	?
						 '-' . floatval( floatval( $font_size_values['tablet'] ) / 2 ) . $position_units['tablet'] :
						 '',
			'phone'   => ! empty( $font_size_values['phone'] ) ?
						 '-' . floatval( floatval( $font_size_values['phone'] ) / 2 ) . $position_units['phone'] :
						 '',
		);

		$padding_values = array(
			'desktop' => floatval( floatval( $icon_font_size ) / 2 ) . $position_units['desktop'],
			'tablet'  => ! empty( $font_size_values['tablet'] ) ?
						 floatval( floatval( $font_size_values['tablet'] ) / 2 ) . $position_units['tablet'] :
						 '',
			'phone'   => ! empty( $font_size_values['phone'] ) ?
						 floatval( floatval( $font_size_values['phone'] ) / 2 ) . $position_units['phone'] :
						 '',
		);

		if ( 'on' === $style_icon ) {
			$position_values = array(
				'desktop' => 'px' === $position_units['desktop'] ?
							 '-' . floatval( ( floatval( $icon_font_size ) + 32 ) / 2 ) . 'px' :
							 'calc(-' . floatval( floatval( $icon_font_size ) / 2 ) . $position_units['desktop'] . ' - 16px)',
				'tablet'  => ! empty( $font_size_values['tablet'] ) ?
							 'px' === $position_units['tablet'] ?
							 '-' . floatval( ( floatval( $font_size_values['tablet'] ) + 32 ) / 2 ) . 'px' :
							 'calc(-' . floatval( floatval( $font_size_values['tablet'] ) / 2 ) . $position_units['tablet'] . ' - 16px)' :
							 '',
				'phone'   => ! empty( $font_size_values['phone'] ) ?
							 'px' === $position_units['phone'] ?
							 '-' . floatval( ( floatval( $font_size_values['phone'] ) + 32 ) / 2 ) . 'px' :
							 'calc(-' . floatval( floatval( $font_size_values['phone'] ) / 2 ) . $position_units['phone'] . ' - 16px)' :
							 '',
			);

			$padding_values = array(
				'desktop' => 'px' === $position_units['desktop'] ?
							 floatval( ( floatval( $icon_font_size ) + 32 ) / 2 ) . 'px' :
							 'calc(' . floatval( floatval( $icon_font_size ) / 2 ) . $position_units['desktop'] . ' + 16px)',
				'tablet'  => ! empty( $font_size_values['tablet'] ) ?
							 'px' === $position_units['tablet'] ?
							 floatval( ( floatval( $font_size_values['tablet'] ) + 32 ) / 2 ) . 'px' :
							 'calc(' . floatval( floatval( $font_size_values['tablet'] ) / 2 ) . $position_units['tablet'] . ' + 16px)' :
							 '',
				'phone'   => ! empty( $font_size_values['phone'] ) ?
							 'px' === $position_units['phone'] ?
							 floatval( ( floatval( $font_size_values['phone'] ) + 32 ) / 2 ) . 'px' :
							 'calc(' . floatval( floatval( $font_size_values['phone'] ) / 2 ) . $position_units['phone'] . ' + 16px)' :
							 '',
			);
			
			if ( 'on' === $use_shape_border ) {
				$position_values = array(
					'desktop' => 'px' === $position_units['desktop'] ?
								 '-' . floatval( ( floatval( $icon_font_size ) + 36 ) / 2 ) . 'px' :
								 'calc(-' . floatval( floatval( $icon_font_size ) / 2 ) . $position_units['desktop'] . ' - 18px)',
					'tablet'  => ! empty( $font_size_values['tablet'] ) ?
								 'px' === $position_units['tablet'] ?
								 '-' . floatval( ( floatval( $font_size_values['tablet'] ) + 36 ) / 2 ) . 'px' :
								 'calc(-' . floatval( floatval( $font_size_values['tablet'] ) / 2 ) . $position_units['tablet'] . ' - 18px)' :
								 '',
					'phone'   => ! empty( $font_size_values['phone'] ) ?
								 'px' === $position_units['phone'] ?
								 '-' . floatval( ( floatval( $font_size_values['phone'] ) + 36 ) / 2 ) . 'px' :
								 'calc(-' . floatval( floatval( $font_size_values['phone'] ) / 2 ) . $position_units['phone'] . ' - 18px)' :
								 '',
				);

				$padding_values = array(
					'desktop' => 'px' === $position_units['desktop'] ?
								 floatval( ( floatval( $icon_font_size ) + 36 ) / 2 ) . 'px' :
								 'calc(' . floatval( floatval( $icon_font_size ) / 2 ) . $position_units['desktop'] . ' + 18px)',
					'tablet'  => ! empty( $font_size_values['tablet'] ) ?
								 'px' === $position_units['tablet'] ?
								 floatval( ( floatval( $font_size_values['tablet'] ) + 36 ) / 2 ) . 'px' :
								 'calc(' . floatval( floatval( $font_size_values['tablet'] ) / 2 ) . $position_units['tablet'] . ' + 18px)' :
								 '',
					'phone'   => ! empty( $font_size_values['phone'] ) ?
								 'px' === $position_units['phone'] ?
								 floatval( ( floatval( $font_size_values['phone'] ) + 36 ) / 2 ) . 'px' :
								 'calc(' . floatval( floatval( $font_size_values['phone'] ) / 2 ) . $position_units['phone'] . ' + 18px)' :
								 '',
				);
			}
		}

		/* Add position to icon */
		$position_selector = '%%order_class%% .borderbox .et_pb_main_blurb_image';
		$position_property = esc_html( $icon_placement );
		et_pb_generate_responsive_css( $position_values, $position_selector, $position_property, $render_slug );

		/* Add padding to container */
		$padding_selector = '%%order_class%% .borderbox .et_pb_blurb_container';
		$padding_property = 'padding-' . esc_html( $icon_placement );
		et_pb_generate_responsive_css( $padding_values, $padding_selector, $padding_property, $render_slug );

		/* Add padding to blurb */
		$padding_selector = '%%order_class%%';
		et_pb_generate_responsive_css( $padding_values, $padding_selector, $padding_property, $render_slug );
	}
} else {
	$position_values = array(
		'desktop' => '-' . floatval( floatval( $image_max_width ) / 2 ) . 'px',
		'tablet'  => ! empty( $image_max_width_values['tablet'] ) ?
					 '-' . floatval( floatval( $image_max_width_values['tablet'] ) / 2 ) . 'px' :
					 '',
		'phone'   => ! empty( $image_max_width_values['phone'] ) ?
					 '-' . floatval( floatval( $image_max_width_values['phone'] ) / 2 ) . 'px' :
					 '',
	);

	/* Add position to image */
	$position_selector = '%%order_class%% .borderbox .et_pb_main_blurb_image';
	$position_property = esc_html( $icon_placement );
	et_pb_generate_responsive_css( $position_values, $position_selector, $position_property, $render_slug );

	/* Add padding to blurb container */
	$padding_selector = '%%order_class%% .borderbox .et_pb_blurb_container';
	$padding_property = 'padding-' . esc_html( $icon_placement );
	$position_values  = array_filter( $position_values );
	$position_values  = array_map( 'floatval', $position_values );
	et_pb_generate_responsive_css( array_map( 'abs', $position_values ), $padding_selector, $padding_property, $render_slug );

	/* Add padding to blurb */
	$padding_selector = '%%order_class%%';
	et_pb_generate_responsive_css( array_map( 'abs', $position_values ), $padding_selector, $padding_property, $render_slug );

	if ( 'top' === $icon_placement ) {
		/* Add height to image */
		$height_selector = '%%order_class%% .borderbox .et_pb_main_blurb_image';
		$height_property = 'height';
		et_pb_generate_responsive_css( $image_max_width_values, $height_selector, $height_property, $render_slug );
	}
}

if ( 'top' !== $icon_placement ) {
	/* Add top position to icon */
	$position_selector = '%%order_class%% .borderbox .et_pb_main_blurb_image';
	$position_property = 'top';
	if ( isset( $padding_top_values ) && ! empty( $padding_top_values ) ) {
		et_pb_generate_responsive_css( $padding_top_values, $position_selector, $position_property, $render_slug );
	} else {
		ET_Builder_Element::set_style( $render_slug, array(
			'selector'      => $position_selector,
			'declaration'   => sprintf( '%1$s: %2$s;', esc_html( $position_property ), '20px' ),
		));
	}
}

if ( 'top' === $icon_placement && 'center' !== $text_orientation ) {
	/* Add left/right position to icon */
	$position_selector = '%%order_class%% .borderbox .et_pb_main_blurb_image';
	$position_property = $alignicon;
	if ( isset( ${"padding_{$alignicon}_values"} ) && ! empty( ${"padding_{$alignicon}_values"} ) ) {
		et_pb_generate_responsive_css( ${"padding_{$alignicon}_values"}, $position_selector, $position_property, $render_slug );
	} else {
		ET_Builder_Element::set_style( $render_slug, array(
			'selector'      => $position_selector,
			'declaration'   => sprintf( '%1$s: %2$s;', esc_html( $position_property ), '20px' ),
		));
	}
}

if ( 'top' === $icon_placement && 'center' === $text_orientation ) {
	ET_Builder_Element::set_style( $render_slug, array(
		'selector'      => '%%order_class%% .borderbox .et_pb_main_blurb_image',
		'declaration'   => 'left: -9999px; right: -9999px; width: 100%; margin: 0 auto;',
	));
}

if ( '' !== $borderbox_border_color ) {
	ET_Builder_Element::set_style( $render_slug, array(
		'selector'      => '%%order_class%% .' . esc_html( $blurb_layout ) . ' .et_pb_blurb_content',
		'declaration'   => sprintf( 'border-color: %1$s;', esc_html( $borderbox_border_color ) ),
	));
}

if ( '' !== $borderbox_hover_border_color ) {
	ET_Builder_Element::set_style( $render_slug, array(
		'selector'      => '%%order_class%% .' . esc_html( $blurb_layout ) . ':hover .et_pb_blurb_content',
		'declaration'   => sprintf( 'border-color: %1$s;', esc_html( $borderbox_hover_border_color ) ),
	));
}

if ( 'off' !== $read_more_button ) {
	$read_more_text     = ( '' !== $read_more_text ) ? esc_html( $read_more_text ) : 'Read more';
	$url                = ( '' !== $url ) ? esc_url( $url ) : '#';
	$read_more_button = $this->render_button( array(
        'button_text'      => esc_html__( $read_more_text, 'divi-blurb-extended' ),
        'button_url'       => $url,
        'button_custom'    => esc_html( $custom_read_more ),
        'custom_icon'      => $read_more_icon,
        'has_wrapper'      => false,
        'url_new_window'   => esc_html( $url_new_window ),
        'button_classname' => array( 'et_pb_more_button' ),
    ) );

	$button = '<span class="et_pb_blurb_extended_btn">'. $read_more_button .'</span>';
} else {
	$button = '';
}

$blurb_content  = __( wp_kses_post( $this->content ), 'divi-blurb-extended' );

$layout =   '<div class="et_pb_blurb_content">'
                . $image .'
                <div class="et_pb_blurb_container">
    		    '. $title .'
        		    <div class="et_pb_blurb_description">'
        		     . $blurb_content .
        		     $button .
    	            '</div>
	            </div>
            </div> <!-- .et_pb_blurb_content -->';
