<?php
/**
 * @author      Elicus Technologies <hello@elicus.com>
 * @link        https://www.elicus.com/
 * @copyright   2022 Elicus Technologies Private Limited
 * @version     2.2.6
 */

class El_DiviBlurbExtended extends DiviExtension {
	/**
	 * The gettext domain for the extension's translations.
	 *
	 * @since 1.1.0
	 *
	 * @var string
	 */
	public $gettext_domain = 'divi-blurb-extended';

	/**
	 * The extension's WP Plugin name.
	 *
	 * @since 1.1.0
	 *
	 * @var string
	 */
	public $name = 'divi-blurb-extended';

	/**
	 * The extension's version
	 *
	 * @since 1.1.0
	 *
	 * @var string
	 */
	public $version = ELICUS_BLURB_VERSION;

	/**
	 * El_DiviBlurbExtended constructor.
	 *
	 * @param string $name
	 * @param array  $args
	 */
	public function __construct( $name = 'divi-blurb-extended', $args = array() ) {
		$this->plugin_dir     = plugin_dir_path( __FILE__ );
		$this->plugin_dir_url = plugin_dir_url( $this->plugin_dir );

		add_action( 'wp_enqueue_scripts', array( $this, 'el_blurb_extended_register_scripts' ) );
        add_action( 'wp_enqueue_scripts', array( $this, 'el_blurb_extended_fb_enqueue_scripts' ) );

		parent::__construct( $name, $args );

		add_action( 'init', array( $this, 'el_blurb_extended_load_plugin_textdomain' ) );
		add_filter( 'et_pb_module_shortcode_attributes', array( $this, 'el_blurb_extended_migrate_gradient' ), 10, 5 );

		if ( is_admin() ) {
			require_once plugin_dir_path( __FILE__ ) . 'src/class-update.php';
		}
	}

	public function el_blurb_extended_register_scripts() {
		wp_register_script( 'elicus-images-loaded-script', "{$this->plugin_dir_url}scripts/imagesloaded.pkgd.min.js", array('jquery'), '4.1.4', true );
	}

	public function el_blurb_extended_fb_enqueue_scripts() {
		if ( et_core_is_fb_enabled() ) {
			wp_enqueue_script( 'elicus-images-loaded-script' );
		}
	}

	public function el_blurb_extended_load_plugin_textdomain() {
        load_plugin_textdomain( 'divi-blurb-extended', false, dirname( plugin_basename( __DIR__ ) ) . '/languages/' );
    }

    public function el_blurb_extended_exists_and_is_not_empty( $key, $array ) {
        if ( ! array_key_exists( $key, $array ) ) {
            return false;
        }

        return ! empty( $array[ $key ] );
    }

	public function el_blurb_extended_migrate_gradient( $props, $attrs, $render_slug, $_address, $content ) {
        if ( 'el_advanced_flipbox' === $render_slug && ET_BUILDER_PRODUCT_VERSION >= '4.16.0' ) {
            $basenames = array(
                'front_background',
                'back_background',
            );
            foreach( $basenames as $basename ) {
                if ( isset( $props["{$basename}_color_gradient_stops"] ) && '#2b87da 0%|#29c4a9 100%' === $props["{$basename}_color_gradient_stops"] ) {
                    if (
                        $this->el_blurb_extended_exists_and_is_not_empty( "{$basename}_color_gradient_start", $props ) &&
                        $this->el_blurb_extended_exists_and_is_not_empty( "{$basename}_color_gradient_start_position", $props ) &&
                        $this->el_blurb_extended_exists_and_is_not_empty( "{$basename}_color_gradient_end", $props ) &&
                        $this->el_blurb_extended_exists_and_is_not_empty( "{$basename}_color_gradient_end_position", $props )
                    ) {
                        // Strip percent signs and round to nearest int for our calculations.
                        $pos_start      = round( floatval( $props["{$basename}_color_gradient_start_position"] ) );
                        $pos_start_unit = trim( $props["{$basename}_color_gradient_start_position"], ',. 0..9' );
                        $pos_end        = round( floatval( $props["{$basename}_color_gradient_end_position"] ) );
                        $pos_end_unit   = trim( $props["{$basename}_color_gradient_end_position"], ',. 0..9' );
                
                        // Our sliders use percent values, but pixel values might be manually set.
                        $pos_units_match = ( $pos_start_unit === $pos_end_unit );
                
                        // If (and ONLY if) both values use the same unit of measurement,
                        // adjust the end position value to be no smaller than the start.
                        if ( $pos_units_match && $pos_end < $pos_start ) {
                            $pos_end = $pos_start;
                        }
                
                        // Prepare to receive the new gradient settings.
                        $new_values = array(
                            'start' => $props["{$basename}_color_gradient_start"] . ' ' . $pos_start . $pos_start_unit,
                            'end'   => $props["{$basename}_color_gradient_end"] . ' ' . $pos_end . $pos_end_unit,
                        );
                        
                        $props["{$basename}_color_gradient_stops"] = implode( '|', $new_values );
                        
                        $is_responsive_enabled = et_pb_responsive_options()->is_responsive_enabled( $props, "{$basename}_color" );
                        if ( $is_responsive_enabled ) {
                            if ( $this->el_blurb_extended_exists_and_is_not_empty( "{$basename}_color_gradient_start_tablet", $props ) ) {
                                $start_color = $props["{$basename}_color_gradient_start_tablet"];
                            } else {
                                $start_color = $props["{$basename}_color_gradient_start"];
                            }

                            if ( $this->el_blurb_extended_exists_and_is_not_empty( "{$basename}_color_gradient_end_tablet", $props ) ) {
                                $end_color = $props["{$basename}_color_gradient_end_tablet"];
                            } else {
                                $end_color = $props["{$basename}_color_gradient_end"];
                            }

                            if ( $this->el_blurb_extended_exists_and_is_not_empty( "{$basename}_color_gradient_start_position_tablet", $props ) ) {
                                $pos_start = $props["{$basename}_color_gradient_start_position_tablet"];
                                $pos_start_unit = trim( $props["{$basename}_color_gradient_start_position_tablet"], ',. 0..9' );
                            } else {
                                $pos_start = $props["{$basename}_color_gradient_start_position"];
                                $pos_start_unit = trim( $props["{$basename}_color_gradient_start_position"], ',. 0..9' );
                            }

                            if ( $this->el_blurb_extended_exists_and_is_not_empty( "{$basename}_color_gradient_end_position_tablet", $props ) ) {
                                $pos_end = $props["{$basename}_color_gradient_end_position_tablet"];
                                $pos_end_unit = trim( $props["{$basename}_color_gradient_end_position_tablet"], ',. 0..9' );
                            } else {
                                $pos_end = $props["{$basename}_color_gradient_end_position"];
                                $pos_end_unit = trim( $props["{$basename}_color_gradient_end_position"], ',. 0..9' );
                            }

                            // Our sliders use percent values, but pixel values might be manually set.
                            $pos_units_match = ( $pos_start_unit === $pos_end_unit );
                    
                            // If (and ONLY if) both values use the same unit of measurement,
                            // adjust the end position value to be no smaller than the start.
                            if ( $pos_units_match && $pos_end < $pos_start ) {
                                $pos_end = $pos_start;
                            }

                            // Prepare to receive the new gradient settings.
                            $new_values = array(
                                'start' => $start_color . ' ' . $pos_start . $pos_start_unit,
                                'end'   => $end_color . ' ' . $pos_end . $pos_end_unit,
                            );
                            
                            $props["{$basename}_color_gradient_stops_tablet"] = implode( '|', $new_values );

                            if ( $this->el_blurb_extended_exists_and_is_not_empty( "{$basename}_color_gradient_start_phone", $props ) ) {
                                $start_color = $props["{$basename}_color_gradient_start_phone"];
                            }

                            if ( $this->el_blurb_extended_exists_and_is_not_empty( "{$basename}_color_gradient_end_phone", $props ) ) {
                                $end_color = $props["{$basename}_color_gradient_end_phone"];
                            }

                            if ( $this->el_blurb_extended_exists_and_is_not_empty( "{$basename}_color_gradient_start_position_phone", $props ) ) {
                                $pos_start = $props["{$basename}_color_gradient_start_position_phone"];
                                $pos_start_unit = trim( $props["{$basename}_color_gradient_start_position_phone"], ',. 0..9' );
                            }

                            if ( $this->el_blurb_extended_exists_and_is_not_empty( "{$basename}_color_gradient_end_position_phone", $props ) ) {
                                $pos_end = $props["{$basename}_color_gradient_end_position_phone"];
                                $pos_end_unit = trim( $props["{$basename}_color_gradient_end_position_phone"], ',. 0..9' );
                            }

                            // Our sliders use percent values, but pixel values might be manually set.
                            $pos_units_match = ( $pos_start_unit === $pos_end_unit );
                    
                            // If (and ONLY if) both values use the same unit of measurement,
                            // adjust the end position value to be no smaller than the start.
                            if ( $pos_units_match && $pos_end < $pos_start ) {
                                $pos_end = $pos_start;
                            }

                            // Prepare to receive the new gradient settings.
                            $new_values = array(
                                'start' => $start_color . ' ' . $pos_start . $pos_start_unit,
                                'end'   => $end_color . ' ' . $pos_end . $pos_end_unit,
                            );
                            
                            $props["{$basename}_color_gradient_stops_phone"] = implode( '|', $new_values );
                        }
                        
                        $is_hover_enabled = et_pb_hover_options()->is_enabled( "{$basename}_color", $props );
                        if ( $is_hover_enabled ) {
                            if ( isset(
                                 $props["{$basename}_color_gradient_start__hover"],
                                 $props["{$basename}_color_gradient_start_position__hover"],
                                 $props["{$basename}_color_gradient_end__hover"],
                                 $props["{$basename}_color_gradient_end_position__hover"]
                                 )
                            ) {
                                // Strip percent signs and round to nearest int for our calculations.
                                $pos_start      = round( floatval( $props["{$basename}_color_gradient_start_position__hover"] ) );
                                $pos_start_unit = trim( $props["{$basename}_color_gradient_start_position__hover"], ',. 0..9' );
                                $pos_end        = round( floatval( $props["{$basename}_color_gradient_end_position__hover"] ) );
                                $pos_end_unit   = trim( $props["{$basename}_color_gradient_end_position__hover"], ',. 0..9' );
                        
                                // Our sliders use percent values, but pixel values might be manually set.
                                $pos_units_match = ( $pos_start_unit === $pos_end_unit );
                        
                                // If (and ONLY if) both values use the same unit of measurement,
                                // adjust the end position value to be no smaller than the start.
                                if ( $pos_units_match && $pos_end < $pos_start ) {
                                    $pos_end = $pos_start;
                                }
                        
                                // Prepare to receive the new gradient settings.
                                $new_values = array(
                                    'start' => $props["{$basename}_color_gradient_start__hover"] . ' ' . $pos_start . $pos_start_unit,
                                    'end'   => $props["{$basename}_color_gradient_end__hover"] . ' ' . $pos_end . $pos_end_unit,
                                );
                                
                                $props["{$basename}_color_gradient_stops__hover"] = implode( '|', $new_values );
                            }
                        }
                    }
                }
                if ( $this->el_blurb_extended_exists_and_is_not_empty( "{$basename}_color_gradient_type", $props ) && 'radial' === $props["{$basename}_color_gradient_type"] ) {
                    $props["{$basename}_color_gradient_type"] = 'circular';
                    $is_responsive_enabled = et_pb_responsive_options()->is_responsive_enabled( $props, "{$basename}_color" );
                    if ( $is_responsive_enabled ) {
                        foreach( array( 'tablet', 'phone' ) as $device ) {
                            if ( $this->el_blurb_extended_exists_and_is_not_empty( "{$basename}_color_gradient_type_{$device}", $props ) && 'radial' === $props["{$basename}_color_gradient_type_{$device}"] ) {
                                $props["{$basename}_color_gradient_type_{$device}"] = 'circular';
                            }
                        }
                    }
                    $is_hover_enabled = et_pb_hover_options()->is_enabled( "{$basename}_color", $props );
                    if ( $is_hover_enabled ) {
                        if ( $this->el_blurb_extended_exists_and_is_not_empty( "{$basename}_color_gradient_type__hover", $props ) && 'radial' === $props["{$basename}_color_gradient_type__hover"] ) {
                            $props["{$basename}_color_gradient_type__hover"] = 'circular';
                        }
                    }
                }
            }
        }

        return $props;
    }
}

new El_DiviBlurbExtended;
