<?php
/*
Plugin Name: Divi Blurb Extended
Plugin URI:  https://diviextended.com/product/divi-blurb-extended/
Description: Divi Blurb Extended is a plugin by Divi Extended which work upon Divi theme or Divi builder. Using this plugin, one can create a nice looking Divi Blurb layouts in minutes.
Version:     2.2.9
Author:      Elicus
Author URI:  https://elicus.com/
Update URI:  https://diviextended.com/
License: 	 GNU General Public License v2
License URI: http://www.gnu.org/licenses/gpl-2.0.html/
Text Domain: divi-blurb-extended
Domain Path: /languages
*/

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

define( 'ELICUS_BLURB_VERSION', '2.2.9' );
define( 'ELICUS_BLURB_OPTION', 'el-divi-blurb-extended' );
define( 'ELICUS_BLURB_BASENAME', plugin_basename( __FILE__ ) );

require_once plugin_dir_path( __FILE__ ) . 'includes/src/class-installation.php';
register_activation_hook( __FILE__, array( 'El_Blurb_Installation', 'el_plugin_add_installs' ) );
register_deactivation_hook( __FILE__, array( 'El_Blurb_Installation', 'el_plugin_remove_installs' ) );

if ( ! function_exists( 'el_blurb_initialize_extension' ) ) {
    /**
     * Creates the extension's main class instance.
     *
     * @since 1.1.0
     */
    function el_blurb_initialize_extension() {
    	require_once plugin_dir_path( __FILE__ ) . 'includes/DiviBlurbExtended.php';
    }
    add_action( 'divi_extensions_init', 'el_blurb_initialize_extension' );
} 